/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.StairsType;

public class StairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        boolean top;
        if (SideSkipPredicate.CTM.test(level, pos, state, adjState, side)) {
            return true;
        }
        Direction dir = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        boolean bl = top = state.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        if (adjState.m_60734_() == FBContent.blockFramedStairs.get()) {
            return StairsSkipPredicate.testAgainstStairs(level, pos, dir, shape, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlab.get()) {
            return StairsSkipPredicate.testAgainstSlab(level, pos, dir, shape, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedDoubleSlab.get()) {
            return StairsSkipPredicate.testAgainstDoubleSlab(level, pos, dir, shape, top, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlabEdge.get()) {
            return StairsSkipPredicate.testAgainstEdge(level, pos, dir, shape, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedPanel.get()) {
            return StairsSkipPredicate.testAgainstPanel(level, pos, dir, shape, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedDoublePanel.get()) {
            return StairsSkipPredicate.testAgainstDoublePanel(level, pos, dir, shape, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedCornerPillar.get()) {
            return StairsSkipPredicate.testAgainstPillar(level, pos, dir, shape, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedSlabCorner.get()) {
            return StairsSkipPredicate.testAgainstCorner(level, pos, dir, shape, top, adjState, side);
        }
        if (adjState.m_60734_() == FBContent.blockFramedVerticalStairs.get()) {
            return StairsSkipPredicate.testAgainstVerticalStairs(level, pos, dir, shape, top, adjState, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        if (StairsSkipPredicate.isStairSide(shape, dir, side) && StairsSkipPredicate.isStairSide(adjShape, adjDir, side.m_122424_()) || StairsSkipPredicate.isSlabSide(shape, dir, side) && StairsSkipPredicate.isSlabSide(adjShape, adjDir, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (top != adjTop) {
            return false;
        }
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, Direction side) {
        if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
            return false;
        }
        return SideSkipPredicate.compareState(level, pos, side, top ? Direction.UP : Direction.DOWN);
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (top != adjTop) {
            return false;
        }
        if (adjDir == side.m_122424_()) {
            if (!StairsSkipPredicate.isSlabSide(shape, dir, side)) {
                return false;
            }
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (top && side == Direction.DOWN || !top && side == Direction.UP) {
            if (shape != StairsShape.STRAIGHT) {
                return false;
            }
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        return dir == adjDir && SideSkipPredicate.compareState(level, pos, side);
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.STRAIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_NE);
        if (dir == adjDir || dir.m_122424_() == adjDir) {
            return SideSkipPredicate.compareState(level, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        if (shape == StairsShape.OUTER_LEFT && dir == adjDir || shape == StairsShape.OUTER_RIGHT && dir.m_122427_() == adjDir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        if (shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT) {
            return false;
        }
        if (top && side != Direction.DOWN || !top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP);
        if (shape == StairsShape.OUTER_LEFT && dir == adjDir || shape == StairsShape.OUTER_RIGHT && dir.m_122427_() == adjDir) {
            return adjTop == top && SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, StairsShape shape, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (adjType == StairsType.VERTICAL ? (side == Direction.DOWN && top || side == Direction.UP && !top) && (shape == StairsShape.INNER_LEFT && adjDir == dir || shape == StairsShape.INNER_RIGHT && adjDir == dir.m_122427_()) : adjType.isTop() != top && (side == dir.m_122427_() && adjDir == dir || side == dir.m_122428_() && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    public static boolean isStairSide(StairsShape shape, Direction dir, Direction side) {
        if (shape == StairsShape.STRAIGHT) {
            return side == dir.m_122427_() || side == dir.m_122428_();
        }
        if (shape == StairsShape.INNER_LEFT) {
            return side == dir.m_122424_() || side == dir.m_122427_();
        }
        if (shape == StairsShape.INNER_RIGHT) {
            return side == dir.m_122424_() || side == dir.m_122428_();
        }
        if (shape == StairsShape.OUTER_LEFT) {
            return side == dir || side == dir.m_122428_();
        }
        if (shape == StairsShape.OUTER_RIGHT) {
            return side == dir || side == dir.m_122427_();
        }
        return false;
    }

    public static boolean isSlabSide(StairsShape shape, Direction dir, Direction side) {
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT) {
            return false;
        }
        if (shape == StairsShape.STRAIGHT) {
            return side == dir.m_122424_();
        }
        if (shape == StairsShape.OUTER_LEFT) {
            return side == dir.m_122424_() || side == dir.m_122427_();
        }
        if (shape == StairsShape.OUTER_RIGHT) {
            return side == dir.m_122424_() || side == dir.m_122428_();
        }
        return false;
    }
}

