/*
 * Decompiled with CFR 0.152.
 */
package net.adorabuild.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.adorabuild.structures.AdorabuildStructuresMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;

public class NetherJigsawStructure
extends Structure {
    public static final MapCodec<NetherJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NetherJigsawStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)1, (int)128).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.intRange((int)1, (int)128).fieldOf("min_absolute_height").forGetter(structure -> structure.minAbsoluteHeight), (App)Codec.intRange((int)1, (int)128).fieldOf("max_absolute_height").forGetter(structure -> structure.maxAbsoluteHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.list((Codec)PoolAliasBinding.CODEC).optionalFieldOf("pool_aliases", List.of()).forGetter(structure -> structure.poolAliases)).apply((Applicative)instance, NetherJigsawStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final int minAbsoluteHeight;
    private final int maxAbsoluteHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final List<PoolAliasBinding> poolAliases;

    public NetherJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, int minAbsoluteHeight, int maxAbsoluteHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, List<PoolAliasBinding> poolAliases) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.minAbsoluteHeight = minAbsoluteHeight;
        this.maxAbsoluteHeight = maxAbsoluteHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.poolAliases = poolAliases;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int offsetY = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        ChunkPos chunkPos = context.chunkPos();
        NoiseColumn column = context.chunkGenerator().getBaseColumn(chunkPos.getMinBlockX(), chunkPos.getMinBlockZ(), context.heightAccessor(), context.randomState());
        int terrainY = 0;
        for (int blockY = this.minAbsoluteHeight + offsetY; blockY <= this.maxAbsoluteHeight; ++blockY) {
            if (column.getBlock(blockY - 1).isAir() || !column.getBlock(blockY).isAir() || !column.getBlock(blockY + 2).isAir()) continue;
            terrainY = blockY;
            break;
        }
        if (terrainY == 0) {
            return Optional.empty();
        }
        BlockPos blockPos = new BlockPos(chunkPos.getMinBlockX(), terrainY + offsetY, chunkPos.getMinBlockZ());
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.create(this.poolAliases, (BlockPos)blockPos, (long)context.seed()));
    }

    public StructureType<?> type() {
        return AdorabuildStructuresMod.NETHER_JIGSAW_STRUCTURE.get();
    }
}

