/*
 * Decompiled with CFR 0.152.
 */
package net.adorabuild.structures.registry;

import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.adorabuild.structures.registry.RegistryEntries;
import net.adorabuild.structures.registry.RegistryEntry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.neoforged.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModRegistry<T> {
    private final DeferredRegister<T> register;
    private final RegistryEntries<T> entries = new RegistryEntries();

    public ModRegistry(ResourceKey<? extends Registry<T>> registry, String id) {
        this.register = DeferredRegister.create(registry, (String)id);
    }

    public ModRegistry(Registry<T> registry, String id) {
        this.register = DeferredRegister.create((ResourceKey)registry.key(), (String)id);
    }

    public <I extends T> RegistryEntry<I> register(String id, Supplier<I> supplier) {
        return this.entries.add(new RegistryEntry(this.register.register(id, supplier)));
    }

    public Collection<RegistryEntry<T>> getEntries() {
        return this.entries.getEntries();
    }

    public Stream<RegistryEntry<T>> stream() {
        return this.getEntries().stream();
    }

    public void init() {
        this.register.register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

