/*
 * Decompiled with CFR 0.152.
 */
package com.jebwool.mars.mixin;

import com.jebwool.mars.Jebwool;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={BannerRenderer.class})
public abstract class BannerBlockEntityRendererMixin
implements BlockEntityRenderer<BannerBlockEntity> {
    @Shadow
    @Final
    private ModelPart flag;

    @Shadow
    private static void renderPatternLayer(PoseStack p_332210_, MultiBufferSource p_336119_, int p_333952_, int p_335632_, ModelPart p_327937_, Material p_327979_, DyeColor p_331652_) {
    }

    @Inject(method={"render(Lnet/minecraft/world/level/block/entity/BannerBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/blockentity/BannerRenderer;renderPatterns(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/model/geom/ModelPart;Lnet/minecraft/client/resources/model/Material;ZLnet/minecraft/world/item/DyeColor;Lnet/minecraft/world/level/block/entity/BannerPatternLayers;)V")})
    public void render(BannerBlockEntity bannerBlockEntity, float p_112053_, PoseStack poseStack, MultiBufferSource p_112055_, int p_112056_, int p_112057_, CallbackInfo ci) {
        if (bannerBlockEntity.getBaseColor().equals((Object)Jebwool.JEB_COL)) {
            long worldTime = bannerBlockEntity.getLevel() == null ? 24L : bannerBlockEntity.getLevel().getGameTime();
            BannerBlockEntityRendererMixin.renderJebCanvas(poseStack, p_112055_, p_112056_, p_112057_, this.flag, ModelBakery.BANNER_BASE, true, bannerBlockEntity.getBaseColor(), bannerBlockEntity.getPatterns(), p_112053_, worldTime);
        } else {
            BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)p_112055_, (int)p_112056_, (int)p_112057_, (ModelPart)this.flag, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)bannerBlockEntity.getBaseColor(), (BannerPatternLayers)bannerBlockEntity.getPatterns());
        }
    }

    @Redirect(method={"render(Lnet/minecraft/world/level/block/entity/BannerBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/blockentity/BannerRenderer;renderPatterns(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/model/geom/ModelPart;Lnet/minecraft/client/resources/model/Material;ZLnet/minecraft/world/item/DyeColor;Lnet/minecraft/world/level/block/entity/BannerPatternLayers;)V"))
    public void removeRenderPatterns(PoseStack p_112066_, MultiBufferSource p_112067_, int p_112068_, int p_112069_, ModelPart p_112070_, Material p_112071_, boolean p_112072_, DyeColor p_331835_, BannerPatternLayers p_327702_) {
    }

    @Unique
    private static void renderJebCanvas(PoseStack p_112075_, MultiBufferSource p_112076_, int p_112077_, int p_112078_, ModelPart p_112079_, Material p_112080_, boolean p_112081_, DyeColor baseDyeColor, BannerPatternLayers bannerPatternLayers, float tickDelta, long worldTime) {
        long n = worldTime / 25L + 900000L;
        int o = DyeColor.values().length;
        long p = n % (long)o;
        long q = (n + 1L) % (long)o;
        float rr = ((float)(worldTime % 25L) + tickDelta) / 25.0f;
        float[] fs = Sheep.getColorArray((DyeColor)DyeColor.byId((int)((int)p)));
        float[] gs = Sheep.getColorArray((DyeColor)DyeColor.byId((int)((int)q)));
        float r = fs[0] * (1.0f - rr) + gs[0] * rr;
        float g = fs[1] * (1.0f - rr) + gs[1] * rr;
        float b = fs[2] * (1.0f - rr) + gs[2] * rr;
        p_112079_.render(p_112075_, p_112080_.buffer(p_112076_, RenderType::entityNoOutline), p_112077_, p_112078_, r, g, b, 1.0f);
        for (int i = 0; i < 16 && i < bannerPatternLayers.layers().size(); ++i) {
            BannerPatternLayers.Layer bannerpatternlayers$layer = (BannerPatternLayers.Layer)bannerPatternLayers.layers().get(i);
            Material material = p_112081_ ? Sheets.getBannerMaterial((Holder)bannerpatternlayers$layer.pattern()) : Sheets.getShieldMaterial((Holder)bannerpatternlayers$layer.pattern());
            BannerBlockEntityRendererMixin.renderPatternLayer(p_112075_, p_112076_, p_112077_, p_112078_, p_112079_, material, bannerpatternlayers$layer.color());
        }
    }
}

