/*
 * Decompiled with CFR 0.152.
 */
package net.bl00dy.bnbloodparticles;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bnbloodparticles", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class General {
        public final ForgeConfigSpec.ConfigValue<String> style;
        public final ForgeConfigSpec.IntValue minLifetime;
        public final ForgeConfigSpec.IntValue maxLifetime;
        public final ForgeConfigSpec.DoubleValue sizeParticles;
        public final ForgeConfigSpec.DoubleValue HandAttackCount;
        public final ForgeConfigSpec.DoubleValue WeaponAttackCount;
        public final ForgeConfigSpec.DoubleValue ProjectileAttackCount;
        public final ForgeConfigSpec.DoubleValue FallDamageCount;
        public final ForgeConfigSpec.DoubleValue ExplosionDamageCount;
        public final ForgeConfigSpec.DoubleValue DeathCount;
        public final ForgeConfigSpec.DoubleValue IgnitionCount;
        public final ForgeConfigSpec.DoubleValue ChanceCrit;
        public final ForgeConfigSpec.DoubleValue BleedingCount;
        public final ForgeConfigSpec.IntValue minBleeding;
        public final ForgeConfigSpec.IntValue maxBleeding;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityRedBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityRedWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityCreeperWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityEnderWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityWardenWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityZombieWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entitySnowWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityIronWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityMagmaWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entitySlimeWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityBonesWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityWitherWhitelist;
        public final ForgeConfigSpec.BooleanValue enablePhysicsSimulation;
        public final ForgeConfigSpec.BooleanValue enableAdditionalBleeding;
        public final ForgeConfigSpec.BooleanValue enableImprovedIgnition;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("Graphic Settings");
            builder.comment("Style Settings");
            this.style = builder.comment("Choose the texture style. Choose between \"HD\" or \"OLD\" or \"CUBIC\".").comment("\"OLD\" - Style from early versions of the modification. Textures of low quality, without variability.").comment("\"HD\" - Style with high quality textures and lots of variations.").comment("\"CUBIC\" - Style with low quality textures and square particles, lots of variations.").comment("Recommended style \"HD\".").define("Style", (Object)"HD");
            builder.comment("Lifetime Settings");
            builder.comment("1 second = 20 ticks.");
            builder.comment("Default is 100 ticks.");
            this.minLifetime = builder.defineInRange("MinLifeTime", 100, 1, Integer.MAX_VALUE);
            this.maxLifetime = builder.defineInRange("MaxLifeTime", 100, 1, Integer.MAX_VALUE);
            builder.comment("Size Settings");
            this.sizeParticles = builder.comment("Default is 0.05.").defineInRange("ParticlesSizeMultiplier", 0.05, -0.1, 1.0);
            builder.pop();
            builder.push("General Settings");
            builder.comment("Particles Count Settings");
            builder.comment("Default 1.0 for all particle count multipliers.");
            this.HandAttackCount = builder.comment("Multiplier of the number of particles when damaged by a hand or an object that is not a weapon.").defineInRange("HandMultiplier", 1.0, 0.01, 10.0);
            this.WeaponAttackCount = builder.comment("Multiplier of the number of particles when damaged by any melee weapon.").defineInRange("WeaponMultiplier", 1.0, 0.01, 10.0);
            this.ProjectileAttackCount = builder.comment("Multiplier of the number of particles when damaged by any projectile.").defineInRange("ProjectileMultiplier", 1.0, 0.01, 10.0);
            this.FallDamageCount = builder.comment("Particle count multiplier for fall damage.").defineInRange("FallMultiplier", 1.0, 0.01, 10.0);
            this.ExplosionDamageCount = builder.comment("Multiplier of the number of particles when damaged by an explosion.").defineInRange("ExplosionMultiplier", 1.0, 0.01, 10.0);
            this.DeathCount = builder.comment("Multiplier of the number of particles when a creature dies.").defineInRange("DeathMultiplier", 1.0, 0.01, 10.0);
            this.IgnitionCount = builder.comment("Multiplier of the number of particles when burning a creature.").defineInRange("IgnitionMultiplier", 1.0, 0.01, 10.0);
            builder.comment("Additional Bleeding Settings");
            this.ChanceCrit = builder.comment("Chance of additional bleeding from weapon and projectile damage. Default is 0.35 = 35%.").defineInRange("BleedingChance", 0.35, 0.001, 1.0);
            this.BleedingCount = builder.comment("Multiplier of the number of particles during bleeding.").defineInRange("BleedingMultiplier", 1.0, 0.01, 10.0);
            this.minBleeding = builder.comment("Minimum time for bleeding. Default is 20 ticks.").defineInRange("MinBleedingTime", 20, 1, Integer.MAX_VALUE);
            this.maxBleeding = builder.comment("Maximum time for bleeding. Default is 80 ticks.").defineInRange("MaxBleedingTime", 80, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Entity Settings");
            builder.comment("Add entities to the blacklist to disable particle generation or to the whitelist to enable particle generation.");
            builder.comment("Red Blood Settings");
            this.entityRedBlacklist = builder.defineList("RedPresetBlacklist", Arrays.asList("modid:entity", "modid:entity"), obj -> obj instanceof String);
            this.entityRedWhitelist = builder.defineList("RedPresetWhitelist", Arrays.asList("modid:entity", "modid:entity"), obj -> obj instanceof String);
            builder.comment("Creeper Blood Settings");
            this.entityCreeperWhitelist = builder.defineList("CreeperPresetWhitelist", Arrays.asList("modid:entity", "modid:entity"), obj -> obj instanceof String);
            builder.comment("Ender Blood Settings");
            this.entityEnderWhitelist = builder.defineList("EnderPresetWhitelist", Arrays.asList("modid:entity", "modid:entity"), obj -> obj instanceof String);
            builder.comment("Warden Blood Settings");
            this.entityWardenWhitelist = builder.defineList("WardenPresetWhitelist", Arrays.asList("modid:entity", "modid:entity"), obj -> obj instanceof String);
            builder.comment("Zombie Blood Settings");
            this.entityZombieWhitelist = builder.defineList("ZombiePresetWhitelist", Arrays.asList("modid:entity", "modid:entity"), obj -> obj instanceof String);
            builder.comment("Snow Particles Settings");
            this.entitySnowWhitelist = builder.defineList("SnowPresetWhitelist", Arrays.asList("modid:entity", "modid:entity"), obj -> obj instanceof String);
            builder.comment("Iron Chunks Settings");
            this.entityIronWhitelist = builder.defineList("IronPresetWhitelist", Arrays.asList("modid:entity", "modid:entity"), obj -> obj instanceof String);
            builder.comment("Magma Chunks Settings");
            this.entityMagmaWhitelist = builder.defineList("MagmaPresetWhitelist", Arrays.asList("modid:entity", "modid:entity"), obj -> obj instanceof String);
            builder.comment("Slime Chunks Settings");
            this.entitySlimeWhitelist = builder.defineList("SlimePresetWhitelist", Arrays.asList("modid:entity", "modid:entity"), obj -> obj instanceof String);
            builder.comment("Skeleton Bones Settings");
            this.entityBonesWhitelist = builder.defineList("SkeletonPresetWhitelist", Arrays.asList("modid:entity", "modid:entity"), obj -> obj instanceof String);
            builder.comment("Wither Bones Settings");
            this.entityWitherWhitelist = builder.defineList("WitherPresetWhitelist", Arrays.asList("modid:entity", "modid:entity"), obj -> obj instanceof String);
            builder.pop();
            builder.push("Extra Settings");
            this.enablePhysicsSimulation = builder.comment("Enable or disable physics simulation.").comment("Works 50% optimized with physics disabled., but disables particle sticking and spreading effects.").comment("There is also a bug with the levitation of particles if the block under them has been destroyed.").define("enablePhysicsSimulation", true);
            this.enableAdditionalBleeding = builder.comment("Enable or disable additional bleeding on critical damage or death.").define("enableAdditionalBleeding", true);
            this.enableImprovedIgnition = builder.comment("Enable or disable the burn animation enhancement for creatures.").define("enableImprovedIgnition", true);
            builder.pop();
        }
    }
}

