/*
 * Decompiled with CFR 0.152.
 */
package hantonik.fbp.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import hantonik.fbp.FancyBlockParticles;
import hantonik.fbp.config.IFBPConfig;
import hantonik.fbp.platform.Services;
import hantonik.fbp.util.FBPConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.apache.commons.compress.utils.Lists;

public final class FBPConfig
implements IFBPConfig<FBPConfig> {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    public static final FBPConfig DEFAULT_CONFIG = new FBPConfig(Global.DEFAULT_CONFIG, Terrain.DEFAULT_CONFIG, FlameSmoke.DEFAULT_CONFIG, FlameSmoke.DEFAULT_CONFIG, Rain.DEFAULT_CONFIG, Snow.DEFAULT_CONFIG, Animations.DEFAULT_CONFIG, Overlay.DEFAULT_CONFIG);
    public final Global global;
    public final Terrain terrain;
    public final FlameSmoke flame;
    public final FlameSmoke smoke;
    public final Rain rain;
    public final Snow snow;
    public final Animations animations;
    public final Overlay overlay;

    public void toggleParticles(class_2248 block) {
        if (this.isBlockParticlesEnabled(block)) {
            this.global.disabledParticles.add(block);
        } else {
            this.global.disabledParticles.remove(block);
        }
    }

    public void toggleAnimations(class_2248 block) {
        if (this.isBlockAnimationsEnabled(block)) {
            this.global.disabledAnimations.add(block);
        } else {
            this.global.disabledAnimations.remove(block);
        }
    }

    public boolean isBlockParticlesEnabled(class_2248 block) {
        return !this.global.disabledParticles.contains(block);
    }

    public boolean isBlockAnimationsEnabled(class_2248 block) {
        return !this.global.disabledAnimations.contains(block);
    }

    public static FBPConfig create() {
        return DEFAULT_CONFIG.copy();
    }

    @Override
    public void setConfig(FBPConfig config) {
        this.global.setConfig(config.global);
        this.terrain.setConfig(config.terrain);
        this.flame.setConfig(config.flame);
        this.smoke.setConfig(config.smoke);
        this.rain.setConfig(config.rain);
        this.snow.setConfig(config.snow);
        this.animations.setConfig(config.animations);
        this.overlay.setConfig(config.overlay);
    }

    @Override
    public void applyConfig(FBPConfig config) {
        this.global.applyConfig(config.global);
        this.terrain.applyConfig(config.terrain);
        this.flame.applyConfig(config.flame);
        this.smoke.applyConfig(config.smoke);
        this.rain.applyConfig(config.rain);
        this.snow.applyConfig(config.snow);
        this.animations.applyConfig(config.animations);
        this.overlay.applyConfig(config.overlay);
    }

    @Override
    public void load() {
        try {
            Files.createDirectory(FBPConstants.CONFIG_PATH, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            FancyBlockParticles.LOGGER.debug("{} config directory already exists.", (Object)"FancyBlockParticles");
        }
        catch (IOException e) {
            FancyBlockParticles.LOGGER.error("Failed to create {} config directory.", (Object)"FancyBlockParticles");
        }
        File file = new File(FBPConstants.CONFIG_PATH.toString(), "config.json");
        try {
            if (!file.exists()) {
                file.createNewFile();
                this.save();
            }
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(new FileInputStream(file))).getAsJsonObject();
            this.global.load(class_3518.method_15281((JsonObject)json, (String)"global", (JsonObject)new JsonObject()));
            this.terrain.load(class_3518.method_15281((JsonObject)json, (String)"terrain", (JsonObject)new JsonObject()));
            this.flame.load(class_3518.method_15281((JsonObject)json, (String)"flame", (JsonObject)new JsonObject()));
            this.smoke.load(class_3518.method_15281((JsonObject)json, (String)"smoke", (JsonObject)new JsonObject()));
            this.rain.load(class_3518.method_15281((JsonObject)json, (String)"rain", (JsonObject)new JsonObject()));
            this.snow.load(class_3518.method_15281((JsonObject)json, (String)"snow", (JsonObject)new JsonObject()));
            this.animations.load(class_3518.method_15281((JsonObject)json, (String)"animations", (JsonObject)new JsonObject()));
            this.overlay.load(class_3518.method_15281((JsonObject)json, (String)"overlay", (JsonObject)new JsonObject()));
        }
        catch (IOException e) {
            FancyBlockParticles.LOGGER.error("Could no load FBP config.", (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            FancyBlockParticles.LOGGER.warn("FBP config file is corrupt! Generating a new one.");
            this.save();
        }
    }

    @Override
    public JsonObject save() {
        JsonObject json = new JsonObject();
        try (FileWriter writer = new FileWriter(new File(FBPConstants.CONFIG_PATH.toString(), "config.json"));){
            json.add("global", (JsonElement)this.global.save());
            json.add("terrain", (JsonElement)this.terrain.save());
            json.add("flame", (JsonElement)this.flame.save());
            json.add("smoke", (JsonElement)this.smoke.save());
            json.add("rain", (JsonElement)this.rain.save());
            json.add("snow", (JsonElement)this.snow.save());
            json.add("animations", (JsonElement)this.animations.save());
            json.add("overlay", (JsonElement)this.overlay.save());
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            FancyBlockParticles.LOGGER.error("Could no save FBP config.", (Throwable)e);
        }
        return json;
    }

    @Override
    public void reset() {
        this.setConfig(DEFAULT_CONFIG.copy());
    }

    @Override
    public FBPConfig copy() {
        return new FBPConfig(this.global.copy(), this.terrain.copy(), this.flame.copy(), this.smoke.copy(), this.rain.copy(), this.snow.copy(), this.animations.copy(), this.overlay.copy());
    }

    @Generated
    public Global getGlobal() {
        return this.global;
    }

    @Generated
    public Terrain getTerrain() {
        return this.terrain;
    }

    @Generated
    public FlameSmoke getFlame() {
        return this.flame;
    }

    @Generated
    public FlameSmoke getSmoke() {
        return this.smoke;
    }

    @Generated
    public Rain getRain() {
        return this.rain;
    }

    @Generated
    public Snow getSnow() {
        return this.snow;
    }

    @Generated
    public Animations getAnimations() {
        return this.animations;
    }

    @Generated
    public Overlay getOverlay() {
        return this.overlay;
    }

    @Generated
    private FBPConfig(Global global, Terrain terrain, FlameSmoke flame, FlameSmoke smoke, Rain rain, Snow snow, Animations animations, Overlay overlay) {
        this.global = global;
        this.terrain = terrain;
        this.flame = flame;
        this.smoke = smoke;
        this.rain = rain;
        this.snow = snow;
        this.animations = animations;
        this.overlay = overlay;
    }

    public static class Global
    implements IFBPConfig<Global> {
        private static final boolean DEFAULT_ENABLED = true;
        private static final boolean DEFAULT_LOCKED = false;
        private static final boolean DEFAULT_FREEZE_EFFECT = false;
        private static final boolean DEFAULT_CARTOON_MODE = false;
        private static final boolean DEFAULT_CULL_PARTICLES = true;
        private static final boolean DEFAULT_INFINITE_DURATION = false;
        private static final List<class_2248> DEFAULT_DISABLED_PARTICLES = Lists.newArrayList();
        private static final List<class_2248> DEFAULT_DISABLED_ANIMATIONS = Lists.newArrayList();
        public static final Global DEFAULT_CONFIG = new Global(true, false, false, false, true, false, DEFAULT_DISABLED_PARTICLES, DEFAULT_DISABLED_ANIMATIONS);
        private boolean enabled;
        private boolean locked;
        private boolean freezeEffect;
        private boolean cartoonMode;
        private boolean cullParticles;
        private boolean infiniteDuration;
        private List<class_2248> disabledParticles;
        private List<class_2248> disabledAnimations;

        @Override
        public void setConfig(Global config) {
            this.enabled = config.enabled;
            this.locked = config.locked;
            this.freezeEffect = config.freezeEffect;
            this.cartoonMode = config.cartoonMode;
            this.cullParticles = config.cullParticles;
            this.infiniteDuration = config.infiniteDuration;
            this.disabledParticles = new ArrayList<class_2248>(config.disabledParticles);
            this.disabledAnimations = new ArrayList<class_2248>(config.disabledAnimations);
        }

        @Override
        public void applyConfig(Global config) {
            this.enabled = config.enabled;
            this.locked = config.locked;
            this.freezeEffect = config.freezeEffect;
            this.cartoonMode = config.cartoonMode;
            this.cullParticles = config.cullParticles;
            this.infiniteDuration = config.infiniteDuration;
            this.disabledParticles.addAll(config.disabledParticles);
            this.disabledAnimations.addAll(config.disabledAnimations);
        }

        @Override
        public void load(JsonObject json) {
            this.enabled = class_3518.method_15258((JsonObject)json, (String)"enabled", (boolean)true);
            this.locked = class_3518.method_15258((JsonObject)json, (String)"locked", (boolean)false);
            this.freezeEffect = class_3518.method_15258((JsonObject)json, (String)"freezeEffect", (boolean)false);
            this.cartoonMode = class_3518.method_15258((JsonObject)json, (String)"cartoonMode", (boolean)false);
            this.cullParticles = class_3518.method_15258((JsonObject)json, (String)"cullParticles", (boolean)true);
            this.infiniteDuration = class_3518.method_15258((JsonObject)json, (String)"infiniteDuration", (boolean)false);
            this.disabledParticles = (List)class_156.method_654((Object)Lists.newArrayList(), disabled -> {
                if (json.has("disabledParticles")) {
                    for (JsonElement entry : class_3518.method_15261((JsonObject)json, (String)"disabledParticles")) {
                        disabled.add(Services.REGISTRY.getBlock(new class_2960(entry.getAsString())));
                    }
                } else {
                    disabled.addAll(DEFAULT_DISABLED_PARTICLES);
                }
            });
            this.disabledAnimations = (List)class_156.method_654((Object)Lists.newArrayList(), disabled -> {
                if (json.has("disabledAnimations")) {
                    for (JsonElement entry : class_3518.method_15261((JsonObject)json, (String)"disabledAnimations")) {
                        disabled.add(Services.REGISTRY.getBlock(new class_2960(entry.getAsString())));
                    }
                } else {
                    disabled.addAll(DEFAULT_DISABLED_ANIMATIONS);
                }
            });
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("locked", Boolean.valueOf(this.locked));
            json.addProperty("freezeEffect", Boolean.valueOf(this.freezeEffect));
            json.addProperty("cartoonMode", Boolean.valueOf(this.cartoonMode));
            json.addProperty("cullParticles", Boolean.valueOf(this.cullParticles));
            json.addProperty("infiniteDuration", Boolean.valueOf(this.infiniteDuration));
            json.add("disabledParticles", (JsonElement)class_156.method_654((Object)new JsonArray(), disabled -> {
                for (class_2248 entry : this.disabledParticles) {
                    disabled.add(Services.REGISTRY.getBlockKey(entry).toString());
                }
            }));
            json.add("disabledAnimations", (JsonElement)class_156.method_654((Object)new JsonArray(), disabled -> {
                for (class_2248 entry : this.disabledAnimations) {
                    disabled.add(Services.REGISTRY.getBlockKey(entry).toString());
                }
            }));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Global copy() {
            return new Global(this.enabled, this.locked, this.freezeEffect, this.cartoonMode, this.cullParticles, this.infiniteDuration, new ArrayList<class_2248>(this.disabledParticles), new ArrayList<class_2248>(this.disabledAnimations));
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isLocked() {
            return this.locked;
        }

        @Generated
        public boolean isFreezeEffect() {
            return this.freezeEffect;
        }

        @Generated
        public boolean isCartoonMode() {
            return this.cartoonMode;
        }

        @Generated
        public boolean isCullParticles() {
            return this.cullParticles;
        }

        @Generated
        public boolean isInfiniteDuration() {
            return this.infiniteDuration;
        }

        @Generated
        public List<class_2248> getDisabledParticles() {
            return this.disabledParticles;
        }

        @Generated
        public List<class_2248> getDisabledAnimations() {
            return this.disabledAnimations;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        @Generated
        public void setFreezeEffect(boolean freezeEffect) {
            this.freezeEffect = freezeEffect;
        }

        @Generated
        public void setCartoonMode(boolean cartoonMode) {
            this.cartoonMode = cartoonMode;
        }

        @Generated
        public void setCullParticles(boolean cullParticles) {
            this.cullParticles = cullParticles;
        }

        @Generated
        public void setInfiniteDuration(boolean infiniteDuration) {
            this.infiniteDuration = infiniteDuration;
        }

        @Generated
        private Global(boolean enabled, boolean locked, boolean freezeEffect, boolean cartoonMode, boolean cullParticles, boolean infiniteDuration, List<class_2248> disabledParticles, List<class_2248> disabledAnimations) {
            this.enabled = enabled;
            this.locked = locked;
            this.freezeEffect = freezeEffect;
            this.cartoonMode = cartoonMode;
            this.cullParticles = cullParticles;
            this.infiniteDuration = infiniteDuration;
            this.disabledParticles = disabledParticles;
            this.disabledAnimations = disabledAnimations;
        }

        @Generated
        private void setDisabledParticles(List<class_2248> disabledParticles) {
            this.disabledParticles = disabledParticles;
        }

        @Generated
        private void setDisabledAnimations(List<class_2248> disabledAnimations) {
            this.disabledAnimations = disabledAnimations;
        }
    }

    public static class Terrain
    implements IFBPConfig<Terrain> {
        private static final boolean DEFAULT_FANCY_BREAKING_PARTICLES = true;
        private static final boolean DEFAULT_FANCY_CRACKING_PARTICLES = true;
        private static final boolean DEFAULT_SPAWN_WHILE_FROZEN = true;
        private static final boolean DEFAULT_INFINITE_DURATION = false;
        private static final boolean DEFAULT_SMART_BREAKING = true;
        private static final boolean DEFAULT_LOW_TRACTION = false;
        private static final boolean DEFAULT_REST_ON_FLOOR = true;
        private static final boolean DEFAULT_BOUNCE_OFF_WALLS = true;
        private static final boolean DEFAULT_ENTITY_COLLISION = false;
        private static final boolean DEFAULT_WATER_PHYSICS = true;
        private static final boolean DEFAULT_RANDOM_SIZE = true;
        private static final boolean DEFAULT_RANDOM_ROTATION = true;
        private static final boolean DEFAULT_RANDOM_FADING_SPEED = true;
        private static final int DEFAULT_PARTICLES_PER_AXIS = 4;
        private static final int DEFAULT_MIN_LIFETIME = 10;
        private static final int DEFAULT_MAX_LIFETIME = 55;
        private static final float DEFAULT_SIZE_MULTIPLIER = 0.75f;
        private static final float DEFAULT_ROTATION_MULTIPLIER = 1.0f;
        private static final float DEFAULT_GRAVITY_MULTIPLIER = 1.0f;
        public static final Terrain DEFAULT_CONFIG = new Terrain(true, true, true, false, true, false, true, true, false, true, true, true, true, 4, 10, 55, 0.75f, 1.0f, 1.0f);
        private boolean fancyBreakingParticles;
        private boolean fancyCrackingParticles;
        private boolean spawnWhileFrozen;
        private boolean infiniteDuration;
        private boolean smartBreaking;
        private boolean lowTraction;
        private boolean restOnFloor;
        private boolean bounceOffWalls;
        private boolean entityCollision;
        private boolean waterPhysics;
        private boolean randomSize;
        private boolean randomRotation;
        private boolean randomFadingSpeed;
        private int particlesPerAxis;
        private int minLifetime;
        private int maxLifetime;
        private float sizeMultiplier;
        private float rotationMultiplier;
        private float gravityMultiplier;

        @Override
        public void setConfig(Terrain config) {
            this.fancyBreakingParticles = config.fancyBreakingParticles;
            this.fancyCrackingParticles = config.fancyCrackingParticles;
            this.spawnWhileFrozen = config.spawnWhileFrozen;
            this.infiniteDuration = config.infiniteDuration;
            this.smartBreaking = config.smartBreaking;
            this.lowTraction = config.lowTraction;
            this.restOnFloor = config.restOnFloor;
            this.bounceOffWalls = config.bounceOffWalls;
            this.entityCollision = config.entityCollision;
            this.waterPhysics = config.waterPhysics;
            this.randomSize = config.randomSize;
            this.randomRotation = config.randomRotation;
            this.randomFadingSpeed = config.randomFadingSpeed;
            this.particlesPerAxis = config.particlesPerAxis;
            this.minLifetime = config.minLifetime;
            this.maxLifetime = config.maxLifetime;
            this.sizeMultiplier = config.sizeMultiplier;
            this.rotationMultiplier = config.rotationMultiplier;
            this.gravityMultiplier = config.gravityMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.fancyBreakingParticles = class_3518.method_15258((JsonObject)json, (String)"fancyBreakingParticles", (boolean)true);
            this.fancyCrackingParticles = class_3518.method_15258((JsonObject)json, (String)"fancyCrackingParticles", (boolean)true);
            this.spawnWhileFrozen = class_3518.method_15258((JsonObject)json, (String)"spawnWhileFrozen", (boolean)true);
            this.infiniteDuration = class_3518.method_15258((JsonObject)json, (String)"infiniteDuration", (boolean)false);
            this.smartBreaking = class_3518.method_15258((JsonObject)json, (String)"smartBreaking", (boolean)true);
            this.lowTraction = class_3518.method_15258((JsonObject)json, (String)"lowTraction", (boolean)false);
            this.restOnFloor = class_3518.method_15258((JsonObject)json, (String)"restOnFloor", (boolean)true);
            this.bounceOffWalls = class_3518.method_15258((JsonObject)json, (String)"bounceOffWalls", (boolean)true);
            this.entityCollision = class_3518.method_15258((JsonObject)json, (String)"entityCollision", (boolean)false);
            this.waterPhysics = class_3518.method_15258((JsonObject)json, (String)"waterPhysics", (boolean)true);
            this.randomSize = class_3518.method_15258((JsonObject)json, (String)"randomSize", (boolean)true);
            this.randomRotation = class_3518.method_15258((JsonObject)json, (String)"randomRotation", (boolean)true);
            this.randomFadingSpeed = class_3518.method_15258((JsonObject)json, (String)"randomFadingSpeed", (boolean)true);
            this.particlesPerAxis = class_3518.method_15282((JsonObject)json, (String)"particlesPerAxis", (int)4);
            this.minLifetime = class_3518.method_15282((JsonObject)json, (String)"minLifetime", (int)10);
            this.maxLifetime = class_3518.method_15282((JsonObject)json, (String)"maxLifetime", (int)55);
            this.sizeMultiplier = class_3518.method_15277((JsonObject)json, (String)"sizeMultiplier", (float)0.75f);
            this.rotationMultiplier = class_3518.method_15277((JsonObject)json, (String)"rotationMultiplier", (float)1.0f);
            this.gravityMultiplier = class_3518.method_15277((JsonObject)json, (String)"gravityMultiplier", (float)1.0f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("fancyBreakingParticles", Boolean.valueOf(this.fancyBreakingParticles));
            json.addProperty("fancyCrackingParticles", Boolean.valueOf(this.fancyCrackingParticles));
            json.addProperty("spawnWhileFrozen", Boolean.valueOf(this.spawnWhileFrozen));
            json.addProperty("infiniteDuration", Boolean.valueOf(this.infiniteDuration));
            json.addProperty("smartBreaking", Boolean.valueOf(this.smartBreaking));
            json.addProperty("lowTraction", Boolean.valueOf(this.lowTraction));
            json.addProperty("restOnFloor", Boolean.valueOf(this.restOnFloor));
            json.addProperty("bounceOffWalls", Boolean.valueOf(this.bounceOffWalls));
            json.addProperty("entityCollision", Boolean.valueOf(this.entityCollision));
            json.addProperty("waterPhysics", Boolean.valueOf(this.waterPhysics));
            json.addProperty("randomSize", Boolean.valueOf(this.randomSize));
            json.addProperty("randomRotation", Boolean.valueOf(this.randomRotation));
            json.addProperty("randomFadingSpeed", Boolean.valueOf(this.randomFadingSpeed));
            json.addProperty("particlesPerAxis", (Number)this.particlesPerAxis);
            json.addProperty("minLifetime", (Number)this.minLifetime);
            json.addProperty("maxLifetime", (Number)this.maxLifetime);
            json.addProperty("sizeMultiplier", (Number)Float.valueOf(this.sizeMultiplier));
            json.addProperty("rotationMultiplier", (Number)Float.valueOf(this.rotationMultiplier));
            json.addProperty("gravityMultiplier", (Number)Float.valueOf(this.gravityMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Terrain copy() {
            return new Terrain(this.fancyBreakingParticles, this.fancyCrackingParticles, this.spawnWhileFrozen, this.infiniteDuration, this.smartBreaking, this.lowTraction, this.restOnFloor, this.bounceOffWalls, this.entityCollision, this.waterPhysics, this.randomSize, this.randomRotation, this.randomFadingSpeed, this.particlesPerAxis, this.minLifetime, this.maxLifetime, this.sizeMultiplier, this.rotationMultiplier, this.gravityMultiplier);
        }

        @Generated
        public boolean isFancyBreakingParticles() {
            return this.fancyBreakingParticles;
        }

        @Generated
        public boolean isFancyCrackingParticles() {
            return this.fancyCrackingParticles;
        }

        @Generated
        public boolean isSpawnWhileFrozen() {
            return this.spawnWhileFrozen;
        }

        @Generated
        public boolean isInfiniteDuration() {
            return this.infiniteDuration;
        }

        @Generated
        public boolean isSmartBreaking() {
            return this.smartBreaking;
        }

        @Generated
        public boolean isLowTraction() {
            return this.lowTraction;
        }

        @Generated
        public boolean isRestOnFloor() {
            return this.restOnFloor;
        }

        @Generated
        public boolean isBounceOffWalls() {
            return this.bounceOffWalls;
        }

        @Generated
        public boolean isEntityCollision() {
            return this.entityCollision;
        }

        @Generated
        public boolean isWaterPhysics() {
            return this.waterPhysics;
        }

        @Generated
        public boolean isRandomSize() {
            return this.randomSize;
        }

        @Generated
        public boolean isRandomRotation() {
            return this.randomRotation;
        }

        @Generated
        public boolean isRandomFadingSpeed() {
            return this.randomFadingSpeed;
        }

        @Generated
        public int getParticlesPerAxis() {
            return this.particlesPerAxis;
        }

        @Generated
        public int getMinLifetime() {
            return this.minLifetime;
        }

        @Generated
        public int getMaxLifetime() {
            return this.maxLifetime;
        }

        @Generated
        public float getSizeMultiplier() {
            return this.sizeMultiplier;
        }

        @Generated
        public float getRotationMultiplier() {
            return this.rotationMultiplier;
        }

        @Generated
        public float getGravityMultiplier() {
            return this.gravityMultiplier;
        }

        @Generated
        public void setFancyBreakingParticles(boolean fancyBreakingParticles) {
            this.fancyBreakingParticles = fancyBreakingParticles;
        }

        @Generated
        public void setFancyCrackingParticles(boolean fancyCrackingParticles) {
            this.fancyCrackingParticles = fancyCrackingParticles;
        }

        @Generated
        public void setSpawnWhileFrozen(boolean spawnWhileFrozen) {
            this.spawnWhileFrozen = spawnWhileFrozen;
        }

        @Generated
        public void setInfiniteDuration(boolean infiniteDuration) {
            this.infiniteDuration = infiniteDuration;
        }

        @Generated
        public void setSmartBreaking(boolean smartBreaking) {
            this.smartBreaking = smartBreaking;
        }

        @Generated
        public void setLowTraction(boolean lowTraction) {
            this.lowTraction = lowTraction;
        }

        @Generated
        public void setRestOnFloor(boolean restOnFloor) {
            this.restOnFloor = restOnFloor;
        }

        @Generated
        public void setBounceOffWalls(boolean bounceOffWalls) {
            this.bounceOffWalls = bounceOffWalls;
        }

        @Generated
        public void setEntityCollision(boolean entityCollision) {
            this.entityCollision = entityCollision;
        }

        @Generated
        public void setWaterPhysics(boolean waterPhysics) {
            this.waterPhysics = waterPhysics;
        }

        @Generated
        public void setRandomSize(boolean randomSize) {
            this.randomSize = randomSize;
        }

        @Generated
        public void setRandomRotation(boolean randomRotation) {
            this.randomRotation = randomRotation;
        }

        @Generated
        public void setRandomFadingSpeed(boolean randomFadingSpeed) {
            this.randomFadingSpeed = randomFadingSpeed;
        }

        @Generated
        public void setParticlesPerAxis(int particlesPerAxis) {
            this.particlesPerAxis = particlesPerAxis;
        }

        @Generated
        public void setMinLifetime(int minLifetime) {
            this.minLifetime = minLifetime;
        }

        @Generated
        public void setMaxLifetime(int maxLifetime) {
            this.maxLifetime = maxLifetime;
        }

        @Generated
        public void setSizeMultiplier(float sizeMultiplier) {
            this.sizeMultiplier = sizeMultiplier;
        }

        @Generated
        public void setRotationMultiplier(float rotationMultiplier) {
            this.rotationMultiplier = rotationMultiplier;
        }

        @Generated
        public void setGravityMultiplier(float gravityMultiplier) {
            this.gravityMultiplier = gravityMultiplier;
        }

        @Generated
        private Terrain(boolean fancyBreakingParticles, boolean fancyCrackingParticles, boolean spawnWhileFrozen, boolean infiniteDuration, boolean smartBreaking, boolean lowTraction, boolean restOnFloor, boolean bounceOffWalls, boolean entityCollision, boolean waterPhysics, boolean randomSize, boolean randomRotation, boolean randomFadingSpeed, int particlesPerAxis, int minLifetime, int maxLifetime, float sizeMultiplier, float rotationMultiplier, float gravityMultiplier) {
            this.fancyBreakingParticles = fancyBreakingParticles;
            this.fancyCrackingParticles = fancyCrackingParticles;
            this.spawnWhileFrozen = spawnWhileFrozen;
            this.infiniteDuration = infiniteDuration;
            this.smartBreaking = smartBreaking;
            this.lowTraction = lowTraction;
            this.restOnFloor = restOnFloor;
            this.bounceOffWalls = bounceOffWalls;
            this.entityCollision = entityCollision;
            this.waterPhysics = waterPhysics;
            this.randomSize = randomSize;
            this.randomRotation = randomRotation;
            this.randomFadingSpeed = randomFadingSpeed;
            this.particlesPerAxis = particlesPerAxis;
            this.minLifetime = minLifetime;
            this.maxLifetime = maxLifetime;
            this.sizeMultiplier = sizeMultiplier;
            this.rotationMultiplier = rotationMultiplier;
            this.gravityMultiplier = gravityMultiplier;
        }
    }

    public static class FlameSmoke
    implements IFBPConfig<FlameSmoke> {
        private static final boolean DEFAULT_ENABLED = true;
        private static final boolean DEFAULT_SPAWN_WHILE_FROZEN = false;
        private static final boolean DEFAULT_INFINITE_DURATION = false;
        private static final boolean DEFAULT_RANDOM_SIZE = true;
        private static final boolean DEFAULT_RANDOM_FADING_SPEED = true;
        private static final int DEFAULT_MIN_LIFETIME = 10;
        private static final int DEFAULT_MAX_LIFETIME = 15;
        private static final float DEFAULT_SIZE_MULTIPLIER = 0.75f;
        public static final FlameSmoke DEFAULT_CONFIG = new FlameSmoke(true, false, false, true, true, 10, 15, 0.75f);
        private boolean enabled;
        private boolean spawnWhileFrozen;
        private boolean infiniteDuration;
        private boolean randomSize;
        private boolean randomFadingSpeed;
        private int minLifetime;
        private int maxLifetime;
        private float sizeMultiplier;

        @Override
        public void setConfig(FlameSmoke config) {
            this.enabled = config.enabled;
            this.spawnWhileFrozen = config.spawnWhileFrozen;
            this.infiniteDuration = config.infiniteDuration;
            this.randomSize = config.randomSize;
            this.randomFadingSpeed = config.randomFadingSpeed;
            this.minLifetime = config.minLifetime;
            this.maxLifetime = config.maxLifetime;
            this.sizeMultiplier = config.sizeMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.enabled = class_3518.method_15258((JsonObject)json, (String)"enabled", (boolean)true);
            this.spawnWhileFrozen = class_3518.method_15258((JsonObject)json, (String)"spawnWhileFrozen", (boolean)false);
            this.infiniteDuration = class_3518.method_15258((JsonObject)json, (String)"infiniteDuration", (boolean)false);
            this.randomSize = class_3518.method_15258((JsonObject)json, (String)"randomSize", (boolean)true);
            this.randomFadingSpeed = class_3518.method_15258((JsonObject)json, (String)"randomFadingSpeed", (boolean)true);
            this.minLifetime = class_3518.method_15282((JsonObject)json, (String)"minLifetime", (int)10);
            this.maxLifetime = class_3518.method_15282((JsonObject)json, (String)"maxLifetime", (int)15);
            this.sizeMultiplier = class_3518.method_15277((JsonObject)json, (String)"sizeMultiplier", (float)0.75f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("spawnWhileFrozen", Boolean.valueOf(this.spawnWhileFrozen));
            json.addProperty("infiniteDuration", Boolean.valueOf(this.infiniteDuration));
            json.addProperty("randomSize", Boolean.valueOf(this.randomSize));
            json.addProperty("randomFadingSpeed", Boolean.valueOf(this.randomFadingSpeed));
            json.addProperty("minLifetime", (Number)this.minLifetime);
            json.addProperty("maxLifetime", (Number)this.maxLifetime);
            json.addProperty("sizeMultiplier", (Number)Float.valueOf(this.sizeMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public FlameSmoke copy() {
            return new FlameSmoke(this.enabled, this.spawnWhileFrozen, this.infiniteDuration, this.randomSize, this.randomFadingSpeed, this.minLifetime, this.maxLifetime, this.sizeMultiplier);
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isSpawnWhileFrozen() {
            return this.spawnWhileFrozen;
        }

        @Generated
        public boolean isInfiniteDuration() {
            return this.infiniteDuration;
        }

        @Generated
        public boolean isRandomSize() {
            return this.randomSize;
        }

        @Generated
        public boolean isRandomFadingSpeed() {
            return this.randomFadingSpeed;
        }

        @Generated
        public int getMinLifetime() {
            return this.minLifetime;
        }

        @Generated
        public int getMaxLifetime() {
            return this.maxLifetime;
        }

        @Generated
        public float getSizeMultiplier() {
            return this.sizeMultiplier;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setSpawnWhileFrozen(boolean spawnWhileFrozen) {
            this.spawnWhileFrozen = spawnWhileFrozen;
        }

        @Generated
        public void setInfiniteDuration(boolean infiniteDuration) {
            this.infiniteDuration = infiniteDuration;
        }

        @Generated
        public void setRandomSize(boolean randomSize) {
            this.randomSize = randomSize;
        }

        @Generated
        public void setRandomFadingSpeed(boolean randomFadingSpeed) {
            this.randomFadingSpeed = randomFadingSpeed;
        }

        @Generated
        public void setMinLifetime(int minLifetime) {
            this.minLifetime = minLifetime;
        }

        @Generated
        public void setMaxLifetime(int maxLifetime) {
            this.maxLifetime = maxLifetime;
        }

        @Generated
        public void setSizeMultiplier(float sizeMultiplier) {
            this.sizeMultiplier = sizeMultiplier;
        }

        @Generated
        private FlameSmoke(boolean enabled, boolean spawnWhileFrozen, boolean infiniteDuration, boolean randomSize, boolean randomFadingSpeed, int minLifetime, int maxLifetime, float sizeMultiplier) {
            this.enabled = enabled;
            this.spawnWhileFrozen = spawnWhileFrozen;
            this.infiniteDuration = infiniteDuration;
            this.randomSize = randomSize;
            this.randomFadingSpeed = randomFadingSpeed;
            this.minLifetime = minLifetime;
            this.maxLifetime = maxLifetime;
            this.sizeMultiplier = sizeMultiplier;
        }
    }

    public static class Rain
    implements IFBPConfig<Rain> {
        private static final boolean DEFAULT_ENABLED = true;
        private static final boolean DEFAULT_WATER_PHYSICS = false;
        private static final boolean DEFAULT_RANDOM_SIZE = true;
        private static final boolean DEFAULT_RANDOM_FADING_SPEED = true;
        private static final int DEFAULT_RENDER_DISTANCE = 4;
        private static final int DEFAULT_SIMULATION_DISTANCE = 12;
        private static final float DEFAULT_PARTICLE_DENSITY = 1.0f;
        private static final float DEFAULT_SIZE_MULTIPLIER = 1.0f;
        private static final float DEFAULT_GRAVITY_MULTIPLIER = 1.0f;
        public static final Rain DEFAULT_CONFIG = new Rain(true, false, true, true, 4, 12, 1.0f, 1.0f, 1.0f);
        private boolean enabled;
        private boolean waterPhysics;
        private boolean randomSize;
        private boolean randomFadingSpeed;
        private int renderDistance;
        private int simulationDistance;
        private float particleDensity;
        private float sizeMultiplier;
        private float gravityMultiplier;

        @Override
        public void setConfig(Rain config) {
            this.enabled = config.enabled;
            this.waterPhysics = config.waterPhysics;
            this.randomSize = config.randomSize;
            this.randomFadingSpeed = config.randomFadingSpeed;
            this.renderDistance = config.renderDistance;
            this.simulationDistance = config.simulationDistance;
            this.particleDensity = config.particleDensity;
            this.sizeMultiplier = config.sizeMultiplier;
            this.gravityMultiplier = config.gravityMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.enabled = class_3518.method_15258((JsonObject)json, (String)"enabled", (boolean)true);
            this.waterPhysics = class_3518.method_15258((JsonObject)json, (String)"waterPhysics", (boolean)false);
            this.randomSize = class_3518.method_15258((JsonObject)json, (String)"randomSize", (boolean)true);
            this.randomFadingSpeed = class_3518.method_15258((JsonObject)json, (String)"randomFadingSpeed", (boolean)true);
            this.renderDistance = class_3518.method_15282((JsonObject)json, (String)"renderDistance", (int)4);
            this.simulationDistance = class_3518.method_15282((JsonObject)json, (String)"simulationDistance", (int)12);
            this.particleDensity = class_3518.method_15277((JsonObject)json, (String)"particleDensity", (float)1.0f);
            this.sizeMultiplier = class_3518.method_15277((JsonObject)json, (String)"sizeMultiplier", (float)1.0f);
            this.gravityMultiplier = class_3518.method_15277((JsonObject)json, (String)"gravityMultiplier", (float)1.0f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("waterPhysics", Boolean.valueOf(this.waterPhysics));
            json.addProperty("randomSize", Boolean.valueOf(this.randomSize));
            json.addProperty("randomFadingSpeed", Boolean.valueOf(this.randomFadingSpeed));
            json.addProperty("renderDistance", (Number)this.renderDistance);
            json.addProperty("simulationDistance", (Number)this.simulationDistance);
            json.addProperty("rainParticleDensity", (Number)Float.valueOf(this.particleDensity));
            json.addProperty("sizeMultiplier", (Number)Float.valueOf(this.sizeMultiplier));
            json.addProperty("gravityMultiplier", (Number)Float.valueOf(this.gravityMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Rain copy() {
            return new Rain(this.enabled, this.waterPhysics, this.randomSize, this.randomFadingSpeed, this.renderDistance, this.simulationDistance, this.particleDensity, this.sizeMultiplier, this.gravityMultiplier);
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isWaterPhysics() {
            return this.waterPhysics;
        }

        @Generated
        public boolean isRandomSize() {
            return this.randomSize;
        }

        @Generated
        public boolean isRandomFadingSpeed() {
            return this.randomFadingSpeed;
        }

        @Generated
        public int getRenderDistance() {
            return this.renderDistance;
        }

        @Generated
        public int getSimulationDistance() {
            return this.simulationDistance;
        }

        @Generated
        public float getParticleDensity() {
            return this.particleDensity;
        }

        @Generated
        public float getSizeMultiplier() {
            return this.sizeMultiplier;
        }

        @Generated
        public float getGravityMultiplier() {
            return this.gravityMultiplier;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setWaterPhysics(boolean waterPhysics) {
            this.waterPhysics = waterPhysics;
        }

        @Generated
        public void setRandomSize(boolean randomSize) {
            this.randomSize = randomSize;
        }

        @Generated
        public void setRandomFadingSpeed(boolean randomFadingSpeed) {
            this.randomFadingSpeed = randomFadingSpeed;
        }

        @Generated
        public void setRenderDistance(int renderDistance) {
            this.renderDistance = renderDistance;
        }

        @Generated
        public void setSimulationDistance(int simulationDistance) {
            this.simulationDistance = simulationDistance;
        }

        @Generated
        public void setParticleDensity(float particleDensity) {
            this.particleDensity = particleDensity;
        }

        @Generated
        public void setSizeMultiplier(float sizeMultiplier) {
            this.sizeMultiplier = sizeMultiplier;
        }

        @Generated
        public void setGravityMultiplier(float gravityMultiplier) {
            this.gravityMultiplier = gravityMultiplier;
        }

        @Generated
        private Rain(boolean enabled, boolean waterPhysics, boolean randomSize, boolean randomFadingSpeed, int renderDistance, int simulationDistance, float particleDensity, float sizeMultiplier, float gravityMultiplier) {
            this.enabled = enabled;
            this.waterPhysics = waterPhysics;
            this.randomSize = randomSize;
            this.randomFadingSpeed = randomFadingSpeed;
            this.renderDistance = renderDistance;
            this.simulationDistance = simulationDistance;
            this.particleDensity = particleDensity;
            this.sizeMultiplier = sizeMultiplier;
            this.gravityMultiplier = gravityMultiplier;
        }
    }

    public static class Snow
    implements IFBPConfig<Snow> {
        private static final boolean DEFAULT_ENABLED = true;
        private static final boolean DEFAULT_LOW_TRACTION = false;
        private static final boolean DEFAULT_REST_ON_FLOOR = true;
        private static final boolean DEFAULT_BOUNCE_OFF_WALLS = true;
        private static final boolean DEFAULT_WATER_PHYSICS = false;
        private static final boolean DEFAULT_INFINITE_DURATION = false;
        private static final boolean DEFAULT_RANDOM_SIZE = true;
        private static final boolean DEFAULT_RANDOM_ROTATION = true;
        private static final boolean DEFAULT_RANDOM_FADING_SPEED = true;
        private static final int DEFAULT_MIN_LIFETIME = 250;
        private static final int DEFAULT_MAX_LIFETIME = 300;
        private static final int DEFAULT_RENDER_DISTANCE = 4;
        private static final int DEFAULT_SIMULATION_DISTANCE = 12;
        private static final float DEFAULT_PARTICLE_DENSITY = 1.0f;
        private static final float DEFAULT_SIZE_MULTIPLIER = 1.0f;
        private static final float DEFAULT_ROTATION_MULTIPLIER = 1.0f;
        private static final float DEFAULT_GRAVITY_MULTIPLIER = 1.0f;
        public static final Snow DEFAULT_CONFIG = new Snow(true, false, true, true, false, false, true, true, true, 250, 300, 4, 12, 1.0f, 1.0f, 1.0f, 1.0f);
        private boolean enabled;
        private boolean lowTraction;
        private boolean restOnFloor;
        private boolean bounceOffWalls;
        private boolean waterPhysics;
        private boolean infiniteDuration;
        private boolean randomSize;
        private boolean randomRotation;
        private boolean randomFadingSpeed;
        private int minLifetime;
        private int maxLifetime;
        private int renderDistance;
        private int simulationDistance;
        private float particleDensity;
        private float sizeMultiplier;
        private float rotationMultiplier;
        private float gravityMultiplier;

        @Override
        public void setConfig(Snow config) {
            this.enabled = config.enabled;
            this.lowTraction = config.lowTraction;
            this.restOnFloor = config.restOnFloor;
            this.bounceOffWalls = config.bounceOffWalls;
            this.waterPhysics = config.waterPhysics;
            this.infiniteDuration = config.infiniteDuration;
            this.randomSize = config.randomSize;
            this.randomRotation = config.randomRotation;
            this.randomFadingSpeed = config.randomFadingSpeed;
            this.minLifetime = config.minLifetime;
            this.maxLifetime = config.maxLifetime;
            this.renderDistance = config.renderDistance;
            this.simulationDistance = config.simulationDistance;
            this.particleDensity = config.particleDensity;
            this.sizeMultiplier = config.sizeMultiplier;
            this.rotationMultiplier = config.rotationMultiplier;
            this.gravityMultiplier = config.gravityMultiplier;
        }

        @Override
        public void load(JsonObject json) {
            this.enabled = class_3518.method_15258((JsonObject)json, (String)"enabled", (boolean)true);
            this.lowTraction = class_3518.method_15258((JsonObject)json, (String)"lowTraction", (boolean)false);
            this.restOnFloor = class_3518.method_15258((JsonObject)json, (String)"restOnFloor", (boolean)true);
            this.bounceOffWalls = class_3518.method_15258((JsonObject)json, (String)"bounceOffWalls", (boolean)true);
            this.waterPhysics = class_3518.method_15258((JsonObject)json, (String)"waterPhysics", (boolean)false);
            this.infiniteDuration = class_3518.method_15258((JsonObject)json, (String)"infiniteDuration", (boolean)false);
            this.randomSize = class_3518.method_15258((JsonObject)json, (String)"randomSize", (boolean)true);
            this.randomRotation = class_3518.method_15258((JsonObject)json, (String)"randomRotation", (boolean)true);
            this.randomFadingSpeed = class_3518.method_15258((JsonObject)json, (String)"randomFadingSpeed", (boolean)true);
            this.minLifetime = class_3518.method_15282((JsonObject)json, (String)"minLifetime", (int)250);
            this.maxLifetime = class_3518.method_15282((JsonObject)json, (String)"maxLifetime", (int)300);
            this.renderDistance = class_3518.method_15282((JsonObject)json, (String)"renderDistance", (int)4);
            this.simulationDistance = class_3518.method_15282((JsonObject)json, (String)"simulationDistance", (int)12);
            this.particleDensity = class_3518.method_15277((JsonObject)json, (String)"particleDensity", (float)1.0f);
            this.sizeMultiplier = class_3518.method_15277((JsonObject)json, (String)"sizeMultiplier", (float)1.0f);
            this.rotationMultiplier = class_3518.method_15277((JsonObject)json, (String)"rotationMultiplier", (float)1.0f);
            this.gravityMultiplier = class_3518.method_15277((JsonObject)json, (String)"gravityMultiplier", (float)1.0f);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("lowTraction", Boolean.valueOf(this.lowTraction));
            json.addProperty("restOnFloor", Boolean.valueOf(this.restOnFloor));
            json.addProperty("bounceOffWalls", Boolean.valueOf(this.bounceOffWalls));
            json.addProperty("waterPhysics", Boolean.valueOf(this.waterPhysics));
            json.addProperty("infiniteDuration", Boolean.valueOf(this.infiniteDuration));
            json.addProperty("randomSize", Boolean.valueOf(this.randomSize));
            json.addProperty("randomRotation", Boolean.valueOf(this.randomRotation));
            json.addProperty("randomFadingSpeed", Boolean.valueOf(this.randomFadingSpeed));
            json.addProperty("minLifetime", (Number)this.minLifetime);
            json.addProperty("maxLifetime", (Number)this.maxLifetime);
            json.addProperty("renderDistance", (Number)this.renderDistance);
            json.addProperty("simulationDistance", (Number)this.simulationDistance);
            json.addProperty("snowParticleDensity", (Number)Float.valueOf(this.particleDensity));
            json.addProperty("sizeMultiplier", (Number)Float.valueOf(this.sizeMultiplier));
            json.addProperty("rotationMultiplier", (Number)Float.valueOf(this.rotationMultiplier));
            json.addProperty("gravityMultiplier", (Number)Float.valueOf(this.gravityMultiplier));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Snow copy() {
            return new Snow(this.enabled, this.lowTraction, this.restOnFloor, this.bounceOffWalls, this.waterPhysics, this.infiniteDuration, this.randomSize, this.randomRotation, this.randomFadingSpeed, this.minLifetime, this.maxLifetime, this.renderDistance, this.simulationDistance, this.particleDensity, this.sizeMultiplier, this.rotationMultiplier, this.gravityMultiplier);
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isLowTraction() {
            return this.lowTraction;
        }

        @Generated
        public boolean isRestOnFloor() {
            return this.restOnFloor;
        }

        @Generated
        public boolean isBounceOffWalls() {
            return this.bounceOffWalls;
        }

        @Generated
        public boolean isWaterPhysics() {
            return this.waterPhysics;
        }

        @Generated
        public boolean isInfiniteDuration() {
            return this.infiniteDuration;
        }

        @Generated
        public boolean isRandomSize() {
            return this.randomSize;
        }

        @Generated
        public boolean isRandomRotation() {
            return this.randomRotation;
        }

        @Generated
        public boolean isRandomFadingSpeed() {
            return this.randomFadingSpeed;
        }

        @Generated
        public int getMinLifetime() {
            return this.minLifetime;
        }

        @Generated
        public int getMaxLifetime() {
            return this.maxLifetime;
        }

        @Generated
        public int getRenderDistance() {
            return this.renderDistance;
        }

        @Generated
        public int getSimulationDistance() {
            return this.simulationDistance;
        }

        @Generated
        public float getParticleDensity() {
            return this.particleDensity;
        }

        @Generated
        public float getSizeMultiplier() {
            return this.sizeMultiplier;
        }

        @Generated
        public float getRotationMultiplier() {
            return this.rotationMultiplier;
        }

        @Generated
        public float getGravityMultiplier() {
            return this.gravityMultiplier;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setLowTraction(boolean lowTraction) {
            this.lowTraction = lowTraction;
        }

        @Generated
        public void setRestOnFloor(boolean restOnFloor) {
            this.restOnFloor = restOnFloor;
        }

        @Generated
        public void setBounceOffWalls(boolean bounceOffWalls) {
            this.bounceOffWalls = bounceOffWalls;
        }

        @Generated
        public void setWaterPhysics(boolean waterPhysics) {
            this.waterPhysics = waterPhysics;
        }

        @Generated
        public void setInfiniteDuration(boolean infiniteDuration) {
            this.infiniteDuration = infiniteDuration;
        }

        @Generated
        public void setRandomSize(boolean randomSize) {
            this.randomSize = randomSize;
        }

        @Generated
        public void setRandomRotation(boolean randomRotation) {
            this.randomRotation = randomRotation;
        }

        @Generated
        public void setRandomFadingSpeed(boolean randomFadingSpeed) {
            this.randomFadingSpeed = randomFadingSpeed;
        }

        @Generated
        public void setMinLifetime(int minLifetime) {
            this.minLifetime = minLifetime;
        }

        @Generated
        public void setMaxLifetime(int maxLifetime) {
            this.maxLifetime = maxLifetime;
        }

        @Generated
        public void setRenderDistance(int renderDistance) {
            this.renderDistance = renderDistance;
        }

        @Generated
        public void setSimulationDistance(int simulationDistance) {
            this.simulationDistance = simulationDistance;
        }

        @Generated
        public void setParticleDensity(float particleDensity) {
            this.particleDensity = particleDensity;
        }

        @Generated
        public void setSizeMultiplier(float sizeMultiplier) {
            this.sizeMultiplier = sizeMultiplier;
        }

        @Generated
        public void setRotationMultiplier(float rotationMultiplier) {
            this.rotationMultiplier = rotationMultiplier;
        }

        @Generated
        public void setGravityMultiplier(float gravityMultiplier) {
            this.gravityMultiplier = gravityMultiplier;
        }

        @Generated
        private Snow(boolean enabled, boolean lowTraction, boolean restOnFloor, boolean bounceOffWalls, boolean waterPhysics, boolean infiniteDuration, boolean randomSize, boolean randomRotation, boolean randomFadingSpeed, int minLifetime, int maxLifetime, int renderDistance, int simulationDistance, float particleDensity, float sizeMultiplier, float rotationMultiplier, float gravityMultiplier) {
            this.enabled = enabled;
            this.lowTraction = lowTraction;
            this.restOnFloor = restOnFloor;
            this.bounceOffWalls = bounceOffWalls;
            this.waterPhysics = waterPhysics;
            this.infiniteDuration = infiniteDuration;
            this.randomSize = randomSize;
            this.randomRotation = randomRotation;
            this.randomFadingSpeed = randomFadingSpeed;
            this.minLifetime = minLifetime;
            this.maxLifetime = maxLifetime;
            this.renderDistance = renderDistance;
            this.simulationDistance = simulationDistance;
            this.particleDensity = particleDensity;
            this.sizeMultiplier = sizeMultiplier;
            this.rotationMultiplier = rotationMultiplier;
            this.gravityMultiplier = gravityMultiplier;
        }
    }

    public static class Animations
    implements IFBPConfig<Animations> {
        private static final boolean DEFAULT_FANCY_PLACING_ANIMATION = false;
        private static final boolean DEFAULT_SMOOTH_ANIMATION_LIGHTING = false;
        public static final Animations DEFAULT_CONFIG = new Animations(false, false);
        private boolean fancyPlacingAnimation;
        private boolean smoothAnimationLighting;

        @Override
        public void setConfig(Animations config) {
            this.fancyPlacingAnimation = config.fancyPlacingAnimation;
            this.smoothAnimationLighting = config.smoothAnimationLighting;
        }

        @Override
        public void load(JsonObject json) {
            this.fancyPlacingAnimation = class_3518.method_15258((JsonObject)json, (String)"fancyPlacingAnimation", (boolean)false);
            this.smoothAnimationLighting = class_3518.method_15258((JsonObject)json, (String)"smoothAnimationLighting", (boolean)false);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("fancyPlacingAnimation", Boolean.valueOf(this.fancyPlacingAnimation));
            json.addProperty("smoothAnimationLighting", Boolean.valueOf(this.smoothAnimationLighting));
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Animations copy() {
            return new Animations(this.fancyPlacingAnimation, this.smoothAnimationLighting);
        }

        @Generated
        public boolean isFancyPlacingAnimation() {
            return this.fancyPlacingAnimation;
        }

        @Generated
        public boolean isSmoothAnimationLighting() {
            return this.smoothAnimationLighting;
        }

        @Generated
        public void setFancyPlacingAnimation(boolean fancyPlacingAnimation) {
            this.fancyPlacingAnimation = fancyPlacingAnimation;
        }

        @Generated
        public void setSmoothAnimationLighting(boolean smoothAnimationLighting) {
            this.smoothAnimationLighting = smoothAnimationLighting;
        }

        @Generated
        private Animations(boolean fancyPlacingAnimation, boolean smoothAnimationLighting) {
            this.fancyPlacingAnimation = fancyPlacingAnimation;
            this.smoothAnimationLighting = smoothAnimationLighting;
        }
    }

    public static class Overlay
    implements IFBPConfig<Overlay> {
        private static final boolean DEFAULT_FREEZE_EFFECT_OVERLAY = true;
        private static final int DEFAULT_FREEZE_EFFECT_COLOR = 33023;
        public static final Overlay DEFAULT_CONFIG = new Overlay(true, 33023);
        private boolean freezeEffectOverlay;
        private int freezeEffectColor;

        @Override
        public void setConfig(Overlay config) {
            this.freezeEffectOverlay = config.freezeEffectOverlay;
            this.freezeEffectColor = config.freezeEffectColor;
        }

        @Override
        public void load(JsonObject json) {
            this.freezeEffectOverlay = class_3518.method_15258((JsonObject)json, (String)"freezeEffectOverlay", (boolean)true);
            this.freezeEffectColor = class_3518.method_15282((JsonObject)json, (String)"freezeEffectColor", (int)33023);
        }

        @Override
        public JsonObject save() {
            JsonObject json = new JsonObject();
            json.addProperty("freezeEffectOverlay", Boolean.valueOf(this.freezeEffectOverlay));
            json.addProperty("freezeEffectColor", (Number)this.freezeEffectColor);
            return json;
        }

        @Override
        public void reset() {
            this.setConfig(DEFAULT_CONFIG.copy());
        }

        @Override
        public Overlay copy() {
            return new Overlay(this.freezeEffectOverlay, this.freezeEffectColor);
        }

        @Generated
        public boolean isFreezeEffectOverlay() {
            return this.freezeEffectOverlay;
        }

        @Generated
        public int getFreezeEffectColor() {
            return this.freezeEffectColor;
        }

        @Generated
        public void setFreezeEffectOverlay(boolean freezeEffectOverlay) {
            this.freezeEffectOverlay = freezeEffectOverlay;
        }

        @Generated
        public void setFreezeEffectColor(int freezeEffectColor) {
            this.freezeEffectColor = freezeEffectColor;
        }

        @Generated
        private Overlay(boolean freezeEffectOverlay, int freezeEffectColor) {
            this.freezeEffectOverlay = freezeEffectOverlay;
            this.freezeEffectColor = freezeEffectColor;
        }
    }
}

