/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import org.joml.Vector3f;

public abstract class AirplaneEntity
extends EngineAircraft {
    private final AircraftProperties properties = new AircraftProperties(this).setYawSpeed(5.0f).setPitchSpeed(4.0f).setEngineSpeed(0.0225f).setGlideFactor(0.05f).setDriftDrag(0.01f).setLift(0.15f).setRollFactor(45.0f).setGroundPitch(4.0f).setWindSensitivity(0.025f).setMass(1.0f);

    public AirplaneEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected boolean useAirplaneControls() {
        return true;
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    protected float getGroundVelocityDecay() {
        return this.falloffGroundVelocityDecay(0.9f);
    }

    @Override
    protected float getGravity() {
        Vector3f direction = this.getDirection();
        float speed = (float)this.method_18798().method_1033() * (1.0f - Math.abs(direction.y));
        return Math.max(0.0f, 1.0f - speed * 1.5f) * super.getGravity();
    }

    protected float getBrakeFactor() {
        return 0.95f;
    }

    @Override
    protected void updateController() {
        if (!this.method_5782()) {
            return;
        }
        super.updateController();
        if (this.movementY != 0.0f) {
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + 0.1f * this.movementY)));
            if (this.movementY < 0.0f) {
                this.method_18799(this.method_18798().method_1021((double)this.getBrakeFactor()));
            }
        }
        Vector3f direction = this.getDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.properties.getEngineSpeed());
        this.method_18799(this.method_18798().method_1019(this.toVec3d(direction.mul(thrust))));
    }
}

