/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.joml.Vector3f;

public class GyrodyneEntity
extends Rotorcraft {
    private static final float PUSH_SPEED = 0.25f;
    private final AircraftProperties properties = new AircraftProperties(this).setYawSpeed(5.0f).setPitchSpeed(5.0f).setEngineSpeed(0.3f).setVerticalSpeed(0.04f).setDriftDrag(0.01f).setLift(0.1f).setRollFactor(30.0f).setWindSensitivity(0.05f).setMass(4.0f);
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.WEAPON, 14, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 36, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 14, 36).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 36, 36).addSlots(VehicleInventoryDescription.SlotType.INVENTORY, 62, 8, 6, 3).build();
    final List<List<Vector3f>> PASSENGER_POSITIONS = List.of(List.of(new Vector3f(0.0f, -0.1f, 0.3f)), List.of(new Vector3f(0.0f, -0.1f, 0.3f), new Vector3f(0.0f, -0.1f, -0.6f)));

    @Override
    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    @Override
    public EngineAircraft.GUI_STYLE getGuiStyle() {
        return EngineAircraft.GUI_STYLE.NONE;
    }

    public GyrodyneEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected class_3414 getEngineStartSound() {
        return Sounds.WOOSH.get();
    }

    @Override
    protected class_3414 getEngineSound() {
        return Sounds.WOOSH.get();
    }

    @Override
    protected float getStabilizer() {
        return 0.3f;
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    protected float getGroundVelocityDecay() {
        return this.falloffGroundVelocityDecay(0.8f);
    }

    @Override
    protected float getHorizontalVelocityDelay() {
        return 0.925f;
    }

    @Override
    protected float getVerticalVelocityDelay() {
        return 0.9f;
    }

    @Override
    public class_1792 asItem() {
        return Items.GYRODYNE.get();
    }

    @Override
    protected List<List<Vector3f>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    protected float getGravity() {
        return (1.0f - this.getEnginePower()) * super.getGravity();
    }

    private void updateEnginePowerTooltip() {
        class_1297 class_12972 = this.method_5642();
        if (class_12972 instanceof class_746) {
            class_746 player = (class_746)class_12972;
            if ((double)this.getFuelUtilization() > 0.0) {
                player.method_7353((class_2561)class_2561.method_43469((String)"immersive_aircraft.gyrodyne_target", (Object[])new Object[]{(int)(this.getEngineTarget() * 100.0f + 0.5f)}), true);
            }
        }
    }

    @Override
    protected String getFuelType() {
        return "fat";
    }

    @Override
    protected boolean isFuelLow() {
        return false;
    }

    @Override
    protected void updateController() {
        super.updateController();
        if (this.getEngineTarget() < 1.0f) {
            class_1297 class_12972;
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + this.pressingInterpolatedZ.getValue() * 0.05f - 0.035f)));
            this.updateEnginePowerTooltip();
            if ((double)this.getEngineTarget() == 1.0 && (class_12972 = this.method_5642()) instanceof class_746) {
                class_746 player = (class_746)class_12972;
                player.method_7353((class_2561)class_2561.method_43471((String)"immersive_aircraft.gyrodyne_target_reached"), true);
                if (this.field_5952) {
                    this.method_18799(this.method_18798().method_1031(0.0, 0.25, 0.0));
                }
            }
        }
        float power = this.getEnginePower() * this.properties.getVerticalSpeed() * this.pressingInterpolatedY.getSmooth();
        Vector3f f = this.getTopDirection().mul(power);
        this.method_18799(this.method_18798().method_1031((double)f.x, (double)f.y, (double)f.z));
        Vector3f direction = this.getDirection();
        float sin = class_3532.method_15374((float)(this.method_36455() * ((float)Math.PI / 180)));
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.properties.getEngineSpeed()) * sin;
        if (this.field_5952 && (double)this.getEngineTarget() < 1.0) {
            thrust = 0.25f / (1.0f + (float)this.method_18798().method_1033() * 5.0f) * this.pressingInterpolatedZ.getSmooth() * ((double)this.pressingInterpolatedZ.getSmooth() > 0.0 ? 1.0f : 0.5f) * this.getEnginePower();
        }
        Vector3f f2 = direction.mul(thrust);
        this.method_18799(this.method_18798().method_1031((double)f2.x, (double)f2.y, (double)f2.z));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        class_1297 class_12972 = this.method_5642();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            float consumption = this.getFuelConsumption() * 0.025f;
            player.method_7344().method_7583(consumption);
        }
    }

    @Override
    public float getFuelUtilization() {
        class_1657 player;
        class_1297 class_12972 = this.method_5642();
        if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972).method_7344().method_7586() > 5) {
            return 1.0f;
        }
        return 0.0f;
    }
}

