/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft;

import baguchan.mcmod.tofucraft.CommonProxy;
import baguchan.mcmod.tofucraft.api.recipes.TofuEnergyMap;
import baguchan.mcmod.tofucraft.client.ClientProxy;
import baguchan.mcmod.tofucraft.client.ClientRegistrar;
import baguchan.mcmod.tofucraft.entity.MorijioEntity;
import baguchan.mcmod.tofucraft.event.EntityEvent;
import baguchan.mcmod.tofucraft.init.TofuCriterias;
import baguchan.mcmod.tofucraft.init.TofuDamageSource;
import baguchan.mcmod.tofucraft.init.TofuDimensions;
import baguchan.mcmod.tofucraft.init.TofuEffectRegistry;
import baguchan.mcmod.tofucraft.init.TofuItems;
import baguchan.mcmod.tofucraft.init.TofuRecipes;
import baguchan.mcmod.tofucraft.init.TofuVillagers;
import baguchan.mcmod.tofucraft.network.TofuNetworkHandler;
import baguchan.mcmod.tofucraft.world.gen.feature.TofuDefaultBiomeFeatures;
import java.util.List;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tofucraft")
public class TofuCraftCore {
    public static final Logger LOGGER = LogManager.getLogger((String)"tofucraft");
    public static final String MODID = "tofucraft";
    public static CommonProxy PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);

    public TofuCraftCore() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientRegistrar::setup));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(MODID, name);
    }

    private void setup(FMLCommonSetupEvent event) {
        TofuNetworkHandler.register();
        TofuDefaultBiomeFeatures.init();
        TofuEnergyMap.init();
        TofuRecipes.init();
        TofuVillagers.init();
        TofuCriterias.register();
        TofuDimensions.init();
        MinecraftForge.EVENT_BUS.register((Object)new EntityEvent());
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onGrassBroken(BlockEvent.BreakEvent event) {
        if (!event.getWorld().func_201670_d() && !event.getPlayer().func_184812_l_() && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof TallGrassBlock) {
            if (Math.random() <= 0.035) {
                event.getWorld().func_217376_c((Entity)new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), new ItemStack((IItemProvider)TofuItems.SEEDS_SOYBEAN)));
            } else if (Math.random() <= 0.03) {
                event.getWorld().func_217376_c((Entity)new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), new ItemStack((IItemProvider)TofuItems.SEEDS_RICE)));
            }
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (event.getSource().func_76352_a() && livingEntity.func_70660_b(TofuEffectRegistry.TOFU_RESISTANCE) != null) {
            event.setAmount(event.getAmount() * 0.75f);
        }
        if (!event.getSource().func_82725_o() && event.getSource() != DamageSource.field_76366_f && event.getSource() != DamageSource.field_82727_n && livingEntity.func_70660_b(TofuEffectRegistry.UNSTABLE_RESISTANCE) != null) {
            event.setAmount(event.getAmount() * 1.25f);
        }
        if (event.getSource() == TofuDamageSource.POISED_ZUNDAMA && event.getAmount() <= 4.0f && livingEntity.func_70644_a(TofuEffectRegistry.ANTI_TOXIC)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void addPotionEvent(PotionEvent.PotionApplicableEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity.func_70644_a(TofuEffectRegistry.ANTI_TOXIC) && event.getPotionEffect().func_188419_a() == Effects.field_76436_u) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onCheckSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        List list;
        if ((event.getEntityLiving().func_200600_R().func_220339_d() == EntityClassification.MONSTER || event.getEntityLiving() instanceof IMob) && event.getSpawnReason() != SpawnReason.STRUCTURE && event.getSpawnReason() != SpawnReason.EVENT && event.getSpawnReason() != SpawnReason.MOB_SUMMONED && event.getSpawnReason() != SpawnReason.SPAWN_EGG && (list = event.getWorld().func_217357_a(MorijioEntity.class, event.getEntityLiving().func_174813_aQ().func_72321_a(48.0, 48.0, 48.0))).size() > 0) {
            event.setResult(Event.Result.DENY);
        }
    }

    protected static BlockRayTraceResult rayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vector3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vector3d1 = vector3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }
}

