/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.api.recipes;

import baguchan.mcmod.tofucraft.utils.ItemStackUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class AggregatorRecipes {
    public static final Map<ItemStack, ItemStack> recipesList = Maps.newHashMap();

    private AggregatorRecipes() {
    }

    public static void addRecipe(ItemStack input, ItemStack stack) {
        if (AggregatorRecipes.findResult(input)) {
            return;
        }
        recipesList.put(input, stack);
    }

    public static boolean findResult(ItemStack input) {
        for (ItemStack key : recipesList.keySet()) {
            if (!AggregatorRecipes.compareItems(key, input)) continue;
            return true;
        }
        return false;
    }

    public static Map.Entry<ItemStack, ItemStack> getResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : recipesList.entrySet()) {
            if (!AggregatorRecipes.compareItems(entry.getKey(), stack) || ItemStackUtil.getSomeAmount(entry.getKey()) > stack.func_190916_E()) continue;
            return entry;
        }
        return null;
    }

    public static Map<ItemStack, ItemStack> getRecipeList() {
        return recipesList;
    }

    public static void removeRecipe(ItemStack input) {
        recipesList.remove(input);
    }

    public static void clearAllRecipes() {
        recipesList.clear();
    }

    public static boolean compareItems(ItemStack input, ItemStack output) {
        ItemStack inputItem = input;
        ItemStack outputItem = output;
        boolean flag = true;
        if (inputItem.func_77942_o() && outputItem.func_77942_o()) {
            flag = outputItem.func_77978_p().equals((Object)inputItem.func_77978_p());
        }
        return ItemStack.func_179545_c((ItemStack)input, (ItemStack)output) && flag;
    }
}

