/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.api.tfenergy;

import baguchan.mcmod.tofucraft.api.tfenergy.ITofuEnergy;
import baguchan.mcmod.tofucraft.api.tfenergy.TofuNetworkChangedEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TofuNetwork {
    public static final TofuNetwork Instance = new TofuNetwork();
    private HashMap<String, TileEntity> reference = new HashMap();

    public static List<String> toUUIDs(Stream<Map.Entry<String, TileEntity>> map) {
        ArrayList<String> uids = new ArrayList<String>();
        map.forEach(entry -> uids.add((String)entry.getKey()));
        return uids;
    }

    public static List<TileEntity> toTiles(Stream<Map.Entry<String, TileEntity>> map) {
        ArrayList<TileEntity> tes = new ArrayList<TileEntity>();
        map.forEach(entry -> tes.add((TileEntity)entry.getValue()));
        return tes;
    }

    @SubscribeEvent
    public static void onUnloadWorld(WorldEvent.Unload event) {
        if (event.getWorld() instanceof World) {
            World world = (World)event.getWorld();
            for (String uid : TofuNetwork.toUUIDs(Instance.getTEWithinDim(world.func_234923_W_().getRegistryName()))) {
                Instance.unload(uid, true);
            }
        }
    }

    public TileEntity find(String uid) {
        return this.reference.get(uid);
    }

    public void register(String uid, TileEntity te) {
        this.register(uid, te, false);
    }

    public void register(String uid, TileEntity te, boolean isSystem) {
        if (!(te instanceof ITofuEnergy)) {
            throw new IllegalArgumentException("Can't register machine which is not Tofu Energy Tile!");
        }
        this.reference.put(uid, te);
        MinecraftForge.EVENT_BUS.post((Event)new TofuNetworkChangedEvent.NetworkLoaded(uid, te, isSystem));
    }

    public HashMap<String, TileEntity> getReference() {
        return this.reference;
    }

    public Stream<Map.Entry<String, TileEntity>> getTEWithinDim(ResourceLocation dimid) {
        return this.reference.entrySet().stream().filter(entry -> ((TileEntity)entry.getValue()).func_145831_w() != null && ((TileEntity)entry.getValue()).func_145831_w().func_234923_W_().getRegistryName().equals((Object)dimid));
    }

    public Stream<Map.Entry<String, TileEntity>> getTEWithinRadius(World world, BlockPos pos, double radius) {
        return this.getTEWithinDim(world.func_234923_W_().getRegistryName()).filter(entry -> ((TileEntity)entry.getValue()).func_174877_v().func_218141_a((Vector3i)new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), radius));
    }

    public Stream<Map.Entry<String, TileEntity>> getTEWithinRadius(TileEntity center, double radius) {
        BlockPos pos = center.func_174877_v();
        return this.getTEWithinDim(center.func_145831_w().func_234923_W_().getRegistryName()).filter(entry -> ((TileEntity)entry.getValue()).func_174877_v().func_218141_a((Vector3i)new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), radius));
    }

    public Stream<Map.Entry<String, TileEntity>> getExtractableWithinRadius(World world, BlockPos pos, double radius) {
        return this.getTEWithinRadius(world, pos, radius).filter(entry -> ((ITofuEnergy)entry.getValue()).canDrain(null));
    }

    public Stream<Map.Entry<String, TileEntity>> getExtractableWithinRadius(TileEntity center, double radius) {
        if (!(center instanceof ITofuEnergy)) {
            throw new IllegalArgumentException("The center tile is not able to transfer energy!");
        }
        return this.getTEWithinRadius(center, radius).filter(entry -> ((ITofuEnergy)entry.getValue()).canDrain(center) && ((ITofuEnergy)center).canReceive((TileEntity)entry.getValue()));
    }

    public Stream<Map.Entry<String, TileEntity>> getInsertableWithinRadius(World world, BlockPos pos, double radius) {
        return this.getTEWithinRadius(world, pos, radius).filter(entry -> ((ITofuEnergy)entry.getValue()).canReceive(null));
    }

    public Stream<Map.Entry<String, TileEntity>> getInsertableWithinRadius(TileEntity center, double radius) {
        if (!(center instanceof ITofuEnergy)) {
            throw new IllegalArgumentException("The center tile is not able to transfer energy!");
        }
        return this.getTEWithinRadius(center, radius).filter(entry -> ((ITofuEnergy)entry.getValue()).canReceive(center) && ((ITofuEnergy)center).canDrain((TileEntity)entry.getValue()));
    }

    public void unload(String uid) {
        this.unload(uid, false);
    }

    public void unload(String uid, boolean isSystem) {
        this.reference.remove(uid);
        MinecraftForge.EVENT_BUS.post((Event)new TofuNetworkChangedEvent.NetworkRemoved(uid, this.reference.get(uid), isSystem));
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean isSystem) {
        this.reference.clear();
        MinecraftForge.EVENT_BUS.post((Event)new TofuNetworkChangedEvent.NetworkCleared(isSystem));
    }
}

