/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.block;

import baguchan.mcmod.tofucraft.init.TofuBlocks;
import baguchan.mcmod.tofucraft.init.TofuDimensions;
import baguchan.mcmod.tofucraft.init.TofuParticles;
import baguchan.mcmod.tofucraft.world.dimension.TofuWorldTeleporter;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TofuPortalBlock
extends Block {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape NULL = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public TofuPortalBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean trySpawnPortal(World worldIn, BlockPos pos) {
        Size size = new Size((IWorld)worldIn, pos);
        if (size.isValid()) {
            size.placePortalBlocks();
            worldIn.func_184133_a(null, pos, SoundEvents.field_193782_bq, SoundCategory.BLOCKS, 0.7f, 1.0f);
            return true;
        }
        Size size1 = new Size((IWorld)worldIn, pos);
        if (size1.isValid()) {
            size1.placePortalBlocks();
            worldIn.func_184133_a(null, pos, SoundEvents.field_193782_bq, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)((float)pos.func_177956_o() + rand.nextFloat()) + 0.8;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = (double)rand.nextFloat() * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            worldIn.func_195590_a((IParticleData)TofuParticles.TOFUPORTAL, false, d0, d1, d2, d3, d4, d5);
        }
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean good = world.func_180495_p(pos.func_177977_b()).func_200132_m();
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (!good) break;
            BlockState neighboringState = world.func_180495_p(pos.func_177972_a(facing));
            good = neighboringState.func_177230_c() == TofuBlocks.GRILLEDTOFU || neighboringState == state;
        }
        if (!good) {
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            world.func_180501_a(pos, TofuBlocks.SOYMILK.func_176223_P(), 3);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (entity.func_70089_S() && !entity.field_70170_p.field_72995_K && !entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            if (!entity.func_242280_ah()) {
                entity.func_242279_ag();
                boolean inOverworld = entity.field_70170_p.func_234923_W_() != TofuDimensions.tofu_world;
                MinecraftServer server = worldIn.func_73046_m();
                if (entity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity thePlayer = (ServerPlayerEntity)entity;
                    if (inOverworld) {
                        ServerWorld dimWorld = server.func_71218_a(this.getTofuDimension());
                        if (dimWorld != null) {
                            this.teleportEntity((Entity)thePlayer, dimWorld, pos);
                        }
                    } else {
                        ServerWorld dimWorld = server.func_71218_a(World.field_234918_g_);
                        if (dimWorld != null) {
                            this.teleportEntity((Entity)thePlayer, dimWorld, pos);
                        }
                    }
                }
                if (!(entity instanceof PlayerEntity)) {
                    ServerWorld dimWorld;
                    if (inOverworld) {
                        dimWorld = server.func_71218_a(this.getTofuDimension());
                        if (dimWorld != null) {
                            this.teleportEntity(entity, dimWorld, pos);
                        }
                    } else {
                        dimWorld = server.func_71218_a(World.field_234918_g_);
                        if (dimWorld != null) {
                            this.teleportEntity(entity, dimWorld, pos);
                        }
                    }
                }
            } else {
                entity.func_242279_ag();
            }
        }
    }

    public RegistryKey<World> getTofuDimension() {
        ResourceLocation resourcelocation = new ResourceLocation("tofucraft:tofu_world");
        RegistryKey registrykey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)resourcelocation);
        return registrykey;
    }

    private Entity teleportEntity(Entity entity, ServerWorld endpointWorld, BlockPos endpoint) {
        if (entity.field_70170_p instanceof ServerWorld) {
            IChunk chunk = endpointWorld.func_217349_x(endpoint);
            PortalInfo portalInfo = TofuWorldTeleporter.reposition(entity, endpointWorld);
            if (portalInfo == null) {
                int height = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, endpoint.func_177958_n(), endpoint.func_177952_p()) + 1;
                endpoint = new BlockPos(endpoint.func_177958_n(), height, endpoint.func_177952_p());
            } else {
                endpoint = new BlockPos(portalInfo.field_222505_a.func_82615_a(), portalInfo.field_222505_a.func_82617_b(), portalInfo.field_222505_a.func_82616_c());
            }
            if (entity instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                player.func_200619_a(endpointWorld, (double)endpoint.func_177958_n() + 0.5, (double)endpoint.func_177956_o() + 0.5, (double)endpoint.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
                return player;
            }
            entity.func_213319_R();
            entity.func_241206_a_(endpointWorld);
            Entity teleportedEntity = entity.func_200600_R().func_200721_a((World)endpointWorld);
            if (teleportedEntity == null) {
                return entity;
            }
            teleportedEntity.func_180432_n(entity);
            teleportedEntity.func_70012_b((double)endpoint.func_177958_n() + 0.5, (double)endpoint.func_177956_o() + 0.5, (double)endpoint.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
            teleportedEntity.func_70034_d(entity.field_70177_z);
            endpointWorld.func_217460_e(teleportedEntity);
            entity.remove(true);
            return teleportedEntity;
        }
        return null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return NULL;
    }

    public static class Size {
        private static final int MAX_SIZE = 12;
        private static final int MIN_SIZE = 1;
        private final IWorld world;
        private boolean valid = false;
        private BlockPos nw;
        private BlockPos se;

        public Size(IWorld world, BlockPos pos) {
            this.world = world;
            int east = this.getDistanceUntilEdge(pos, Direction.EAST);
            int west = this.getDistanceUntilEdge(pos, Direction.WEST);
            int north = this.getDistanceUntilEdge(pos, Direction.NORTH);
            int south = this.getDistanceUntilEdge(pos, Direction.SOUTH);
            int width = east + west - 1;
            int length = north + south - 1;
            if (width > 12 || length > 12) {
                return;
            }
            if (width < 1 || length < 1) {
                return;
            }
            BlockPos neCorner = pos.func_177965_g(east).func_177964_d(north);
            BlockPos nwCorner = pos.func_177985_f(west).func_177964_d(north);
            BlockPos seCorner = pos.func_177965_g(east).func_177970_e(south);
            BlockPos swCorner = pos.func_177985_f(west).func_177970_e(south);
            BlockPos eastPos = pos.func_177965_g(east);
            BlockPos westPos = pos.func_177985_f(west);
            BlockPos southPos = pos.func_177970_e(south);
            BlockPos northPos = pos.func_177964_d(north);
            BlockPos eastPos2 = pos.func_177974_f();
            BlockPos westPos2 = pos.func_177976_e();
            BlockPos southPos2 = pos.func_177968_d();
            BlockPos northPos2 = pos.func_177978_c();
            this.nw = nwCorner.func_177982_a(1, 0, 1);
            this.se = seCorner.func_177982_a(-1, 0, -1);
            int wallWidth = width + 2;
            int wallLength = length + 2;
            for (int y = 0; y <= 1; ++y) {
                for (int x = 0; x < wallWidth; ++x) {
                    for (int z = 0; z < wallLength; ++z) {
                        if ((y != 0 || x == 0 || z == 0 || x == wallWidth - 1 || z == wallLength - 1) && (y != 1 || x != 0 && z != 0 && x != wallWidth - 1 && z != wallLength - 1) || this.isTofuBlock(world.func_180495_p(nwCorner.func_177977_b().func_177982_a(x, y, z)))) continue;
                        return;
                    }
                }
            }
            this.valid = true;
        }

        int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 9 && this.isEmptyBlock(this.world.func_180495_p(blockpos = pos.func_177967_a(facing, i))) && this.isTofuBlock(this.world.func_180495_p(blockpos.func_177977_b())); ++i) {
            }
            BlockState state = this.world.func_180495_p(pos.func_177967_a(facing, i));
            return this.isTofuBlock(state) ? i : 0;
        }

        boolean isEmptyBlock(BlockState state) {
            return state.func_177230_c() == TofuBlocks.SOYMILK;
        }

        boolean isTofuBlock(BlockState state) {
            return state.func_177230_c() == TofuBlocks.GRILLEDTOFU;
        }

        public boolean isValid() {
            return this.valid;
        }

        void placePortalBlocks() {
            for (BlockPos portalPos : BlockPos.Mutable.func_218278_a((BlockPos)this.nw, (BlockPos)this.se)) {
                this.world.func_180501_a(portalPos, TofuBlocks.TOFUPORTAL.func_176223_P(), 2);
            }
        }
    }
}

