/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.block.crop;

import baguchan.mcmod.tofucraft.init.TofuItems;
import baguchan.mcmod.tofucraft.init.TofuSounds;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.ForgeEventFactory;

public class SoyBeanSoulCropsBlock
extends BushBlock
implements IGrowable {
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0)};
    public static final IntegerProperty AGE = BlockStateProperties.field_208170_W;

    public SoyBeanSoulCropsBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        super.func_225542_b_(state, worldIn, pos, random);
        if (this.isMaxAge(state) && random.nextInt(2) == 0) {
            worldIn.func_184133_a(null, pos, TofuSounds.SOUL_BREATH, SoundCategory.BLOCKS, 1.2f, 1.0f + random.nextFloat() * 0.1f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (this.isMaxAge(stateIn) && rand.nextInt(10) == 0) {
            double d4 = rand.nextBoolean() ? 0.6 : -0.6;
            double d0 = (double)pos.func_177958_n() + 0.5 + (double)rand.nextFloat() * d4;
            double d1 = (float)pos.func_177956_o() + 0.4f + rand.nextFloat() * 0.6f;
            double d2 = (double)pos.func_177952_p() + 0.5 + (double)rand.nextFloat() * d4;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_239812_C_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_150425_aM || state.func_177230_c() == Blocks.field_235372_ml_ || state.func_177230_c() == Blocks.field_235336_cN_;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.func_200014_a_(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.NETHER;
    }

    protected IItemProvider getSeedsItem() {
        return TofuItems.SEEDS_SOYBEAN_SOUL;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this.getSeedsItem());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)this.getAgeProperty())];
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        float f;
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        int i = this.getAge(state);
        if (i < this.getMaxAge() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / (f = SoyBeanSoulCropsBlock.getGrowthChance((Block)this, (IBlockReader)worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, this.withAge(i + 1), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void grow(World worldIn, BlockPos pos, BlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.withAge(i), 2);
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
    }

    protected static float getGrowthChance(Block blockIn, IBlockReader worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (blockstate.canSustainPlant(worldIn, blockpos.func_177982_a(i, 0, j), Direction.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (blockstate.func_203425_a(Blocks.field_150425_aM) || blockstate.func_203425_a(Blocks.field_235336_cN_) || blockstate.func_203425_a(Blocks.field_235372_ml_)) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof RavagerEntity && ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entityIn)) {
            worldIn.func_225521_a_(pos, true, entityIn);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        this.grow((World)worldIn, pos, state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }
}

