/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.block.crop;

import baguchan.mcmod.tofucraft.init.TofuItems;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public class WheatBowlBlock
extends Block {
    public static VoxelShape WHEATBOWL_AABB = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
    public static final EnumProperty<Stat> STAT = EnumProperty.func_177709_a((String)"stat", Stat.class);
    public static final IntegerProperty LEVEL = IntegerProperty.func_177719_a((String)"level", (int)0, (int)4);

    public WheatBowlBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(STAT, (Comparable)((Object)Stat.EMPTY))).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.PASS;
        }
        ItemStack itemHeld = player.func_184586_b(handIn);
        Stat stat = this.getStat(state);
        if (stat == Stat.KOUJI) {
            if ((Integer)state.func_177229_b((Property)LEVEL) > 0) {
                ItemStack kouji = new ItemStack((IItemProvider)TofuItems.KOUJI, ((Integer)state.func_177229_b((Property)LEVEL)).intValue());
                float f = 0.7f;
                double d0 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
                double d2 = (double)(worldIn.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                ItemEntity itemEntity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, kouji);
                itemEntity.func_174867_a(10);
                worldIn.func_217376_c((Entity)itemEntity);
                worldIn.func_184133_a(null, pos, SoundEvents.field_219620_bh, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a(STAT, (Comparable)((Object)Stat.EMPTY))).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0)), 3);
        } else if (itemHeld.func_77973_b() == TofuItems.KOUJIBASE) {
            if (stat == Stat.EMPTY) {
                if (!player.func_184812_l_()) {
                    itemHeld.func_190918_g(1);
                }
                worldIn.func_184133_a(null, pos, SoundEvents.field_219621_bi, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a(STAT, (Comparable)((Object)Stat.KOUJIBASE))).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(1)), 3);
            } else if (stat == Stat.KOUJIBASE && (Integer)state.func_177229_b((Property)LEVEL) < 4) {
                if (!player.func_184812_l_()) {
                    itemHeld.func_190918_g(1);
                }
                worldIn.func_184133_a(null, pos, SoundEvents.field_219621_bi, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)LEVEL) + 1)), 3);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        float f;
        Stat stat = this.getStat(state);
        if (stat == Stat.KOUJIBASE && (f = this.calcWarmth((World)worldIn, pos)) > 0.0f && rand.nextInt((int)(27.0f / f) + 1) == 0) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(STAT, (Comparable)((Object)Stat.KOUJI)), 2);
        }
    }

    private float calcWarmth(World world, BlockPos pos) {
        float rate;
        Biome biome = world.func_226691_t_(pos);
        boolean isUnderTheSun = world.func_175710_j(pos);
        boolean isRaining = world.func_72896_J();
        boolean isDaytime = world.func_72820_D() % 24000L < 12000L;
        float humidity = biome.func_76727_i();
        float temperature = biome.func_225486_c(pos);
        if (isUnderTheSun && isRaining) {
            rate = 0.0f;
        } else {
            rate = isDaytime && isUnderTheSun ? 1.5f : (world.func_201696_r(pos) > 9 ? 0.5f + 0.05f * (float)(world.func_201696_r(pos) - 8) : 0.0f);
            rate = (float)((double)rate * ((double)humidity < 0.2 ? 3.0 : ((double)humidity < 0.7 ? 1.5 : ((double)humidity < 0.9 ? 0.5 : 0.25))));
            rate = (float)((double)rate * ((double)temperature < 0.0 ? 0.0 : ((double)temperature < 0.6 ? 0.5 : ((double)temperature < 1.0 ? 1.0 : 2.5))));
        }
        return rate;
    }

    public Stat getStat(BlockState meta) {
        if (meta.func_177230_c() == this) {
            return (Stat)((Object)meta.func_177229_b(STAT));
        }
        return Stat.NA;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 100;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STAT, LEVEL});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return WHEATBOWL_AABB;
    }

    public static enum Stat implements IStringSerializable
    {
        EMPTY(0, "empty"),
        KOUJIBASE(1, "koujibase"),
        KOUJI(2, "kouji"),
        NA(3, "na");

        private static final Stat[] META_LOOKUP;
        private int meta;
        private String name;

        private Stat(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static Stat byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new Stat[Stat.values().length];
            Stat[] statArray = Stat.values();
            int n = statArray.length;
            for (int i = 0; i < n; ++i) {
                Stat enumtype;
                Stat.META_LOOKUP[enumtype.getMeta()] = enumtype = statArray[i];
            }
        }
    }
}

