/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.entity;

import baguchan.mcmod.tofucraft.entity.TofuFishEntity;
import baguchan.mcmod.tofucraft.entity.TofuSlimeEntity;
import baguchan.mcmod.tofucraft.entity.TofunianEntity;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TofuChingerEntity
extends MonsterEntity {
    private static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(TofuChingerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_EATING = EntityDataManager.func_187226_a(TofuChingerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float clientSideEatAnimation0;
    private float clientSideEatAnimation;
    private int warningSoundTicks;

    public TofuChingerEntity(EntityType<? extends TofuChingerEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TofunianEntity.class, 10, true, false, (Predicate)null));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TofuSlimeEntity.class, 10, true, false, (Predicate)null));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TofuFishEntity.class, 100, true, true, (Predicate)null));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, (double)0.28f).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233818_a_, 16.0);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundEvents.field_191242_bl, 1.0f, this.func_70647_i() * 1.2f);
            this.warningSoundTicks = 40;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_EATING, (Object)false);
        this.field_70180_af.func_187214_a(SIZE, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Size", this.getChingerSize());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        int i = compound.func_74762_e("Size");
        if (i < 0) {
            i = 0;
        } else if (i > 50) {
            i = 50;
        }
        this.setChingerSize(i, false);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SIZE.equals(key)) {
            this.func_213323_x_();
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
        }
        super.func_184206_a(key);
    }

    protected void setChingerSize(int size, boolean resetHealth) {
        this.field_70180_af.func_187227_b(SIZE, (Object)size);
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213323_x_();
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(12.0 + (double)(2.0f * (float)size));
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)(0.25f + 0.005f * (float)size));
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(4.0 + (double)(0.5f * (float)size));
        if (resetHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.field_70728_aV = 3 + size * 2;
    }

    public int getChingerSize() {
        return (Integer)this.field_70180_af.func_187225_a(SIZE);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideEatAnimation != this.clientSideEatAnimation0) {
                this.func_213323_x_();
            }
            this.clientSideEatAnimation0 = this.clientSideEatAnimation;
            this.clientSideEatAnimation = this.isEating() ? MathHelper.func_76131_a((float)(this.clientSideEatAnimation + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientSideEatAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.clientSideEatAnimation > 0.0f) {
            float f = this.clientSideEatAnimation / 6.0f;
            float f1 = 1.0f + 0.2f * (float)this.getChingerSize() + f;
            return super.func_213305_a(poseIn).func_220312_a(1.0f + 0.2f * (float)this.getChingerSize(), f1);
        }
        return super.func_213305_a(poseIn).func_220313_a(1.0f + 0.2f * (float)this.getChingerSize());
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.75f * sizeIn.field_220316_b;
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_EATING);
    }

    public void setEating(boolean standing) {
        this.field_70180_af.func_187227_b(IS_EATING, (Object)standing);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getEatingAnimationScale(float p_189795_1_) {
        return MathHelper.func_219799_g((float)p_189795_1_, (float)this.clientSideEatAnimation0, (float)this.clientSideEatAnimation) / 6.0f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int i = this.field_70146_Z.nextInt(4);
        if (i < 6 && this.field_70146_Z.nextFloat() < 0.5f * difficultyIn.func_180170_c()) {
            ++i;
        }
        this.setChingerSize(i, true);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean spawnHandle(EntityType<TofuChingerEntity> p_223366_0_, IServerWorld p_223366_1_, SpawnReason reason, BlockPos p_223366_3_, Random randomIn) {
        return p_223366_1_.func_201672_e().func_175710_j(p_223366_3_) && TofuChingerEntity.func_223315_a(p_223366_0_, (IWorld)p_223366_1_, (SpawnReason)reason, (BlockPos)p_223366_3_, (Random)randomIn);
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)TofuChingerEntity.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
                TofuChingerEntity.this.setEating(false);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    TofuChingerEntity.this.setEating(false);
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 5) {
                    TofuChingerEntity.this.setEating(true);
                    TofuChingerEntity.this.playWarningSound();
                }
            } else {
                this.func_234039_g_();
                TofuChingerEntity.this.setEating(false);
            }
        }

        public void func_75251_c() {
            TofuChingerEntity.this.setEating(false);
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }
}

