/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.entity;

import baguchan.mcmod.tofucraft.entity.ai.EatZundaGrassGoal;
import baguchan.mcmod.tofucraft.init.TofuBiomes;
import baguchan.mcmod.tofucraft.init.TofuBlocks;
import baguchan.mcmod.tofucraft.init.TofuEntitys;
import baguchan.mcmod.tofucraft.init.TofuFluids;
import baguchan.mcmod.tofucraft.init.TofuItems;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.items.ItemHandlerHelper;

public class TofuCowEntity
extends CowEntity {
    private static final DataParameter<String> TOFUCOW_TYPE = EntityDataManager.func_187226_a(TofuCowEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O, TofuItems.LEEK});
    private int grassEatTimer;
    private int eatDelayTimer;
    private EatZundaGrassGoal eatGrassGoal;

    public TofuCowEntity(EntityType<? extends TofuCowEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.eatGrassGoal = new EatZundaGrassGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, BREEDING_ITEMS, false));
        this.field_70714_bg.func_75776_a(4, (Goal)this.eatGrassGoal);
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TOFUCOW_TYPE, (Object)Type.NONE.name);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("Type", this.getTofuCowType().name);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setTofuCowType(Type.getTypeByName(compound.func_74779_i("Type")));
    }

    protected void func_70619_bc() {
        this.grassEatTimer = this.eatGrassGoal.getEatingGrassTimer();
        super.func_70619_bc();
        if (this.eatDelayTimer > 0) {
            --this.eatDelayTimer;
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.grassEatTimer = Math.max(0, this.grassEatTimer - 1);
        }
        this.func_82168_bl();
        super.func_70636_d();
    }

    public int getEatDelayTimer() {
        return this.eatDelayTimer;
    }

    public void setEatDelayTimer(int eatDelayTimer) {
        this.eatDelayTimer = eatDelayTimer;
    }

    public void func_70615_aA() {
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
        this.func_195064_c(new EffectInstance(Effects.field_76428_l, 60, 0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.grassEatTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.grassEatTimer <= 0) {
            return 0.0f;
        }
        if (this.grassEatTimer >= 4 && this.grassEatTimer <= 36) {
            return 1.0f;
        }
        return this.grassEatTimer < 4 ? ((float)this.grassEatTimer - p_70894_1_) / 4.0f : -((float)(this.grassEatTimer - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.grassEatTimer > 4 && this.grassEatTimer <= 36) {
            float f = ((float)(this.grassEatTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.grassEatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        IFluidHandlerItem handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)itemstack, (int)1)).orElse(null);
        if (handler instanceof FluidBucketWrapper && !player.func_184812_l_() && !this.func_70631_g_()) {
            FluidBucketWrapper fluidBucketWrapper = (FluidBucketWrapper)handler;
            if (this.getTofuCowType() == Type.ZUNDA) {
                FluidStack fluidStack = new FluidStack((Fluid)TofuFluids.SOYMILK, 1000);
                player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                itemstack.func_190918_g(1);
                fluidBucketWrapper.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                if (itemstack.func_190926_b()) {
                    player.func_184611_a(hand, fluidBucketWrapper.getContainer());
                } else if (!player.field_71071_by.func_70441_a(fluidBucketWrapper.getContainer())) {
                    player.func_71019_a(fluidBucketWrapper.getContainer(), false);
                }
                return ActionResultType.SUCCESS;
            }
            FluidStack fluidStack = new FluidStack((Fluid)TofuFluids.SOYMILK, 1000);
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            fluidBucketWrapper.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, fluidBucketWrapper.getContainer());
            } else if (!player.field_71071_by.func_70441_a(fluidBucketWrapper.getContainer())) {
                player.func_71019_a(fluidBucketWrapper.getContainer(), false);
            }
            return ActionResultType.SUCCESS;
        }
        if (itemstack.func_77973_b() == Items.field_151069_bo && !player.field_71075_bZ.field_75098_d && !this.func_70631_g_()) {
            if (this.getTofuCowType() == Type.ZUNDA) {
                player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack((IItemProvider)TofuItems.SOYMILK_ZUNDA_BOTTLE));
                } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)TofuItems.SOYMILK_BOTTLE))) {
                    player.func_71019_a(new ItemStack((IItemProvider)TofuItems.SOYMILK_ZUNDA_BOTTLE), false);
                }
                return ActionResultType.SUCCESS;
            }
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack((IItemProvider)TofuItems.SOYMILK_BOTTLE));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)TofuItems.SOYMILK_BOTTLE))) {
                player.func_71019_a(new ItemStack((IItemProvider)TofuItems.SOYMILK_BOTTLE), false);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    private void setTofuCowType(Type typeIn) {
        this.field_70180_af.func_187227_b(TOFUCOW_TYPE, (Object)typeIn.name);
    }

    public Type getTofuCowType() {
        return Type.getTypeByName((String)this.field_70180_af.func_187225_a(TofuCowEntity.TOFUCOW_TYPE));
    }

    public CowEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        TofuCowEntity mooshroomentity = (TofuCowEntity)TofuEntitys.TOFUCOW.func_200721_a((World)serverWorld);
        mooshroomentity.setTofuCowType(this.func_213445_a((TofuCowEntity)ageable));
        return mooshroomentity;
    }

    private Type func_213445_a(TofuCowEntity p_213445_1_) {
        Type mooshroomentity$type = this.getTofuCowType();
        Type mooshroomentity$type1 = p_213445_1_.getTofuCowType();
        Type mooshroomentity$type2 = this.field_70146_Z.nextBoolean() ? mooshroomentity$type : mooshroomentity$type1;
        return mooshroomentity$type2;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (Objects.equals(this.field_70170_p.func_242406_i(this.func_233580_cy_()), Optional.of(TofuBiomes.ZUNDA_TOFU_FUNGI_FOREST)) || Objects.equals(this.field_70170_p.func_242406_i(this.func_233580_cy_()), Optional.of(TofuBiomes.ZUNDA_TOFU_PLAIN))) {
            if (worldIn.func_201674_k().nextInt(8) == 0) {
                this.setTofuCowType(Type.NONE);
            } else {
                this.setTofuCowType(Type.ZUNDA);
            }
        } else if (worldIn.func_201674_k().nextInt(8) == 0) {
            this.setTofuCowType(Type.LEEK);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.6f : 1.3f;
    }

    public static enum Type {
        NONE("none", Blocks.field_150350_a.func_176223_P()),
        LEEK("leek", TofuBlocks.LEEK.func_176223_P()),
        ZUNDA("zunda", Blocks.field_150350_a.func_176223_P());

        private final String name;
        private final BlockState renderState;

        private Type(String nameIn, BlockState renderStateIn) {
            this.name = nameIn;
            this.renderState = renderStateIn;
        }

        @OnlyIn(value=Dist.CLIENT)
        public BlockState getRenderState() {
            return this.renderState;
        }

        private static Type getTypeByName(String nameIn) {
            for (Type mooshroomentity$type : Type.values()) {
                if (!mooshroomentity$type.name.equals(nameIn)) continue;
                return mooshroomentity$type;
            }
            return LEEK;
        }
    }
}

