/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.entity;

import baguchan.mcmod.tofucraft.entity.ai.GandlemRangedAttackGoal;
import baguchan.mcmod.tofucraft.entity.ai.HealSpellGoal;
import baguchan.mcmod.tofucraft.entity.ai.SoyshotGoal;
import baguchan.mcmod.tofucraft.entity.ai.TofuBombGoal;
import baguchan.mcmod.tofucraft.entity.movement.FlyingStrafeMovementController;
import baguchan.mcmod.tofucraft.entity.projectile.BeamEntity;
import baguchan.mcmod.tofucraft.entity.projectile.FukumameEntity;
import baguchan.mcmod.tofucraft.event.TofuWorldEvents;
import baguchan.mcmod.tofucraft.init.TofuCreatureAttribute;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;

public class TofuGandlemEntity
extends MonsterEntity
implements IRangedAttackMob {
    private static final DataParameter<Boolean> SLEEP = EntityDataManager.func_187226_a(TofuGandlemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CASTING = EntityDataManager.func_187226_a(TofuGandlemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SHOOTING = EntityDataManager.func_187226_a(TofuGandlemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;
    private float prevClientSideChargeForceAnimation;
    private float clientSideChargeForceAnimation;
    private float prevClientSideShootingAnimation;
    private float clientSideShootingAnimation;
    private float prevClientSideDeathAnimation;
    private float clientSideDeathAnimation;
    public int deathTicks;
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);

    public TofuGandlemEntity(EntityType<? extends TofuGandlemEntity> type, World p_i48553_2_) {
        super(type, p_i48553_2_);
        this.field_70765_h = new FlyingStrafeMovementController((MobEntity)this, 15, false);
        this.field_70728_aV = 100;
        this.bossInfo.func_186758_d(false);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SLEEP, (Object)false);
        this.field_70180_af.func_187214_a(CASTING, (Object)false);
        this.field_70180_af.func_187214_a(SHOOTING, (Object)false);
    }

    public boolean isSleep() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEP);
    }

    public void setSleep(boolean isSleep) {
        this.field_70180_af.func_187227_b(SLEEP, (Object)isSleep);
    }

    public boolean isCasting() {
        return (Boolean)this.field_70180_af.func_187225_a(CASTING);
    }

    public void setCasting(boolean isCasting) {
        this.field_70180_af.func_187227_b(CASTING, (Object)isCasting);
    }

    public void setShooting(boolean shooting) {
        this.field_70180_af.func_187227_b(SHOOTING, (Object)shooting);
    }

    public boolean isShooting() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOOTING);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new DoNothingGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new TofuBombGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new SoyshotGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HealSpellGoal(this));
        this.field_70714_bg.func_75776_a(6, new GandlemRangedAttackGoal<TofuGandlemEntity>(this, 0.95, 65, 18.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 0.95));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractIllagerEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, (double)0.26f).func_233815_a_(Attributes.field_233822_e_, 0.6).func_233815_a_(Attributes.field_233818_a_, 400.0).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233824_g_, (double)1.4f).func_233815_a_(Attributes.field_233826_i_, 8.0).func_233815_a_(Attributes.field_233827_j_, 1.0);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Sleep", this.isSleep());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSleep(compound.func_74767_n("Sleep"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        if (!this.isSleep()) {
            --this.heightOffsetUpdateTime;
            if (this.heightOffsetUpdateTime <= 0) {
                this.heightOffsetUpdateTime = 100;
                this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
            }
            LivingEntity target = this.func_70638_az();
            Vector3d vec3d = this.func_213322_ci();
            if (target != null && target.func_70089_S() && target.func_226278_cu_() + (double)target.func_70047_e() > this.func_226278_cu_() + (double)this.func_70047_e() + (double)this.heightOffset && this.func_70089_S()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, ((double)0.3f - vec3d.field_72448_b) * (double)0.3f, 0.0));
                this.field_70160_al = true;
            }
            if (!this.field_70122_E && vec3d.field_72448_b < 0.0 && this.func_70089_S()) {
                this.func_213317_d(vec3d.func_216372_d(1.0, 0.6, 1.0));
            }
            if (!this.bossInfo.func_201359_g()) {
                this.bossInfo.func_186758_d(true);
            }
            super.func_70619_bc();
        } else {
            if (this.bossInfo.func_201359_g()) {
                this.bossInfo.func_186758_d(false);
            }
            if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && !this.isSleep()) {
                this.setSleep(true);
            }
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks >= 110 && this.deathTicks <= 120) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_() + (double)f, this.func_226278_cu_() + 2.0 + (double)f1, this.func_226281_cx_() + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.deathTicks >= 120) {
            super.func_70609_aI();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.prevClientSideChargeForceAnimation = this.clientSideChargeForceAnimation;
            this.clientSideChargeForceAnimation = this.isCasting() ? MathHelper.func_76131_a((float)(this.clientSideChargeForceAnimation + 0.5f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientSideChargeForceAnimation - 1.0f), (float)0.0f, (float)6.0f);
            this.prevClientSideShootingAnimation = this.clientSideShootingAnimation;
            this.clientSideShootingAnimation = this.isShooting() ? MathHelper.func_76131_a((float)(this.clientSideShootingAnimation + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientSideShootingAnimation - 1.0f), (float)0.0f, (float)6.0f);
            this.prevClientSideDeathAnimation = this.clientSideDeathAnimation;
            this.clientSideDeathAnimation = !this.func_70089_S() ? MathHelper.func_76131_a((float)(this.clientSideDeathAnimation + 0.05f), (float)0.0f, (float)1.0f) : 0.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getChargeForceAnimationScale(float p_189795_1_) {
        return (this.prevClientSideChargeForceAnimation + (this.clientSideChargeForceAnimation - this.prevClientSideChargeForceAnimation) * p_189795_1_) / 6.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShootingAnimationScale(float p_189795_1_) {
        return (this.prevClientSideShootingAnimation + (this.clientSideShootingAnimation - this.prevClientSideShootingAnimation) * p_189795_1_) / 6.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getDeathAnimationScale(float p_189795_1_) {
        return this.prevClientSideDeathAnimation + (this.clientSideDeathAnimation - this.prevClientSideDeathAnimation) * p_189795_1_;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        this.func_184185_a(SoundEvents.field_187721_dT, 1.5f, 1.0f);
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.isSleep() && source.func_76346_g() instanceof LivingEntity) {
            if (this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
                this.func_184185_a(SoundEvents.field_187855_gD, 2.0f, 1.0f);
                this.setSleep(false);
            }
            return false;
        }
        if (this.isSleep()) {
            return false;
        }
        if (source.func_76364_f() instanceof FukumameEntity) {
            return false;
        }
        if (source.func_76352_a()) {
            return super.func_70097_a(source, amount * 0.75f);
        }
        if (source.func_94541_c() || source.func_76347_k()) {
            return super.func_70097_a(source, amount * 0.5f);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        TofuWorldEvents.onTofuGandlemBeaten(this, cause);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76436_u || potioneffectIn.func_188419_a() == Effects.field_82731_v) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public void func_82196_d(LivingEntity livingEntity, float v) {
        this.func_184185_a(SoundEvents.field_187606_E, 1.2f, 1.0f);
        double d1 = livingEntity.func_226277_ct_() - this.func_226277_ct_();
        double d2 = livingEntity.func_174813_aQ().field_72338_b + (double)(livingEntity.func_213302_cg() / 2.0f) - (this.func_226278_cu_() + (double)this.func_70047_e());
        double d3 = livingEntity.func_226281_cx_() - this.func_226281_cx_();
        float f = 0.075f;
        BeamEntity smallfireballentity = new BeamEntity(this.field_70170_p, (LivingEntity)this, d1 + this.func_70681_au().nextGaussian() * (double)f - this.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.func_70681_au().nextGaussian() * (double)f - this.func_70681_au().nextGaussian() * (double)f);
        smallfireballentity.func_70107_b(smallfireballentity.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), smallfireballentity.func_226281_cx_());
        smallfireballentity.explosionPower = 1.0f;
        this.field_70170_p.func_217376_c((Entity)smallfireballentity);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == TofuCreatureAttribute.TOFUGUARIAN) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return TofuCreatureAttribute.TOFUGUARIAN;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected boolean func_225511_J_() {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return TofuGandlemEntity.this.isSleep();
        }
    }
}

