/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.entity;

import baguchan.mcmod.tofucraft.init.TofuBiomes;
import baguchan.mcmod.tofucraft.init.TofuDimensions;
import baguchan.mcmod.tofucraft.init.TofuItems;
import baguchan.mcmod.tofucraft.init.TofuLootTables;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTables;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class TofuSlimeEntity
extends SlimeEntity {
    private static final DataParameter<Boolean> WEAK = EntityDataManager.func_187226_a(TofuSlimeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public TofuSlimeEntity(EntityType<? extends TofuSlimeEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(WEAK, (Object)false);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (!this.isWeak() && Objects.equals(this.field_70170_p.func_242406_i(this.func_233580_cy_()), Optional.of(TofuBiomes.ZUNDA_TOFU_FUNGI_FOREST))) {
                this.setWeak(true);
            } else if (this.isWeak() && !Objects.equals(this.field_70170_p.func_242406_i(this.func_233580_cy_()), Optional.of(TofuBiomes.ZUNDA_TOFU_FUNGI_FOREST))) {
                this.setWeak(false);
            }
        }
        super.func_70071_h_();
    }

    public void func_70636_d() {
        boolean flag;
        if (this.func_70089_S() && (flag = this.isWeak())) {
            if (this.field_70173_aa % 100 == 0) {
                this.func_70097_a(DamageSource.field_76366_f, 2.0f);
            }
            if (this.func_70660_b(Effects.field_76437_t) == null) {
                this.func_195064_c(new EffectInstance(Effects.field_76437_t, 100));
            }
        }
        super.func_70636_d();
    }

    public boolean isWeak() {
        return (Boolean)this.func_184212_Q().func_187225_a(WEAK);
    }

    public void setWeak(boolean weak) {
        this.func_184212_Q().func_187227_b(WEAK, (Object)weak);
    }

    protected ResourceLocation func_184647_J() {
        if (this.isWeak()) {
            return this.func_70809_q() == 1 ? TofuLootTables.weak_tofuslime : LootTables.field_186419_a;
        }
        return this.func_70809_q() == 1 ? this.func_200600_R().func_220348_g() : LootTables.field_186419_a;
    }

    public static boolean spawnHandle(EntityType<TofuSlimeEntity> entityType, IServerWorld world, SpawnReason reason, BlockPos pos, Random randomIn) {
        if (world.func_175659_aa() != Difficulty.PEACEFUL) {
            boolean flag;
            Biome biome = world.func_226691_t_(pos);
            if (world.func_201672_e().func_234923_W_() == TofuDimensions.tofu_world && randomIn.nextInt(20) == 0 && world.func_201696_r(pos) <= randomIn.nextInt(8)) {
                return TofuSlimeEntity.func_223315_a(entityType, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
            }
            if (!(world instanceof ISeedReader)) {
                return false;
            }
            ChunkPos chunkpos = new ChunkPos(pos);
            boolean bl = flag = SharedSeedRandom.func_205190_a((int)chunkpos.field_77276_a, (int)chunkpos.field_77275_b, (long)((ISeedReader)world).func_72905_C(), (long)987234911L).nextInt(10) == 0;
            if (randomIn.nextInt(10) == 0 && flag && pos.func_177956_o() < 40) {
                return TofuSlimeEntity.func_223315_a(entityType, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
            }
        }
        return false;
    }

    public static boolean isSpawnChunk(World world, BlockPos pos) {
        ChunkPos chunkpos = new ChunkPos(pos);
        boolean flag = SharedSeedRandom.func_205190_a((int)chunkpos.field_77276_a, (int)chunkpos.field_77275_b, (long)((ISeedReader)world).func_72905_C(), (long)987234911L).nextInt(10) == 0;
        return flag;
    }

    protected IParticleData func_195404_m() {
        return new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)TofuItems.TOFUKINU));
    }
}

