/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.entity;

import baguchan.mcmod.tofucraft.entity.TofuChingerEntity;
import baguchan.mcmod.tofucraft.entity.ZombieTofunianEntity;
import baguchan.mcmod.tofucraft.entity.ai.CookingTofuGoal;
import baguchan.mcmod.tofucraft.entity.ai.CropHarvestGoal;
import baguchan.mcmod.tofucraft.entity.ai.EatOffhandFoodGoal;
import baguchan.mcmod.tofucraft.entity.ai.InterestJobBlockGoal;
import baguchan.mcmod.tofucraft.entity.ai.LookAndPassGoal;
import baguchan.mcmod.tofucraft.entity.ai.RestockTradeGoal;
import baguchan.mcmod.tofucraft.entity.ai.SleepOnBedGoal;
import baguchan.mcmod.tofucraft.entity.ai.TofunianLoveGoal;
import baguchan.mcmod.tofucraft.entity.ai.WakeUpGoal;
import baguchan.mcmod.tofucraft.init.TofuBlocks;
import baguchan.mcmod.tofucraft.init.TofuCriterias;
import baguchan.mcmod.tofucraft.init.TofuDamageSource;
import baguchan.mcmod.tofucraft.init.TofuEntitys;
import baguchan.mcmod.tofucraft.init.TofuItems;
import baguchan.mcmod.tofucraft.init.TofuSounds;
import baguchan.mcmod.tofucraft.utils.WorldUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.GossipManager;
import net.minecraft.village.GossipType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.common.util.ITeleporter;

public class TofunianEntity
extends AbstractVillagerEntity
implements IReputationTracking {
    private static final DataParameter<String> ROLE = EntityDataManager.func_187226_a(TofunianEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Byte> TOFUNIAN_FLAGS = EntityDataManager.func_187226_a(TofunianEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final Set<Item> SEED = ImmutableSet.of((Object)TofuItems.SEEDS_SOYBEAN);
    private static final Set<Item> FOOD = ImmutableSet.of((Object)TofuItems.TOFUGRILD, (Object)TofuItems.TOFUCOOKIE, (Object)TofuItems.TOFUMOMEN, (Object)TofuItems.HIYAYAKKO);
    private static final Map<Item, Integer> field_213788_bA = ImmutableMap.of((Object)TofuItems.HIYAYAKKO, (Object)2, (Object)TofuItems.TOFUGRILD, (Object)2, (Object)TofuItems.TOFUCOOKIE, (Object)3, (Object)TofuItems.TOFUMOMEN, (Object)1);
    private static final Map<Item, Integer> canCookItems = ImmutableMap.of((Object)TofuItems.SEEDS_SOYBEAN, (Object)2, (Object)TofuItems.TOFUMOMEN, (Object)1);
    public static final List<Item> cookedItem = Lists.newArrayList((Object[])new Item[]{TofuItems.TOFUGRILD, TofuItems.HIYAYAKKO});
    private int inLove;
    private boolean customer;
    private int tofunianCareerLevel = 1;
    private int xp;
    @Nullable
    private PlayerEntity previousCustomer;
    @Nullable
    private BlockPos tofunainHome;
    @Nullable
    private BlockPos tofunainJobBlock;
    private final GossipManager gossip = new GossipManager();
    public static int MAX_HOME_DISTANCE_SQ = 3600;
    private long lastGossipDecay;
    public static Predicate<Entity> ENEMY_PREDICATE = input -> input instanceof ZombieEntity || input instanceof AbstractIllagerEntity || input instanceof VexEntity || input instanceof TofuChingerEntity;
    private int timeUntilReset;

    public Int2ObjectMap<VillagerTrades.ITrade[]> getOfferMap() {
        Int2ObjectMap<VillagerTrades.ITrade[]> offers = null;
        if (this.getRole() == Roles.TOFUCOOK) {
            offers = TofunianEntity.func_221238_a((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new TradeForZundaRuby((IItemProvider)TofuItems.TOFUKINU, 20, 8, 1), new TradeForZundaRuby((IItemProvider)TofuItems.SEEDS_SOYBEAN, 28, 8, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new TradeForItem((IItemProvider)TofuBlocks.ISHITOFU_BRICK, 12, 4, 12), new TradeForItem((IItemProvider)TofuItems.TOFUCOOKIE, 9, 6, 10), new TradeForItem((IItemProvider)TofuItems.TOFUGRILD, 8, 6, 10)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new TradeForZundaRuby((IItemProvider)TofuItems.EDAMAME, 26, 6, 14), new TradeForItem((IItemProvider)TofuItems.TTTBURGER, 6, 6, 16)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new TradeForZundaRuby((IItemProvider)TofuItems.SALT, 24, 4, 20), new TradeForZundaRuby((IItemProvider)TofuItems.SOYSAUCE, 1, 4, 20), new TradeForItem((IItemProvider)TofuItems.TOFUHAMBURG, 8, 6, 22)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new TradeForHicostItem((IItemProvider)TofuItems.TOFUHOE, 4, 4, 30, 0.075f)}));
        } else if (this.getRole() == Roles.TOFUSMITH) {
            offers = TofunianEntity.func_221238_a((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new TradeForZundaRuby((IItemProvider)TofuItems.TOFUISHI, 26, 7, 2), new TradeForItem((IItemProvider)TofuItems.ARMOR_SOLIDHELMET, 1, 3, 3)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new TradeForZundaRuby((IItemProvider)TofuItems.TOFUMETAL, 4, 7, 8), new TradeForHicostItem((IItemProvider)TofuItems.ARMOR_METALBOOTS, 4, 3, 14)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new TradeForHicostItem((IItemProvider)TofuItems.METALSWORD, 5, 3, 16, 0.075f), new TradeForHicostItem((IItemProvider)TofuItems.METALSHOVEL, 4, 3, 16, 0.075f), new TradeForHicostItem((IItemProvider)TofuItems.METALPICKAXE, 6, 3, 16, 0.075f)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new TradeForHicostItem((IItemProvider)TofuItems.TOFUSTICK, 4, 2, 30)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new TradeForHicostItem((IItemProvider)TofuItems.TOFUDIAMONDSWORD, 16, 1, 30, 0.1f), new TradeForHicostItem((IItemProvider)TofuItems.TOFUDIAMONDAXE, 18, 1, 30, 0.1f), new TradeForHicostItem((IItemProvider)TofuItems.TOFUDIAMONDPICKAXE, 17, 1, 30, 0.1f), new TradeForHicostItem((IItemProvider)TofuItems.TOFUDIAMONDSHOVEL, 15, 1, 30, 0.1f), new TradeForHicostItem((IItemProvider)TofuItems.ARMOR_DIAMONDHELMET, 15, 1, 30, 0.1f), new TradeForHicostItem((IItemProvider)TofuItems.ARMOR_DIAMONDBOOTS, 15, 1, 30, 0.1f), new TradeForHicostItem((IItemProvider)TofuItems.ARMOR_DIAMONDCHESTPLATE, 21, 1, 30, 0.1f), new TradeForHicostItem((IItemProvider)TofuItems.ARMOR_DIAMONDLEGGINS, 19, 1, 30, 0.1f)}));
        } else if (this.getRole() == Roles.SOYWORKER) {
            offers = TofunianEntity.func_221238_a((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new TradeForZundaRuby((IItemProvider)Items.field_151069_bo, 6, 8, 2), new TradeForItem((IItemProvider)TofuItems.SOYMILK_BOTTLE, 1, 3, 4)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new TradeForZundaRuby((IItemProvider)TofuItems.SEEDS_SOYBEAN, 28, 6, 8), new TradeForHicostItem((IItemProvider)TofuItems.SOYMILK_COCOA_BOTTLE, 2, 3, 14), new TradeForHicostItem((IItemProvider)TofuItems.SOYMILK_KINAKO_BOTTLE, 2, 3, 14)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new TradeForHicostItem((IItemProvider)TofuItems.SOYMILK_RAMUNE_BOTTLE, 2, 3, 16), new TradeForHicostItem((IItemProvider)TofuItems.SOYMILK_STRAWBERRY_BOTTLE, 2, 3, 16), new TradeForHicostItem((IItemProvider)TofuItems.SOYMILK_ZUNDA_BOTTLE, 2, 3, 16)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new TradeForZundaRuby((IItemProvider)Item.func_150898_a((Block)TofuBlocks.TOFUBERRY), 12, 8, 26), new TradeForHicostItem((IItemProvider)TofuItems.SOYMILK_PUDDING_BOTTLE, 4, 2, 28)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new TradeForHicostItem((IItemProvider)TofuItems.BREWED_SOYMILK_ANNIN_BOTTLE, 4, 3, 30), new TradeForHicostItem((IItemProvider)TofuItems.BREWED_SOYMILK_APPLE_BOTTLE, 4, 3, 30)}));
        }
        return offers;
    }

    public TofunianEntity(EntityType<? extends TofunianEntity> p_i50182_1_, World p_i50182_2_) {
        super(p_i50182_1_, p_i50182_2_);
        this.func_98053_h(true);
    }

    private static Int2ObjectMap<VillagerTrades.ITrade[]> func_221238_a(ImmutableMap<Integer, VillagerTrades.ITrade[]> p_221238_0_) {
        return new Int2ObjectOpenHashMap(p_221238_0_);
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] avillagertrades$itrade;
        Int2ObjectMap<VillagerTrades.ITrade[]> int2objectmap = this.getOfferMap();
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades$itrade = (VillagerTrades.ITrade[])int2objectmap.get(this.getLevel())) != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, avillagertrades$itrade, 2);
        }
    }

    protected void func_213713_b(MerchantOffer offer) {
        int i = 3 + this.field_70146_Z.nextInt(4);
        this.xp += offer.func_222210_n();
        this.previousCustomer = this.func_70931_l_();
        if (this.func_213741_eu()) {
            this.timeUntilReset = 40;
            this.customer = true;
            i += 5;
        }
        if (offer.func_222221_q()) {
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    private void populateBuyingList() {
        this.setLevel(this.tofunianCareerLevel + 1);
        this.func_213712_ef();
    }

    public void restock() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222203_h();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("InLove", this.inLove);
        compound.func_74768_a("Level", this.getLevel());
        compound.func_74768_a("Xp", this.xp);
        compound.func_74778_a("Role", this.getRole().name());
        compound.func_218657_a("Gossips", (INBT)this.gossip.func_234058_a_((DynamicOps)NBTDynamicOps.field_210820_a).getValue());
        compound.func_74772_a("LastGossipDecay", this.lastGossipDecay);
        if (this.tofunainHome != null) {
            compound.func_218657_a("TofunianHome", (INBT)NBTUtil.func_186859_a((BlockPos)this.tofunainHome));
        }
        if (this.tofunainJobBlock != null) {
            compound.func_218657_a("TofunianJobBlock", (INBT)NBTUtil.func_186859_a((BlockPos)this.tofunainJobBlock));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.inLove = compound.func_74762_e("InLove");
        this.setLevel(compound.func_74762_e("Level"));
        if (compound.func_150297_b("Xp", 3)) {
            this.xp = compound.func_74762_e("Xp");
        }
        if (compound.func_74764_b("Role")) {
            this.setRole(Roles.get(compound.func_74779_i("Role")));
        }
        ListNBT listnbt = compound.func_150295_c("Gossips", 10);
        this.gossip.func_234057_a_(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)listnbt));
        if (compound.func_74764_b("TofunianHome")) {
            this.tofunainHome = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("TofunianHome"));
        }
        if (compound.func_74764_b("TofunianJobBlock")) {
            this.tofunainJobBlock = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("TofunianJobBlock"));
        }
        this.lastGossipDecay = compound.func_74763_f("LastGossipDecay");
        this.func_98053_h(true);
    }

    public void setTofunainHome(@Nullable BlockPos pos) {
        this.tofunainHome = pos;
    }

    @Nullable
    public BlockPos getTofunainHome() {
        return this.tofunainHome;
    }

    public void setTofunainJobBlock(@Nullable BlockPos pos) {
        this.tofunainJobBlock = pos;
    }

    @Nullable
    public BlockPos getTofunainJobBlock() {
        return this.tofunainJobBlock;
    }

    private boolean func_213741_eu() {
        int i = this.getLevel();
        return VillagerData.func_221128_d((int)i) && this.xp >= VillagerData.func_221127_c((int)i);
    }

    public int func_213708_dV() {
        return this.xp;
    }

    public void setXp(int p_213761_1_) {
        this.xp = p_213761_1_;
    }

    public void setOffers(MerchantOffers offersIn) {
        this.field_213724_bz = offersIn;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ROLE, (Object)Roles.TOFUNIAN.name());
        this.field_70180_af.func_187214_a(TOFUNIAN_FLAGS, (Object)0);
    }

    private boolean getTofunianFlag(int flagId) {
        return ((Byte)this.field_70180_af.func_187225_a(TOFUNIAN_FLAGS) & flagId) != 0;
    }

    private void setTofunianFlag(int flagId, boolean flag) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(TOFUNIAN_FLAGS);
        if (flag) {
            this.field_70180_af.func_187227_b(TOFUNIAN_FLAGS, (Object)((byte)(b0 | flagId)));
        } else {
            this.field_70180_af.func_187227_b(TOFUNIAN_FLAGS, (Object)((byte)(b0 & ~flagId)));
        }
    }

    public boolean isWorking() {
        return this.getTofunianFlag(2);
    }

    public void setWorking(boolean sitting) {
        this.setTofunianFlag(2, sitting);
    }

    public void setLevel(int level) {
        this.tofunianCareerLevel = level;
    }

    public int getLevel() {
        return this.tofunianCareerLevel;
    }

    public void setRole(Roles role) {
        this.func_184212_Q().func_187227_b(ROLE, (Object)role.name());
    }

    public Roles getRole() {
        return Roles.get((String)this.func_184212_Q().func_187225_a(ROLE));
    }

    public boolean canFarm() {
        return this.getRole() == Roles.TOFUCOOK;
    }

    public boolean canSmith() {
        return this.getRole() == Roles.TOFUSMITH;
    }

    public boolean isNitwit() {
        return this.getRole() == Roles.TOFUNIAN;
    }

    protected void func_213750_eg() {
        super.func_213750_eg();
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222220_k();
        }
    }

    public boolean isStockOut() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            if (!merchantoffer.func_222217_o()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Entity changeDimension(ServerWorld server, ITeleporter teleporter) {
        this.setTofunainJobBlock(null);
        this.setTofunainHome(null);
        return super.changeDimension(server, teleporter);
    }

    protected void func_70619_bc() {
        if (!this.func_213716_dX() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.customer) {
                    this.populateBuyingList();
                    this.customer = false;
                }
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
            }
        }
        if (this.isNitwit() && this.func_213716_dX()) {
            this.func_213750_eg();
        }
        if (this.previousCustomer != null && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217489_a(IReputationType.field_221033_e, (Entity)this.previousCustomer, (IReputationTracking)this);
            this.field_70170_p.func_72960_a((Entity)this, (byte)14);
            this.previousCustomer = null;
        }
        if (this.func_70874_b() != 0) {
            this.inLove = 0;
        }
        this.findHome(false);
        this.findJobSpace();
        super.func_70619_bc();
    }

    private void findJobSpace() {
        BlockState state;
        if ((this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 600L != 0L) {
            return;
        }
        if (this.tofunainJobBlock != null && (state = this.field_70170_p.func_180495_p(this.tofunainJobBlock)).func_177230_c() != Blocks.field_150462_ai && !(state.func_177230_c() instanceof AbstractFurnaceBlock) && !(state.func_177230_c() instanceof CauldronBlock)) {
            this.tofunainJobBlock = null;
            if (this.xp != 0 || this.getLevel() == 1) {
                this.setRole(Roles.TOFUNIAN);
            }
        }
    }

    private void findHome(boolean force) {
        if (!force && (this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 600L != 0L) {
            return;
        }
        boolean tryFind = false;
        if (this.tofunainHome == null) {
            tryFind = true;
        } else if (this.tofunainHome != null) {
            BlockState state = this.field_70170_p.func_180495_p(this.tofunainHome);
            if (this.func_70092_e(this.tofunainHome.func_177958_n(), this.tofunainHome.func_177956_o(), this.tofunainHome.func_177952_p()) > (double)MAX_HOME_DISTANCE_SQ) {
                this.tofunainHome = null;
                tryFind = true;
            } else if (!state.func_177230_c().func_203417_a((ITag)BlockTags.field_219747_F)) {
                this.tofunainHome = null;
                tryFind = true;
            }
        }
        if (tryFind) {
            int range = 15;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range / 2; y <= range / 2; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos pos = new BlockPos(this.func_213303_ch()).func_177982_a(x, y, z);
                        BlockState state = this.field_70170_p.func_180495_p(pos);
                        if (!state.func_177230_c().func_203417_a((ITag)BlockTags.field_219747_F)) continue;
                        this.setTofunainHome(pos);
                        return;
                    }
                }
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new WakeUpGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new DoSleepingGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25){

            public boolean func_75250_a() {
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(2, new EatOffhandFoodGoal<TofunianEntity>(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new SleepOnBedGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new TofunianLoveGoal(this, 0.85));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveToJobGoal(this, 8.0, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new MoveToHomeGoal(this, 45.0, 1.1));
        this.field_70714_bg.func_75776_a(7, (Goal)new InterestJobBlockGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new RestockTradeGoal(this, 1.05));
        this.field_70714_bg.func_75776_a(8, (Goal)new CookingTofuGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new CropHarvestGoal(this, 0.95));
        this.field_70714_bg.func_75776_a(9, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.9));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAndPassGoal(this, TofunianEntity.class, 4.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, ZombieEntity.class, 8.0f, 1.2, 1.25));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, AbstractIllagerEntity.class, 8.0f, 1.25, 1.25));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, VexEntity.class, 8.0f, 1.2, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, TofuChingerEntity.class, 8.0f, 1.2, 1.2));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, 10, true, false, ENEMY_PREDICATE));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233814_a_(Attributes.field_233823_f_).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    private void updateEntityEquipment() {
    }

    public void updateTofunianState() {
        this.updateEntityEquipment();
    }

    protected void func_175500_n() {
        super.func_175500_n();
        this.updateTofunianState();
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
            }
        }
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_213719_ec() > 0) {
            this.func_213720_r(this.func_213719_ec() - 1);
        }
        this.tickGossip();
    }

    private void tickGossip() {
        long i = this.field_70170_p.func_82737_E();
        if (this.lastGossipDecay == 0L) {
            this.lastGossipDecay = i;
        } else if (i >= this.lastGossipDecay + 24000L) {
            this.gossip.func_223538_b();
            this.lastGossipDecay = i;
        }
    }

    private void shakeHead() {
        this.func_213720_r(40);
        if (!this.field_70170_p.func_201670_d()) {
            this.func_184185_a(TofuSounds.TOFUNIAN_NO, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void setInLove(int inLove) {
        this.inLove = inLove;
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        Item item = itemstack.func_77973_b();
        if (this.isTofuniansFood(item) || this.isSeed(item)) {
            Inventory inventory = this.func_213715_ed();
            boolean flag = false;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack1 = inventory.func_70301_a(i);
                if (!itemstack1.func_190926_b() && (itemstack1.func_77973_b() != item || itemstack1.func_190916_E() >= itemstack1.func_77976_d())) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return;
            }
            int j = inventory.func_213901_a(item);
            if (j == 256) {
                return;
            }
            if (j > 256) {
                inventory.func_223374_a(item, j - 256);
                return;
            }
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            ItemStack itemstack2 = inventory.func_174894_a(itemstack);
            if (itemstack2.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack2.func_190916_E());
            }
        }
    }

    public boolean isSeed(Item p_223717_1_) {
        return SEED.contains(p_223717_1_);
    }

    public boolean isTofuniansFood(Item p_223717_1_) {
        return FOOD.contains(p_223717_1_);
    }

    public boolean canAbondonItems() {
        return this.func_213751_ew() >= 42;
    }

    public boolean wantsMoreFood() {
        return this.func_213751_ew() < 42;
    }

    private int func_213751_ew() {
        Inventory inventory = this.func_213715_ed();
        return field_213788_bA.entrySet().stream().mapToInt(p_213764_1_ -> inventory.func_213901_a((Item)p_213764_1_.getKey()) * (Integer)p_213764_1_.getValue()).sum();
    }

    public boolean canCookItem() {
        return this.canCookItemCount() > 40 && this.func_213751_ew() < 128;
    }

    private int canCookItemCount() {
        Inventory inventory = this.func_213715_ed();
        return canCookItems.entrySet().stream().mapToInt(p_213764_1_ -> inventory.func_213901_a((Item)p_213764_1_.getKey()) * (Integer)p_213764_1_.getValue()).sum();
    }

    public boolean canKeepCookItem() {
        return this.canCookItemCount() > 30 && this.func_213751_ew() < 128;
    }

    public void consumeFoods() {
        if (this.canAbondonItems() && this.func_213751_ew() != 0) {
            for (int i = 0; i < this.func_213715_ed().func_70302_i_(); ++i) {
                int j;
                Integer integer;
                ItemStack itemstack = this.func_213715_ed().func_70301_a(i);
                if (itemstack.func_190926_b() || (integer = field_213788_bA.get(itemstack.func_77973_b())) == null) continue;
                for (int k = j = itemstack.func_190916_E(); k > 0; --k) {
                    this.func_213715_ed().func_70298_a(i, 1);
                    if (this.canAbondonItems()) continue;
                    return;
                }
            }
        }
    }

    public ItemStack findFoods() {
        for (int i = 0; i < this.func_213715_ed().func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_213715_ed().func_70301_a(i);
            if (itemstack.func_190926_b() || !this.isTofuniansFood(itemstack.func_77973_b())) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void cookingFood() {
        if (this.canCookItemCount() != 0) {
            for (int i = 0; i < this.func_213715_ed().func_70302_i_(); ++i) {
                Integer integer;
                ItemStack itemstack = this.func_213715_ed().func_70301_a(i);
                if (itemstack.func_190926_b() || (integer = canCookItems.get(itemstack.func_77973_b())) == null) continue;
                int j = itemstack.func_190916_E();
                this.func_213715_ed().func_70298_a(i, 1);
                this.cookResult();
            }
        }
    }

    private void cookResult() {
        this.func_213715_ed().func_174894_a(new ItemStack((IItemProvider)cookedItem.get(this.func_70681_au().nextInt(cookedItem.size()))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
            }
        } else if (id == 13) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197609_b, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean canMateWith(TofunianEntity otherTofunian) {
        if (otherTofunian == this) {
            return false;
        }
        if (((Object)((Object)otherTofunian)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.canAbondonItems() && otherTofunian.canAbondonItems();
    }

    public void func_70604_c(@Nullable LivingEntity livingBase) {
        if (livingBase != null && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217489_a(IReputationType.field_221031_c, (Entity)livingBase, (IReputationTracking)this);
            if (this.func_70089_S() && livingBase instanceof PlayerEntity) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)13);
            }
        }
        super.func_70604_c(livingBase);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.inLove = 0;
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause == TofuDamageSource.POISED_ZUNDAMA) {
            TofunianEntity tofunian = this;
            ZombieTofunianEntity zombietofunian = (ZombieTofunianEntity)tofunian.func_233656_b_(TofuEntitys.ZOMBIE_TOFUNIAN, false);
            zombietofunian.setGossips((INBT)tofunian.getGossip().func_234058_a_((DynamicOps)NBTDynamicOps.field_210820_a).getValue());
            zombietofunian.setOffers(tofunian.func_213706_dY().func_222199_a());
            zombietofunian.setEXP(tofunian.func_213708_dV());
            zombietofunian.setRole(tofunian.getRole());
            if (!this.func_174814_R()) {
                this.field_70170_p.func_217378_a((PlayerEntity)null, 1026, this.func_233580_cy_(), 0);
            }
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!(itemstack.func_77973_b() == TofuItems.TOFUNIAN_SPAWNEGG || !this.func_70089_S() || this.func_213716_dX() || this.func_70631_g_() || this.func_70608_bn() || player.func_226563_dT_())) {
            if (this.func_213706_dY().isEmpty()) {
                if (!this.isNitwit()) {
                    this.func_213712_ef();
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70932_a_(player);
                        this.displayMerchantGui(player);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (!this.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND) {
                    this.shakeHead();
                }
                return super.func_230254_b_(player, hand);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                this.displayMerchantGui(player);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        boolean flag = this.func_70931_l_() != null && player == null;
        super.func_70932_a_(player);
        if (flag) {
            this.func_213750_eg();
        }
    }

    public void func_213704_a(MerchantOffer offer) {
        offer.func_222219_j();
        this.field_70757_a = -this.func_70627_aG();
        this.func_213713_b(offer);
        if (this.previousCustomer instanceof ServerPlayerEntity) {
            TofuCriterias.TOFUNIAN_TRADE.test((ServerPlayerEntity)this.previousCustomer, this, offer.func_222200_d());
        }
    }

    private void displayMerchantGui(PlayerEntity player) {
        this.recalculateSpecialPricesFor(player);
        this.func_70932_a_(player);
        this.func_213707_a(player, this.func_145748_c_(), this.getLevel());
    }

    private void recalculateSpecialPricesFor(PlayerEntity playerIn) {
        int i = this.getPlayerReputation(playerIn);
        if (i != 0) {
            for (MerchantOffer merchantoffer : this.func_213706_dY()) {
                merchantoffer.func_222207_a(-MathHelper.func_76141_d((float)((float)i * merchantoffer.func_222211_m())));
            }
        }
        if (playerIn.func_70644_a(Effects.field_220310_F)) {
            EffectInstance effectinstance = playerIn.func_70660_b(Effects.field_220310_F);
            int k = effectinstance.func_76458_c();
            for (MerchantOffer merchantoffer1 : this.func_213706_dY()) {
                double d0 = 0.3 + 0.0625 * (double)k;
                int j = (int)Math.floor(d0 * (double)merchantoffer1.func_222218_a().func_190916_E());
                merchantoffer1.func_222207_a(-Math.max(j, 1));
            }
        }
    }

    public int getPlayerReputation(PlayerEntity player) {
        return this.gossip.func_220921_a(player.func_110124_au(), p_223103_0_ -> true);
    }

    public void func_213739_a(IReputationType type, Entity target) {
        if (type == IReputationType.field_221029_a) {
            this.gossip.func_220916_a(target.func_110124_au(), GossipType.MAJOR_POSITIVE, 20);
            this.gossip.func_220916_a(target.func_110124_au(), GossipType.MINOR_POSITIVE, 25);
        } else if (type == IReputationType.field_221033_e) {
            this.gossip.func_220916_a(target.func_110124_au(), GossipType.TRADING, 2);
        } else if (type == IReputationType.field_221031_c) {
            this.gossip.func_220916_a(target.func_110124_au(), GossipType.MINOR_NEGATIVE, 25);
        } else if (type == IReputationType.field_221032_d) {
            this.gossip.func_220916_a(target.func_110124_au(), GossipType.MAJOR_NEGATIVE, 25);
        }
    }

    public GossipManager getGossip() {
        return this.gossip;
    }

    public void setGossips(INBT gossip) {
        this.gossip.func_234057_a_(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)gossip));
    }

    protected SoundEvent func_184639_G() {
        return TofuSounds.TOFUNIAN_AMBIENT;
    }

    protected SoundEvent func_184615_bR() {
        return TofuSounds.TOFUNIAN_DEATH;
    }

    protected SoundEvent func_213721_r(boolean getYesSound) {
        return getYesSound ? TofuSounds.TOFUNIAN_YES : TofuSounds.TOFUNIAN_NO;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? this.func_213302_cg() * 0.3f : this.func_213302_cg() * 0.8f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.updateTofunianState();
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return data;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    @Nullable
    public TofunianEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        TofunianEntity entityvillager = (TofunianEntity)TofuEntitys.TOFUNIAN.func_200721_a(this.field_70170_p);
        return entityvillager;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("entity.tofucraft.tofunian." + this.getRole().toString().toLowerCase(Locale.ROOT) + ".name");
    }

    class DoSleepingGoal
    extends Goal {
        public DoSleepingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return TofunianEntity.this.func_70608_bn();
        }
    }

    public class MoveToJobGoal
    extends Goal {
        public final TofunianEntity tofunian;
        public final double distance;
        public final double speed;

        public MoveToJobGoal(TofunianEntity houseTofunianEntity, double distance, double speed) {
            this.tofunian = houseTofunianEntity;
            this.distance = distance;
            this.speed = speed;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public void func_75251_c() {
            TofunianEntity.this.field_70699_by.func_75499_g();
        }

        public boolean func_75250_a() {
            BlockPos blockpos = this.tofunian.getTofunainJobBlock();
            if (WorldUtils.isJobTime(this.tofunian.field_70170_p)) {
                return blockpos != null && this.func_220846_a(blockpos, this.distance);
            }
            return false;
        }

        public boolean func_75253_b() {
            BlockPos blockpos = this.tofunian.getTofunainJobBlock();
            return blockpos != null && this.moveHome();
        }

        private boolean moveHome() {
            BlockPos blockpos = this.tofunian.getTofunainJobBlock();
            return this.func_220846_a(blockpos, this.distance * (double)0.2f);
        }

        public void func_75246_d() {
            BlockPos blockpos = this.tofunian.getTofunainJobBlock();
            if (blockpos != null && TofunianEntity.this.field_70699_by.func_75500_f()) {
                if (this.func_220846_a(blockpos, 6.0)) {
                    Vector3d vec3d = new Vector3d((double)blockpos.func_177958_n() - this.tofunian.func_226277_ct_(), (double)blockpos.func_177956_o() - this.tofunian.func_226278_cu_(), (double)blockpos.func_177952_p() - this.tofunian.func_226281_cx_()).func_72432_b();
                    Vector3d vec3d1 = vec3d.func_186678_a(10.0).func_72441_c(this.tofunian.func_226277_ct_(), this.tofunian.func_226278_cu_(), this.tofunian.func_226281_cx_());
                    TofunianEntity.this.field_70699_by.func_75492_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, this.speed);
                } else {
                    TofunianEntity.this.field_70699_by.func_75492_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), this.speed);
                }
            }
        }

        private boolean func_220846_a(BlockPos p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.func_218137_a((IPosition)this.tofunian.func_213303_ch(), p_220846_2_);
        }
    }

    public class MoveToHomeGoal
    extends Goal {
        public final TofunianEntity tofunian;
        public final double distance;
        public final double speed;

        public MoveToHomeGoal(TofunianEntity houseTofunianEntity, double distance, double speed) {
            this.tofunian = houseTofunianEntity;
            this.distance = distance;
            this.speed = speed;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public void func_75251_c() {
            TofunianEntity.this.field_70699_by.func_75499_g();
        }

        public boolean func_75250_a() {
            BlockPos blockpos = this.tofunian.getTofunainHome();
            if (!WorldUtils.isDaytime(this.tofunian.field_70170_p)) {
                return blockpos != null && this.func_220846_a(blockpos, this.distance);
            }
            return blockpos != null && this.func_220846_a(blockpos, this.distance);
        }

        public boolean func_75253_b() {
            BlockPos blockpos = this.tofunian.getTofunainHome();
            return blockpos != null && this.moveHome();
        }

        private boolean moveHome() {
            BlockPos blockpos = this.tofunian.getTofunainHome();
            if (!WorldUtils.isDaytime(this.tofunian.field_70170_p)) {
                return this.func_220846_a(blockpos, this.distance * (double)0.2f);
            }
            return this.func_220846_a(blockpos, this.distance * 0.75);
        }

        public void func_75246_d() {
            BlockPos blockpos = this.tofunian.getTofunainHome();
            if (blockpos != null && TofunianEntity.this.field_70699_by.func_75500_f()) {
                if (this.func_220846_a(blockpos, 6.0)) {
                    Vector3d vec3d = new Vector3d((double)blockpos.func_177958_n() - this.tofunian.func_226277_ct_(), (double)blockpos.func_177956_o() - this.tofunian.func_226278_cu_(), (double)blockpos.func_177952_p() - this.tofunian.func_226281_cx_()).func_72432_b();
                    Vector3d vec3d1 = vec3d.func_186678_a(10.0).func_72441_c(this.tofunian.func_226277_ct_(), this.tofunian.func_226278_cu_(), this.tofunian.func_226281_cx_());
                    TofunianEntity.this.field_70699_by.func_75492_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, this.speed);
                } else {
                    TofunianEntity.this.field_70699_by.func_75492_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), this.speed);
                }
            }
        }

        private boolean func_220846_a(BlockPos p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.func_218137_a((IPosition)this.tofunian.func_213303_ch(), p_220846_2_);
        }
    }

    public static enum Roles implements IExtensibleEnum
    {
        TOFUCOOK,
        TOFUSMITH,
        SOYWORKER,
        TOFUNIAN;

        private static final Map<String, Roles> lookup;

        public static Roles create(String name) {
            throw new IllegalStateException("Enum not extended");
        }

        public static Roles get(String nameIn) {
            for (Roles role : Roles.values()) {
                if (!role.name().equals(nameIn)) continue;
                return role;
            }
            return TOFUNIAN;
        }

        static {
            lookup = Arrays.stream(Roles.values()).collect(Collectors.toMap(Enum::name, p_220362_0_ -> p_220362_0_));
        }
    }

    static class TradeForHicostItem
    implements VillagerTrades.ITrade {
        private final Item item;
        private final int count;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public TradeForHicostItem(IItemProvider item, int count, int maxUses, int givenXP) {
            this.item = item.func_199767_j();
            this.count = count;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = 0.05f;
        }

        public TradeForHicostItem(IItemProvider item, int count, int maxUses, int givenXP, float priceMultiplier) {
            this.item = item.func_199767_j();
            this.count = count;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity entity, Random random) {
            ItemStack itemstack = new ItemStack((IItemProvider)this.item);
            return new MerchantOffer(new ItemStack((IItemProvider)TofuItems.ZUNDARUBY, this.count), itemstack, this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }

    static class TradeForItem
    implements VillagerTrades.ITrade {
        private final Item item;
        private final int count;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public TradeForItem(IItemProvider item, int count, int maxUses, int givenXP) {
            this.item = item.func_199767_j();
            this.count = count;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity entity, Random random) {
            ItemStack itemstack = new ItemStack((IItemProvider)this.item, this.count);
            return new MerchantOffer(new ItemStack((IItemProvider)TofuItems.ZUNDARUBY), itemstack, this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }

    static class TradeForZundaRuby
    implements VillagerTrades.ITrade {
        private final Item item;
        private final int count;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public TradeForZundaRuby(IItemProvider item, int count, int maxUses, int givenXP) {
            this.item = item.func_199767_j();
            this.count = count;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity entity, Random random) {
            ItemStack itemstack = new ItemStack((IItemProvider)this.item, this.count);
            return new MerchantOffer(itemstack, new ItemStack((IItemProvider)TofuItems.ZUNDARUBY), this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }
}

