/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.entity;

import baguchan.mcmod.tofucraft.entity.movement.FlyingStrafeMovementController;
import baguchan.mcmod.tofucraft.entity.projectile.PoisedZundamaEntity;
import baguchan.mcmod.tofucraft.init.TofuDamageSource;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ZunsyEntity
extends MonsterEntity
implements IRangedAttackMob {
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;
    private float offsetSize0;
    private float offsetSize;
    private static final DataParameter<Byte> ON_TOXIC = EntityDataManager.func_187226_a(ZunsyEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public ZunsyEntity(EntityType<? extends ZunsyEntity> p_i48553_1_, World p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
        this.field_70765_h = new FlyingStrafeMovementController((MobEntity)this, 20, false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 0.95));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractIllagerEntity.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ON_TOXIC, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute getAttributeMap() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, (double)0.26f).func_233815_a_(Attributes.field_233822_e_, 0.5).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233819_b_, 20.0);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    protected void func_70619_bc() {
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
        }
        LivingEntity target = this.func_70638_az();
        Vector3d vec3d = this.func_213322_ci();
        if (target != null && target.func_70089_S() && target.func_226278_cu_() + (double)target.func_70047_e() > this.func_226278_cu_() + (double)this.func_70047_e() + (double)this.heightOffset && this.func_70089_S()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, ((double)0.3f - vec3d.field_72448_b) * (double)0.3f, 0.0));
            this.field_70160_al = true;
        }
        if (!this.field_70122_E && vec3d.field_72448_b < 0.0) {
            this.func_213317_d(vec3d.func_216372_d(1.0, 0.6, 1.0));
        }
        super.func_70619_bc();
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.offsetSize != this.offsetSize0) {
            this.func_213323_x_();
        }
        this.offsetSize0 = this.offsetSize;
        this.offsetSize = this.isCharged() ? MathHelper.func_76131_a((float)(this.offsetSize + 0.1f), (float)0.0f, (float)1.0f) : MathHelper.func_76131_a((float)(this.offsetSize - 0.1f), (float)0.0f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationScale(float p_189795_1_) {
        return MathHelper.func_219799_g((float)p_189795_1_, (float)this.offsetSize0, (float)this.offsetSize) / 1.0f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.offsetSize > 0.0f) {
            float f = this.offsetSize / 1.0f;
            float f1 = 1.0f + f;
            return super.func_213305_a(poseIn).func_220312_a(1.0f, f1);
        }
        return super.func_213305_a(poseIn).func_220313_a(1.0f);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        if (this.offsetSize > 0.0f) {
            float f = this.offsetSize / 1.0f;
            float f1 = 1.2f * f;
            return 0.85f * sizeIn.field_220316_b;
        }
        return 0.85f * sizeIn.field_220316_b;
    }

    public boolean func_145773_az() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void func_82196_d(LivingEntity livingEntity, float v) {
        this.func_184185_a(SoundEvents.field_187870_fk, 1.2f, 1.0f);
        double d1 = livingEntity.func_226277_ct_() - this.func_226277_ct_();
        double d2 = livingEntity.func_226278_cu_() - this.func_226278_cu_();
        double d3 = livingEntity.func_226281_cx_() - this.func_226281_cx_();
        PoisedZundamaEntity zundama = new PoisedZundamaEntity(this.field_70170_p, (LivingEntity)this);
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.3f;
        zundama.func_70186_c(d1, d2 + (double)f, d3, 1.0f, 1.0f);
        this.field_70170_p.func_217376_c((Entity)zundama);
        this.field_70170_p.func_217376_c((Entity)zundama);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == TofuDamageSource.POISED_ZUNDAMA) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        return potioneffectIn.func_188419_a() == Effects.field_82731_v || potioneffectIn.func_188419_a() == Effects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    public boolean isCharged() {
        return ((Byte)this.field_70180_af.func_187225_a(ON_TOXIC) & 1) != 0;
    }

    private void setOnToxic(boolean onToxic) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ON_TOXIC);
        b0 = onToxic ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(ON_TOXIC, (Object)b0);
    }

    protected int func_70682_h(int air) {
        return air;
    }

    static class AttackGoal
    extends Goal {
        private final ZunsyEntity zunsy;
        private int attackStep;
        private int attackTime;
        private int firedRecentlyTimer;

        public AttackGoal(ZunsyEntity zunsyIn) {
            this.zunsy = zunsyIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.zunsy.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.zunsy.func_213336_c(livingentity);
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.zunsy.setOnToxic(false);
            this.firedRecentlyTimer = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity livingentity = this.zunsy.func_70638_az();
            if (livingentity != null) {
                boolean flag = this.zunsy.func_70635_at().func_75522_a((Entity)livingentity);
                this.firedRecentlyTimer = flag ? 0 : ++this.firedRecentlyTimer;
                double d0 = this.zunsy.func_70068_e((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.zunsy.func_70652_k((Entity)livingentity);
                    }
                    this.zunsy.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.func_226277_ct_() - this.zunsy.func_226277_ct_();
                    double d2 = livingentity.func_226283_e_(0.5) - this.zunsy.func_226283_e_(0.5);
                    double d3 = livingentity.func_226281_cx_() - this.zunsy.func_226281_cx_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                            this.zunsy.setOnToxic(true);
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                            this.zunsy.setOnToxic(false);
                        }
                        if (this.attackStep > 1) {
                            for (int i = 0; i < 1; ++i) {
                                this.zunsy.func_82196_d(livingentity, 0.0f);
                            }
                        }
                    }
                    if (d0 > this.getFollowDistance() * this.getFollowDistance() / 2.0) {
                        this.zunsy.func_70661_as().func_75492_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                    }
                    this.zunsy.func_70671_ap().func_75651_a((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.firedRecentlyTimer < 5) {
                    this.zunsy.func_70661_as().func_75492_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                }
                super.func_75246_d();
            }
        }

        private double getFollowDistance() {
            return this.zunsy.func_233637_b_(Attributes.field_233819_b_);
        }
    }
}

