/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.entity.ai;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.math.MathHelper;

public class RangedStrafeAttackGoal<T extends MonsterEntity>
extends Goal {
    private final MobEntity entity;
    private final T rangedAttackEntityHost;
    private LivingEntity targetEntity;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public RangedStrafeAttackGoal(T attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
        this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
    }

    public RangedStrafeAttackGoal(T attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
        if (!(attacker instanceof LivingEntity)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackEntityHost = attacker;
        this.entity = attacker;
        this.entityMoveSpeed = movespeed;
        this.attackIntervalMin = p_i1650_4_;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistanceIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = this.entity.func_70638_az();
        if (livingentity != null && livingentity.func_70089_S()) {
            this.targetEntity = livingentity;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.targetEntity = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        double d0 = this.entity.func_70092_e(this.targetEntity.func_226277_ct_(), this.targetEntity.func_174813_aQ().field_72338_b, this.targetEntity.func_226281_cx_());
        boolean flag = this.entity.func_70635_at().func_75522_a((Entity)this.targetEntity);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 5) {
            this.entity.func_70661_as().func_75499_g();
            ++this.strafingTime;
        } else {
            this.entity.func_70661_as().func_75497_a((Entity)this.targetEntity, this.entityMoveSpeed);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.rangedAttackEntityHost.func_70681_au().nextFloat() < 0.3) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                this.strafingBackwards = false;
            } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                this.strafingBackwards = true;
            }
            this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.entity.func_70625_a((Entity)this.targetEntity, 30.0f, 30.0f);
        } else {
            this.entity.func_70671_ap().func_75651_a((Entity)this.targetEntity, 30.0f, 30.0f);
        }
        if (--this.rangedAttackTime == 0) {
            if (!flag) {
                return;
            }
            float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
            ((IRangedAttackMob)this.rangedAttackEntityHost).func_82196_d(this.targetEntity, lvt_5_1_);
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.rangedAttackTime < 0) {
            float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        }
    }
}

