/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.entity.projectile;

import baguchan.mcmod.tofucraft.block.TofuBlock;
import baguchan.mcmod.tofucraft.init.TofuBlocks;
import baguchan.mcmod.tofucraft.init.TofuEntitys;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class TofuCoreEntity
extends Entity {
    private static final DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(TofuCoreEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    @Nullable
    private LivingEntity tntPlacedBy;
    private int fuse = 80;
    public boolean isCanBreak = false;
    public int transformPower = 4;
    public float explosionPower = 1.0f;

    public TofuCoreEntity(EntityType<? extends TofuCoreEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70156_m = true;
    }

    public TofuCoreEntity(World worldIn, double x, double y, double z, @Nullable LivingEntity igniter) {
        this(TofuEntitys.TOFU_CORE, worldIn);
        this.func_70107_b(x, y, z);
        double d0 = worldIn.field_73012_v.nextDouble() * 6.2831854820251465;
        this.func_213293_j(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.setFuse(80);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.tntPlacedBy = igniter;
    }

    public TofuCoreEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(TofuEntitys.TOFU_CORE, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FUSE, (Object)80);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vector3d vector3d = new Vector3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vector3d);
        float f = MathHelper.func_76133_a((double)TofuCoreEntity.func_213296_b((Vector3d)vector3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void shoot(Entity p_234612_1_, float p_234612_2_, float p_234612_3_, float p_234612_4_, float p_234612_5_, float p_234612_6_) {
        float f = -MathHelper.func_76126_a((float)(p_234612_3_ * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(p_234612_2_ * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((p_234612_2_ + p_234612_4_) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(p_234612_3_ * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(p_234612_2_ * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, p_234612_5_, p_234612_6_);
        Vector3d vector3d = p_234612_1_.func_213322_ci();
        this.func_213317_d(this.func_213322_ci().func_72441_c(vector3d.field_72450_a, p_234612_1_.func_233570_aj_() ? 0.0 : vector3d.field_72448_b, vector3d.field_72449_c));
    }

    public void func_70071_h_() {
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
        }
        --this.fuse;
        if (this.fuse <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.explode();
            }
        } else {
            this.func_233566_aG_();
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void explode() {
        float f = 4.0f;
        boolean mobGriefing = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
        if (mobGriefing) {
            this.transformBlocks();
        }
        this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.explosionPower, this.isCanBreak ? Explosion.Mode.BREAK : Explosion.Mode.NONE);
    }

    private void transformBlocks() {
        int range = this.transformPower;
        BlockPos pos = new BlockPos((Vector3i)this.func_233580_cy_());
        for (int dx = -range; dx <= range; ++dx) {
            for (int dy = -range; dy <= range; ++dy) {
                for (int dz = -range; dz <= range; ++dz) {
                    float randRange;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (!(distance < (double)(randRange = (float)range + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 2.0f))) continue;
                    this.transformBlock(pos.func_177982_a(dx, dy, dz));
                }
            }
        }
    }

    private void transformBlock(BlockPos pos) {
        BlockState state = this.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.func_149638_a() < 8.0f) {
            if (this.shouldTransformTofu(state, pos) && !(state.func_177230_c() instanceof TofuBlock)) {
                if (state.func_185887_b((IBlockReader)this.field_70170_p, pos) <= 0.35f) {
                    this.field_70170_p.func_175656_a(pos, TofuBlocks.KINUTOFU.func_176223_P());
                } else {
                    this.field_70170_p.func_175656_a(pos, TofuBlocks.TOFUTERRAIN.func_176223_P());
                }
            } else if (this.shouldTransformTofuStone(state, pos)) {
                this.field_70170_p.func_175656_a(pos, TofuBlocks.ISHITOFU.func_176223_P());
            } else if (this.shouldTransformTofuPlants(state, pos)) {
                this.field_70170_p.func_175656_a(pos, TofuBlocks.TOFUFLOWER.func_176223_P());
            } else if (this.shouldTransformTofuLeaves(state, pos)) {
                this.field_70170_p.func_175656_a(pos, TofuBlocks.TOFULEAVES.func_176223_P());
            }
        }
    }

    private boolean shouldTransformTofuPlants(BlockState state, BlockPos pos) {
        return state.func_177230_c() instanceof FlowerBlock;
    }

    private boolean shouldTransformTofuLeaves(BlockState state, BlockPos pos) {
        return state.func_177230_c() instanceof LeavesBlock;
    }

    private boolean shouldTransformTofuStone(BlockState state, BlockPos pos) {
        return state.func_215686_e((IBlockReader)this.field_70170_p, pos) && state.func_185904_a() == Material.field_151576_e && !(state.func_177230_c() instanceof TofuBlock) && state.func_177230_c() != TofuBlocks.ISHITOFU_BRICK && state.func_177230_c() != TofuBlocks.ISHITOFU_CHISELED_BRICK && state.func_177230_c() != TofuBlocks.ISHITOFU_SMOOTH_BRICK;
    }

    private boolean shouldTransformTofu(BlockState state, BlockPos pos) {
        return state.func_177230_c() != Blocks.field_150350_a && state.func_215686_e((IBlockReader)this.field_70170_p, pos) && state.func_185887_b((IBlockReader)this.field_70170_p, pos) <= 0.75f;
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("CanBreak", this.isCanBreak);
        compound.func_74777_a("Fuse", (short)this.getFuse());
        compound.func_74768_a("TransformPower", this.transformPower);
        compound.func_74776_a("ExplosionPower", this.explosionPower);
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("CanBreak")) {
            this.isCanBreak = compound.func_74767_n("CanBreak");
        }
        this.setFuse(compound.func_74765_d("Fuse"));
        this.transformPower = compound.func_74762_e("TransformPower");
        this.explosionPower = compound.func_74762_e("ExplosionPower");
    }

    @Nullable
    public LivingEntity getTntPlacedBy() {
        return this.tntPlacedBy;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.15f;
    }

    public void setFuse(int fuseIn) {
        this.field_70180_af.func_187227_b(FUSE, (Object)fuseIn);
        this.fuse = fuseIn;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (FUSE.equals(key)) {
            this.fuse = this.getFuseDataManager();
        }
    }

    public int getFuseDataManager() {
        return (Integer)this.field_70180_af.func_187225_a(FUSE);
    }

    public int getFuse() {
        return this.fuse;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

