/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.init;

import baguchan.mcmod.tofucraft.TofuCraftCore;
import baguchan.mcmod.tofucraft.init.TofuBlocks;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.ai.brain.task.GiveHeroGiftsTask;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tofucraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TofuVillagers {
    public static final PointOfInterestType SALT_FURNACE = new PointOfInterestType("tofu_craftsman", (Set)ImmutableSet.copyOf((Collection)TofuBlocks.SALT_FURNACE.func_176194_O().func_177619_a()), 1, 1);
    public static final VillagerProfession TOFU_CRAFTSMAN = new VillagerProfession("tofu_craftsman", SALT_FURNACE, ImmutableSet.of(), ImmutableSet.of(), SoundEvents.field_219701_mI);

    @SubscribeEvent
    public static void registerPointOfInterest(RegistryEvent.Register<PointOfInterestType> register) {
        PointOfInterestType.func_221052_a((PointOfInterestType)SALT_FURNACE);
        register.getRegistry().register(SALT_FURNACE.setRegistryName("salt_furnace"));
    }

    @SubscribeEvent
    public static void registerVillagerProfession(RegistryEvent.Register<VillagerProfession> register) {
        register.getRegistry().register(TOFU_CRAFTSMAN.setRegistryName("tofu_craftsman"));
    }

    public static void init() {
        PlainsVillagePools.func_214744_a();
        SnowyVillagePools.func_214746_a();
        SavannaVillagePools.func_214745_a();
        DesertVillagePools.func_222739_a();
        TaigaVillagePools.func_214806_a();
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            TofuVillagers.addToPool(new ResourceLocation("village/" + biome + "/houses"), new ResourceLocation("tofucraft", "village/tofu_craftsman_house_" + biome + "_1"), 3);
        }
        GiveHeroGiftsTask.field_220403_a.put(TOFU_CRAFTSMAN, TofuCraftCore.prefix("gameplay/hero_of_the_village/tofu_craftsman"));
    }

    private static void addToPool(ResourceLocation pool, ResourceLocation toAdd, int weight) {
        JigsawPattern old = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(pool);
        List shuffled = old != null ? old.func_214943_b(new Random(0L)) : ImmutableList.of();
        Object2IntLinkedOpenHashMap newPieces = new Object2IntLinkedOpenHashMap();
        Iterator iterator = shuffled.iterator();
        while (iterator.hasNext()) {
            JigsawPiece p = (JigsawPiece)iterator.next();
            newPieces.computeInt((Object)p, (pTemp, i) -> (i == null ? 0 : i) + 1);
        }
        newPieces.put((Object)new LegacySingleJigsawPiece(Either.left((Object)toAdd), () -> ProcessorLists.field_244101_a, JigsawPattern.PlacementBehaviour.RIGID), weight);
        List newPieceList = newPieces.object2IntEntrySet().stream().map(e -> Pair.of((Object)e.getKey(), (Object)e.getIntValue())).collect(Collectors.toList());
        ResourceLocation name = old.func_214947_b();
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243656_h, (ResourceLocation)pool, (Object)new JigsawPattern(pool, name, newPieceList));
    }
}

