/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.item.tfenergy;

import baguchan.mcmod.tofucraft.api.tfenergy.ITofuEnergy;
import baguchan.mcmod.tofucraft.api.tfenergy.TofuNetwork;
import baguchan.mcmod.tofucraft.client.model.GandlemArmorModel;
import baguchan.mcmod.tofucraft.init.TofuArmorMaterial;
import baguchan.mcmod.tofucraft.item.base.IEnergyContained;
import baguchan.mcmod.tofucraft.item.base.IEnergyExtractable;
import baguchan.mcmod.tofucraft.item.base.IEnergyInsertable;
import baguchan.mcmod.tofucraft.tileentity.tofuenergy.base.SenderBaseTileEntity;
import baguchan.mcmod.tofucraft.utils.NBTUtil;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GandlemArmorItem
extends ArmorItem
implements IEnergyExtractable,
IEnergyInsertable,
IEnergyContained {
    public static final String TAG_TF = "tf_energy";
    public static final String TAG_TFMAX = "tf_energymax";

    public GandlemArmorItem(TofuArmorMaterial armorMaterial, EquipmentSlotType chest, Item.Properties group) {
        super((IArmorMaterial)armorMaterial, chest, group);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.tofucraft.energy", new Object[]{this.getEnergy(stack), this.getEnergyMax(stack)}));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    private boolean getShowState(ItemStack stack) {
        return Minecraft.func_71410_x().field_71439_g.func_225608_bj_() && this.getEnergy(stack) != 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getShowState(stack) || super.showDurabilityBar(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return this.getShowState(stack) ? 1.0 - (double)this.getEnergy(stack) / (double)this.getEnergyMax(stack) : super.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return this.getShowState(stack) ? Color.white.getRGB() : super.getRGBDurabilityForDisplay(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack stack, EquipmentSlotType armorSlot, A _default) {
        return (A)((Object)new GandlemArmorModel(1.0f));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        BlockPos entityPos;
        List<TileEntity> list;
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof LivingEntity) {
            LivingEntity entityLivingBase = (LivingEntity)entityIn;
            if (entityLivingBase.field_70173_aa % 400 == 0 && entityLivingBase.func_110143_aJ() < entityLivingBase.func_110138_aP()) {
                if (this.getEnergy(stack) >= 5) {
                    this.drain(stack, 5, false);
                }
                entityLivingBase.func_70691_i(1.0f);
            }
        }
        if (!worldIn.field_72995_K && this.getEnergy(stack) < this.getEnergyMax(stack) && !(list = TofuNetwork.toTiles(TofuNetwork.Instance.getExtractableWithinRadius(worldIn, entityPos = new BlockPos(entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_()), 64.0))).isEmpty()) {
            TileEntity te;
            int toDrain = this.getEnergyMax(stack) - this.getEnergy(stack);
            Iterator<TileEntity> iterator = list.iterator();
            while (!(!iterator.hasNext() || (te = iterator.next()) instanceof SenderBaseTileEntity && ((SenderBaseTileEntity)te).isValid() && te.func_174877_v().func_218141_a((Vector3i)new BlockPos(entityPos.func_177958_n(), entityPos.func_177956_o(), entityPos.func_177952_p()), ((SenderBaseTileEntity)te).getRadius()) && (toDrain -= ((ITofuEnergy)te).drain(Math.min(toDrain, ((SenderBaseTileEntity)te).getTransferPower()), false)) == 0)) {
            }
            this.fill(stack, this.getEnergyMax(stack) - this.getEnergy(stack) - toDrain, false);
            if (stack.func_77952_i() < stack.func_77958_k() && this.getEnergy(stack) >= 5) {
                this.drain(stack, 5, false);
                stack.func_196085_b(stack.func_77952_i() - 1);
            }
        }
    }

    @Override
    public int drain(ItemStack inst, int amount, boolean simulate) {
        int calculated = Math.min(amount, this.getEnergy(inst));
        if (!simulate) {
            this.setEnergy(inst, this.getEnergy(inst) - calculated);
        }
        return calculated;
    }

    @Override
    public int fill(ItemStack inst, int amount, boolean simulate) {
        int calculated = Math.min(amount, this.getEnergyMax(inst) - this.getEnergy(inst));
        if (!simulate) {
            this.setEnergy(inst, this.getEnergy(inst) + calculated);
        }
        return calculated;
    }

    @Override
    public int getEnergy(ItemStack inst) {
        return NBTUtil.getInteger(inst.func_77978_p(), TAG_TF, 0);
    }

    @Override
    public int getEnergyMax(ItemStack inst) {
        return 10000;
    }

    @Override
    public void setEnergy(ItemStack inst, int amount) {
        inst.func_77982_d(NBTUtil.setInteger(inst.func_77978_p(), TAG_TF, amount));
    }

    @Override
    public void setEnergyMax(ItemStack inst, int amount) {
        inst.func_77982_d(NBTUtil.setInteger(inst.func_77978_p(), TAG_TFMAX, amount));
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        this.func_77663_a(entity.func_92059_d(), entity.func_130014_f_(), (Entity)entity, 0, false);
        return super.onEntityItemUpdate(stack, entity);
    }
}

