/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.item.tfenergy;

import baguchan.mcmod.tofucraft.entity.projectile.FukumameEntity;
import baguchan.mcmod.tofucraft.item.base.TofuEnergyContainedItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TofuGauntletItem
extends TofuEnergyContainedItem {
    public TofuGauntletItem(Item.Properties group) {
        super(group);
    }

    public static boolean isUsable(ItemStack stack) {
        return stack.func_77952_i() < stack.func_77958_k() - 1;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
        int i = this.func_77626_a(stack) - timeLeft;
        Mode mode = Mode.byItemStack(stack);
        if (mode == Mode.HEAL) {
            entityLiving.func_70691_i(5.0f);
            if (entityLiving instanceof PlayerEntity) {
                if (!((PlayerEntity)entityLiving).field_71075_bZ.field_75098_d) {
                    if (this.getEnergy(stack) >= 5) {
                        this.drain(stack, 5, false);
                    } else {
                        stack.func_222118_a(1, (LivingEntity)((PlayerEntity)entityLiving), p_220009_1_ -> p_220009_1_.func_213334_d(((PlayerEntity)entityLiving).func_184600_cs()));
                    }
                }
                ((PlayerEntity)entityLiving).func_184811_cZ().func_185145_a(stack.func_77973_b(), 100);
            }
        }
    }

    private static float getCharge(int useTime, ItemStack stack) {
        float f = (float)useTime / 20.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        Mode mode = Mode.byItemStack(itemstack);
        if (!playerIn.func_225608_bj_()) {
            if (!TofuGauntletItem.isUsable(itemstack)) {
                return ActionResult.func_226251_d_((Object)itemstack);
            }
            if (mode == Mode.SOYSHOT) {
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    if (this.getEnergy(itemstack) >= 5) {
                        this.drain(itemstack, 5, false);
                    } else {
                        itemstack.func_222118_a(1, (LivingEntity)playerIn, p_220009_1_ -> p_220009_1_.func_213334_d(playerIn.func_184600_cs()));
                    }
                }
                worldIn.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
                if (!worldIn.field_72995_K) {
                    for (int i = 0; i < 8; ++i) {
                        FukumameEntity fukumamelentity = new FukumameEntity(worldIn, (LivingEntity)playerIn);
                        float d0 = worldIn.field_73012_v.nextFloat() * 18.0f - 9.0f;
                        fukumamelentity.func_234612_a_((Entity)playerIn, playerIn.field_70125_A + d0 * 0.25f, playerIn.field_70177_z + d0, 0.0f, 1.5f, 0.8f);
                        worldIn.func_217376_c((Entity)fukumamelentity);
                    }
                }
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                return ActionResult.func_226248_a_((Object)itemstack);
            }
            playerIn.func_184598_c(handIn);
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        this.toggleBowMode(itemstack);
        playerIn.func_184185_a(SoundEvents.field_187909_gi, 0.5f, 1.75f);
        if (playerIn.field_70170_p.field_72995_K) {
            playerIn.func_146105_b(this.getModeMessage(itemstack), true);
        }
        return ActionResult.func_226248_a_((Object)itemstack);
    }

    public Mode toggleBowMode(ItemStack stack) {
        Mode current = Mode.byItemStack(stack);
        CompoundNBT nbt = stack.func_196082_o();
        Mode next = Mode.byType(current.getType() + 1);
        nbt.func_74768_a("Mode", next.getType());
        return next;
    }

    public ITextComponent getModeMessage(ItemStack stack) {
        Mode mode = Mode.byItemStack(stack);
        TranslationTextComponent name = new TranslationTextComponent(mode.getUnlocalizedName(stack));
        TranslationTextComponent title = new TranslationTextComponent(stack.func_77977_a() + ".mode");
        return name;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(this.getModeMessage(stack));
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.RARE;
    }

    @Override
    public int getEnergyMax(ItemStack inst) {
        return 10000;
    }

    public static enum Mode {
        SOYSHOT(0, "soyshot", 0.0f),
        HEAL(1, "heal", 20.0f);

        private static final Mode[] TYPE_LOOKUP;
        private int modeType;
        private String modeName;
        private float pullingSpeed;

        private Mode(int type, String name, float pulling) {
            this.modeType = type;
            this.modeName = name;
            this.pullingSpeed = pulling;
        }

        public int getType() {
            return this.modeType;
        }

        public String getModeName() {
            return this.modeName;
        }

        public String getUnlocalizedName(ItemStack stack) {
            return stack.func_77977_a() + "." + this.modeName;
        }

        public float getPullingSpeed() {
            return this.pullingSpeed;
        }

        public static Mode byItemStack(ItemStack stack) {
            if (stack.func_190926_b()) {
                return SOYSHOT;
            }
            CompoundNBT nbt = stack.func_196082_o();
            if (nbt == null || !nbt.func_150297_b("Mode", 99)) {
                return SOYSHOT;
            }
            return Mode.byType(nbt.func_74762_e("Mode"));
        }

        public static Mode byType(int type) {
            if (type < 0 || type >= TYPE_LOOKUP.length) {
                type = 0;
            }
            return TYPE_LOOKUP[type];
        }

        static {
            TYPE_LOOKUP = new Mode[Mode.values().length];
            Mode[] modeArray = Mode.values();
            int n = modeArray.length;
            for (int i = 0; i < n; ++i) {
                Mode mode;
                Mode.TYPE_LOOKUP[mode.getType()] = mode = modeArray[i];
            }
        }
    }
}

