/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.tileentity.tofuenergy.base;

import baguchan.mcmod.tofucraft.api.tfenergy.ITofuEnergy;
import baguchan.mcmod.tofucraft.api.tfenergy.TofuNetwork;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public abstract class EnergyBaseTileEntity
extends TileEntity
implements ITofuEnergy {
    public static final String TAG_ENERGY = "tf_energy";
    public static final String TAG_ENERGY_MAX = "tf_energy_max";
    public static final String TAG_UUID = "tf_uuid";
    protected String uuid = "";
    protected int energy;
    protected int energyMax;

    public EnergyBaseTileEntity(TileEntityType<? extends EnergyBaseTileEntity> tileEntityType, int energyMax) {
        super(tileEntityType);
        this.energyMax = energyMax;
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energyMax;
    }

    @Override
    public int receive(int toReceive, boolean simulate) {
        if (this.getEnergyStored() > this.getMaxEnergyStored()) {
            return 0;
        }
        int calculated = Math.min(toReceive, this.getMaxEnergyStored() - this.getEnergyStored());
        if (!simulate) {
            this.energy += calculated;
        }
        return calculated;
    }

    @Override
    public int drain(int toDrain, boolean simulate) {
        int calculated = Math.min(toDrain, this.getEnergyStored());
        if (!simulate) {
            this.energy -= calculated;
        }
        return calculated;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a(TAG_ENERGY, this.energy);
        compound.func_74778_a(TAG_UUID, this.uuid);
        compound.func_74768_a(TAG_ENERGY_MAX, this.energyMax);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.energyMax = nbt.func_74762_e(TAG_ENERGY_MAX);
        this.energy = nbt.func_74762_e(TAG_ENERGY);
        this.uuid = nbt.func_74779_i(TAG_UUID);
    }

    @Override
    public boolean canReceive(TileEntity from) {
        if (!(from instanceof ITofuEnergy)) {
            throw new IllegalArgumentException("It must be a instance of ITofuEnergy!");
        }
        return true;
    }

    @Override
    public boolean canDrain(TileEntity to) {
        if (!(to instanceof ITofuEnergy)) {
            throw new IllegalArgumentException("It must be a instance of ITofuEnergy!");
        }
        return true;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.uuid.isEmpty()) {
                this.uuid = UUID.randomUUID().toString();
            }
            TofuNetwork.Instance.register(this.uuid, this, false);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            TofuNetwork.Instance.unload(this.uuid, false);
        }
    }

    public boolean isRedstonePowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }
}

