/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.tileentity.tofuenergy.base;

import baguchan.mcmod.tofucraft.api.IAnntena;
import baguchan.mcmod.tofucraft.api.tfenergy.ITofuEnergy;
import baguchan.mcmod.tofucraft.api.tfenergy.TofuNetwork;
import baguchan.mcmod.tofucraft.tileentity.tofuenergy.base.EnergyBaseTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public abstract class SenderBaseTileEntity
extends EnergyBaseTileEntity
implements ITickableTileEntity {
    protected List<TileEntity> cache = new ArrayList<TileEntity>();
    protected boolean isCached = false;
    private Block antenna;

    public SenderBaseTileEntity(TileEntityType<? extends SenderBaseTileEntity> tileEntityType, int energyMax) {
        super(tileEntityType, energyMax);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.getEnergyStored() > 0) {
            if (this.isValid()) {
                if (!this.isCached) {
                    this.onCache();
                }
                if (this.cache.size() > 0) {
                    ArrayList toSend = new ArrayList();
                    this.cache.forEach(tileEntity -> {
                        if (((EnergyBaseTileEntity)tileEntity).getEnergyStored() < ((EnergyBaseTileEntity)tileEntity).getMaxEnergyStored() && !toSend.contains(tileEntity)) {
                            toSend.add(tileEntity);
                        }
                    });
                    if (toSend.size() > 0) {
                        int packSize = Math.max(Math.min(this.getTransferPower(), this.getEnergyStored()) / toSend.size(), 1);
                        for (TileEntity te : toSend) {
                            this.drain(((ITofuEnergy)te).receive(Math.min(packSize, this.getEnergyStored()), false), false);
                        }
                    }
                }
            } else {
                this.cache.clear();
                this.isCached = false;
            }
        }
    }

    public boolean isValid() {
        if (this.field_145850_b != null && this.field_145850_b.func_175667_e(this.field_174879_c.func_177984_a())) {
            this.antenna = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c();
        }
        return this.antenna != null && this.antenna instanceof IAnntena;
    }

    public void onCache() {
        this.cache = TofuNetwork.toTiles(TofuNetwork.Instance.getInsertableWithinRadius(this, ((IAnntena)this.antenna).getRadius(this.field_174879_c.func_177984_a(), this.field_145850_b)));
        this.isCached = true;
    }

    public int getTransferPower() {
        return this.field_145850_b != null && this.isValid() ? ((IAnntena)this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c()).getPower(this.field_174879_c.func_177984_a(), this.field_145850_b) : 0;
    }

    public double getRadius() {
        return ((IAnntena)this.antenna).getRadius(this.field_174879_c, this.field_145850_b);
    }

    @Override
    public boolean canDrain(TileEntity to) {
        return true;
    }

    @Override
    public boolean canReceive(TileEntity from) {
        return false;
    }
}

