/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.tileentity.tofuenergy.sender;

import baguchan.mcmod.tofucraft.api.recipes.TofuEnergyMap;
import baguchan.mcmod.tofucraft.block.utils.TFStorageBlock;
import baguchan.mcmod.tofucraft.container.TFStorageContainer;
import baguchan.mcmod.tofucraft.init.TofuTileEntitys;
import baguchan.mcmod.tofucraft.item.base.IEnergyExtractable;
import baguchan.mcmod.tofucraft.network.MessageSaltFurnaceFluid;
import baguchan.mcmod.tofucraft.network.TofuNetworkHandler;
import baguchan.mcmod.tofucraft.tileentity.tofuenergy.base.SenderBaseTileEntity;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TFStorageTileEntity
extends SenderBaseTileEntity
implements IInventory,
INamedContainerProvider,
ISidedInventory {
    private static final int POWER = 10;
    private FluidTank tank = new TFStorageTank(2000);
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    protected NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    private int workload = 0;
    private int current_workload = 0;
    private int prevFluid;
    protected final IIntArray tfData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TFStorageTileEntity.this.energy;
                }
                case 1: {
                    return TFStorageTileEntity.this.workload;
                }
                case 2: {
                    return TFStorageTileEntity.this.current_workload;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TFStorageTileEntity.this.energy = value;
                    break;
                }
                case 1: {
                    TFStorageTileEntity.this.workload = value;
                    break;
                }
                case 2: {
                    TFStorageTileEntity.this.current_workload = value;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.NORTH});
    private static final int[] SLOTS_SIDES = new int[]{0};

    public TFStorageTileEntity() {
        super((TileEntityType<? extends SenderBaseTileEntity>)TofuTileEntitys.TF_STORAGE, 5000);
    }

    @Override
    public void func_73660_a() {
        boolean worked = false;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.prevFluid != this.tank.getFluidAmount()) {
            Chunk chunk = this.field_145850_b.func_175726_f(this.func_174877_v());
            TofuNetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new MessageSaltFurnaceFluid(this.func_174877_v(), this.tank.getFluid()));
            this.prevFluid = this.tank.getFluidAmount();
        }
        if (this.workload > 0 && this.getEnergyStored() < this.getMaxEnergyStored()) {
            this.workload -= this.receive(Math.min(this.workload, 10), false);
            worked = true;
        }
        ItemStack from = (ItemStack)this.inventory.get(0);
        FluidStack milk = this.getTank().getFluid();
        if (this.workload == 0) {
            Map.Entry<FluidStack, Integer> recipe;
            if (from.func_77973_b() instanceof IEnergyExtractable) {
                IEnergyExtractable symbol = (IEnergyExtractable)from.func_77973_b();
                this.workload += symbol.drain(from, 200, false);
            } else if (TofuEnergyMap.getFuel(from) != -1) {
                this.workload += TofuEnergyMap.getFuel(from);
                from.func_190918_g(1);
            }
            if (milk != null && (recipe = TofuEnergyMap.getLiquidFuel(milk)) != null) {
                this.tank.drain(recipe.getKey().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                this.workload += recipe.getValue().intValue();
            }
            this.current_workload = this.workload;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)TFStorageBlock.LIT, (Comparable)Boolean.valueOf(worked)), 3);
        if (worked) {
            this.func_70296_d();
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    protected void refresh() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_180501_a(this.field_174879_c, state, 11);
        }
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(PlayerEntity player) {
        this.func_70296_d();
    }

    public void func_174886_c(PlayerEntity player) {
        this.func_70296_d();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public ITextComponent getName() {
        return new TranslationTextComponent("container.tofucraft.tfstorage.name");
    }

    public ITextComponent func_145748_c_() {
        return this.getName();
    }

    public int func_70302_i_() {
        return 1;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlers[0].cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT ret = super.func_189515_b(compound);
        this.writePacketNBT(ret);
        return ret;
    }

    @Nonnull
    public final CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.readPacketNBT(nbt);
    }

    public void writePacketNBT(CompoundNBT cmp) {
        ItemStackHelper.func_191282_a((CompoundNBT)cmp, this.inventory);
        cmp.func_74768_a("workload", this.workload);
        cmp.func_74768_a("current", this.current_workload);
        CompoundNBT tankTag = this.tank.writeToNBT(new CompoundNBT());
        cmp.func_218657_a("Tank", (INBT)tankTag);
    }

    public void readPacketNBT(CompoundNBT cmp) {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)cmp, this.inventory);
        this.workload = cmp.func_74762_e("workload");
        this.current_workload = cmp.func_74762_e("current");
        this.tank.readFromNBT(cmp.func_74775_l("Tank"));
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public int[] func_180463_a(Direction side) {
        return SLOTS_SIDES;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    @Nullable
    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        return new TFStorageContainer(p_createMenu_1_, p_createMenu_2_, this, this.tfData);
    }

    private class TFStorageTank
    extends FluidTank {
        TFStorageTank(int capacity) {
            super(capacity);
        }

        public boolean isFluidValid(FluidStack stack) {
            return super.isFluidValid(stack) && TofuEnergyMap.getLiquidFuel(TFStorageTileEntity.this.getTank().getFluid()) != null;
        }

        protected void onContentsChanged() {
            TFStorageTileEntity.this.refresh();
        }
    }
}

