/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.utils;

import com.google.common.collect.ImmutableList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;

public class DiamondTofuToolHandler {
    private ToolItem tool;

    public DiamondTofuToolHandler(ToolItem tool) {
        this.tool = tool;
    }

    protected static RayTraceResult rayTrace(World worldIn, PlayerEntity playerIn) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.func_226277_ct_();
        double d1 = playerIn.func_226278_cu_() + (double)playerIn.func_70047_e();
        double d2 = playerIn.func_226281_cx_();
        Vector3d vec3d = new Vector3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = playerIn.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get());
        Vector3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)playerIn));
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, World world, PlayerEntity player, BlockPos origin, int width, int height, int depth) {
        return DiamondTofuToolHandler.calcAOEBlocks(stack, world, player, origin, width, height, depth, -1);
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, World world, PlayerEntity player, BlockPos origin, int width, int height, int depth, int distance) {
        int z;
        int y;
        int x;
        if (stack.func_190926_b()) {
            return ImmutableList.of();
        }
        BlockState state = world.func_180495_p(origin);
        if (state.func_185904_a() == Material.field_151579_a) {
            return ImmutableList.of();
        }
        RayTraceResult mop = DiamondTofuToolHandler.rayTrace(world, player);
        if (!(mop != null && origin.equals((Object)new BlockPos(mop.func_216347_e())) || (mop = DiamondTofuToolHandler.rayTrace(world, player)) != null && origin.equals((Object)new BlockPos(mop.func_216347_e())))) {
            return ImmutableList.of();
        }
        BlockPos start = origin;
        switch (Direction.func_210769_a((double)mop.func_216347_e().field_72450_a, (double)mop.func_216347_e().field_72448_b, (double)mop.func_216347_e().field_72449_c)) {
            case DOWN: 
            case UP: {
                Vector3i vec = player.func_174811_aO().func_176730_m();
                x = vec.func_177958_n() * height + vec.func_177952_p() * width;
                y = Direction.func_210769_a((double)mop.func_216347_e().field_72450_a, (double)mop.func_216347_e().field_72448_b, (double)mop.func_216347_e().field_72449_c).func_176743_c().func_179524_a() * -depth;
                z = vec.func_177958_n() * width + vec.func_177952_p() * height;
                start = start.func_177982_a(-x / 2, 0, -z / 2);
                if (x % 2 == 0) {
                    if (x > 0 && mop.func_216347_e().field_72450_a - (double)player.func_233580_cy_().func_177958_n() > 0.5) {
                        start = start.func_177982_a(1, 0, 0);
                    } else if (x < 0 && mop.func_216347_e().field_72450_a - (double)player.func_233580_cy_().func_177958_n() < 0.5) {
                        start = start.func_177982_a(-1, 0, 0);
                    }
                }
                if (z % 2 != 0) break;
                if (z > 0 && mop.func_216347_e().field_72449_c - (double)player.func_233580_cy_().func_177952_p() > 0.5) {
                    start = start.func_177982_a(0, 0, 1);
                    break;
                }
                if (z >= 0 || !(mop.func_216347_e().field_72449_c - (double)player.func_233580_cy_().func_177952_p() < 0.5)) break;
                start = start.func_177982_a(0, 0, -1);
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = width;
                y = height;
                z = Direction.func_210769_a((double)mop.func_216347_e().field_72450_a, (double)mop.func_216347_e().field_72448_b, (double)mop.func_216347_e().field_72449_c).func_176743_c().func_179524_a() * -depth;
                start = start.func_177982_a(-x / 2, -y / 2, 0);
                if (x % 2 == 0 && mop.func_216347_e().field_72450_a - (double)player.func_233580_cy_().func_177958_n() > 0.5) {
                    start = start.func_177982_a(1, 0, 0);
                }
                if (y % 2 != 0 || !(mop.func_216347_e().field_72448_b - (double)player.func_233580_cy_().func_177956_o() > 0.5)) break;
                start = start.func_177982_a(0, 1, 0);
                break;
            }
            case WEST: 
            case EAST: {
                x = Direction.func_210769_a((double)mop.func_216347_e().field_72450_a, (double)mop.func_216347_e().field_72448_b, (double)mop.func_216347_e().field_72449_c).func_176743_c().func_179524_a() * -depth;
                y = height;
                z = width;
                start = start.func_177982_a(0, -y / 2, -z / 2);
                if (y % 2 == 0 && mop.func_216347_e().field_72448_b - (double)player.func_233580_cy_().func_177956_o() > 0.5) {
                    start = start.func_177982_a(0, 1, 0);
                }
                if (z % 2 != 0 || !(mop.func_216347_e().field_72449_c - (double)player.func_233580_cy_().func_177952_p() > 0.5)) break;
                start = start.func_177982_a(0, 0, 1);
                break;
            }
            default: {
                z = 0;
                y = 0;
                x = 0;
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int xp = start.func_177958_n(); xp != start.func_177958_n() + x; xp += x / MathHelper.func_76130_a((int)x)) {
            for (int yp = start.func_177956_o(); yp != start.func_177956_o() + y; yp += y / MathHelper.func_76130_a((int)y)) {
                for (int zp = start.func_177952_p(); zp != start.func_177952_p() + z; zp += z / MathHelper.func_76130_a((int)z)) {
                    if (xp == origin.func_177958_n() && yp == origin.func_177956_o() && zp == origin.func_177952_p() || distance > 0 && MathHelper.func_76130_a((int)(xp - origin.func_177958_n())) + MathHelper.func_76130_a((int)(yp - origin.func_177956_o())) + MathHelper.func_76130_a((int)(zp - origin.func_177952_p())) > distance) continue;
                    builder.add((Object)new BlockPos(xp, yp, zp));
                }
            }
        }
        return builder.build();
    }

    public void onBlockStartBreak(ItemStack stack, World world, Block blockDestroyed, BlockPos pos, PlayerEntity owner) {
        int lvl = 1;
        ImmutableList<BlockPos> poses = DiamondTofuToolHandler.calcAOEBlocks(stack, world, owner, pos, 1 + lvl * 2, 1 + lvl * 2, 2 + lvl);
        for (BlockPos extraPos : poses) {
            this.breakExtraBlock(stack, owner.func_130014_f_(), owner, extraPos, pos);
        }
    }

    private boolean canBreakExtraBlock(ItemStack stack, World world, PlayerEntity player, BlockPos pos, BlockPos refPos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (this.tool.func_150893_a(stack, state) <= 1.0f) {
            return false;
        }
        BlockState refState = world.func_180495_p(refPos);
        float refStrength = refState.func_177230_c().func_180647_a(refState, player, (IBlockReader)world, pos);
        float strength = state.func_177230_c().func_180647_a(refState, player, (IBlockReader)world, pos);
        if (!ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return false;
        }
        if (player.func_184812_l_()) {
            block.func_176208_a(world, pos, state, player);
            if (!world.field_72995_K && player instanceof ServerPlayerEntity && ((ServerPlayerEntity)player).field_71135_a != null) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
            }
            return false;
        }
        return true;
    }

    public void breakExtraBlock(ItemStack stack, World world, PlayerEntity player, BlockPos pos, BlockPos refPos) {
        if (!this.canBreakExtraBlock(stack, world, player, pos, refPos) || world.func_180495_p(pos).func_177230_c() != world.func_180495_p(refPos).func_177230_c()) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        stack.func_179548_a(world, state, pos, player);
        if (!world.field_72995_K && world instanceof ServerWorld) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((ServerPlayerEntity)player).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)player), (BlockPos)pos);
            if (xp == -1) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (block.removedByPlayer(state, world, pos, player, true, state.func_204520_s())) {
                block.func_176208_a(world, pos, state, player);
                block.func_180657_a(world, player, pos, state, tileEntity, stack);
                block.func_180637_b((ServerWorld)world, pos, xp);
            }
            if (((ServerPlayerEntity)player).field_71135_a != null) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
            }
        } else {
            world.func_175669_a(2001, pos, Block.func_196246_j((BlockState)state));
            if (block.removedByPlayer(state, world, pos, player, true, state.func_204520_s())) {
                block.func_176208_a(world, pos, state, player);
            }
            stack.func_179548_a(world, state, pos, player);
            if (stack.func_190916_E() == 0 && stack == player.func_184614_ca()) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)stack, (Hand)Hand.MAIN_HAND);
                player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            }
            ClientPlayNetHandler netHandlerPlayClient = Minecraft.func_71410_x().func_147114_u();
            assert (netHandlerPlayClient != null);
            netHandlerPlayClient.func_147297_a((IPacket)new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK, pos, Direction.DOWN));
        }
    }
}

