/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.world.gen;

import baguchan.mcmod.tofucraft.world.SeedHolder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.MaxMinNoiseMixer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TofuBiomeProvider
extends BiomeProvider {
    private static final Noise DEFAULT_NOISE = new Noise(-7, (List<Double>)ImmutableList.of((Object)1.0, (Object)1.0));
    public static final MapCodec<TofuBiomeProvider> PACKET_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.LONG.fieldOf("seed").orElseGet(SeedHolder::getSeed).forGetter(netherProvider -> netherProvider.seed), (App)RecordCodecBuilder.create(biomeAttributes -> biomeAttributes.group((App)Biome.Attributes.field_235104_a_.fieldOf("parameters").forGetter(Pair::getFirst), (App)Biome.field_235051_b_.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)biomeAttributes, Pair::of)).listOf().fieldOf("biomes").forGetter(netherProvider -> netherProvider.biomeAttributes), (App)Noise.CODEC.fieldOf("temperature_noise").forGetter(netherProvider -> netherProvider.temperatureNoise), (App)Noise.CODEC.fieldOf("humidity_noise").forGetter(netherProvider -> netherProvider.humidityNoise), (App)Noise.CODEC.fieldOf("altitude_noise").forGetter(netherProvider -> netherProvider.altitudeNoise), (App)Noise.CODEC.fieldOf("weirdness_noise").forGetter(netherProvider -> netherProvider.weirdnessNoise)).apply((Applicative)builder, TofuBiomeProvider::new));
    public static final Codec<TofuBiomeProvider> CODEC = Codec.mapEither(DefaultBuilder.CODEC, PACKET_CODEC).xmap(either -> (TofuBiomeProvider)((Object)((Object)either.map(DefaultBuilder::build, Function.identity()))), netherProvider -> netherProvider.getDefaultBuilder().map(Either::left).orElseGet(() -> Either.right((Object)netherProvider))).codec();
    private final Noise temperatureNoise;
    private final Noise humidityNoise;
    private final Noise altitudeNoise;
    private final Noise weirdnessNoise;
    private final MaxMinNoiseMixer temperatureNoiseMixer;
    private final MaxMinNoiseMixer humidityNoiseMixer;
    private final MaxMinNoiseMixer altitudeNoiseMixer;
    private final MaxMinNoiseMixer weirdnessNoiseMixer;
    private final List<Pair<Biome.Attributes, Supplier<Biome>>> biomeAttributes;
    private final boolean useHeightForNoise;
    private final long seed;
    private final Optional<Pair<Registry<Biome>, Preset>> netherProviderPreset;

    private TofuBiomeProvider(long seed, List<Pair<Biome.Attributes, Supplier<Biome>>> biomeAttributes, Optional<Pair<Registry<Biome>, Preset>> netherProviderPreset) {
        this(seed, biomeAttributes, DEFAULT_NOISE, DEFAULT_NOISE, DEFAULT_NOISE, DEFAULT_NOISE, netherProviderPreset);
    }

    private TofuBiomeProvider(long seed, List<Pair<Biome.Attributes, Supplier<Biome>>> biomeAttributes, Noise temperatureNoise, Noise humidityNoise, Noise altitudeNoise, Noise weirdnessNoise) {
        this(seed, biomeAttributes, temperatureNoise, humidityNoise, altitudeNoise, weirdnessNoise, Optional.empty());
    }

    private TofuBiomeProvider(long seed, List<Pair<Biome.Attributes, Supplier<Biome>>> biomeAttributes, Noise temperatureNoise, Noise humidityNoise, Noise altitudeNoise, Noise weirdnessNoise, Optional<Pair<Registry<Biome>, Preset>> netherProviderPreset) {
        super(biomeAttributes.stream().map(Pair::getSecond));
        this.seed = seed;
        this.netherProviderPreset = netherProviderPreset;
        this.temperatureNoise = temperatureNoise;
        this.humidityNoise = humidityNoise;
        this.altitudeNoise = altitudeNoise;
        this.weirdnessNoise = weirdnessNoise;
        this.temperatureNoiseMixer = MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(seed), (int)temperatureNoise.getNumberOfOctaves(), (DoubleList)temperatureNoise.getAmplitudes());
        this.humidityNoiseMixer = MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(seed + 1L), (int)humidityNoise.getNumberOfOctaves(), (DoubleList)humidityNoise.getAmplitudes());
        this.altitudeNoiseMixer = MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(seed + 2L), (int)altitudeNoise.getNumberOfOctaves(), (DoubleList)altitudeNoise.getAmplitudes());
        this.weirdnessNoiseMixer = MaxMinNoiseMixer.func_242930_a((SharedSeedRandom)new SharedSeedRandom(seed + 3L), (int)weirdnessNoise.getNumberOfOctaves(), (DoubleList)weirdnessNoise.getAmplitudes());
        this.biomeAttributes = biomeAttributes;
        this.useHeightForNoise = false;
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BiomeProvider func_230320_a_(long seed) {
        return new TofuBiomeProvider(seed, this.biomeAttributes, this.temperatureNoise, this.humidityNoise, this.altitudeNoise, this.weirdnessNoise, this.netherProviderPreset);
    }

    private Optional<DefaultBuilder> getDefaultBuilder() {
        return this.netherProviderPreset.map(registryPresetPair -> new DefaultBuilder((Preset)registryPresetPair.getSecond(), (Registry)registryPresetPair.getFirst(), this.seed));
    }

    public Biome func_225526_b_(int x, int y, int z) {
        int i = this.useHeightForNoise ? y : 0;
        Biome.Attributes biome$attributes = new Biome.Attributes((float)this.temperatureNoiseMixer.func_237211_a_((double)x, (double)i, (double)z), (float)this.humidityNoiseMixer.func_237211_a_((double)x, (double)i, (double)z), (float)this.altitudeNoiseMixer.func_237211_a_((double)x, (double)i, (double)z), (float)this.weirdnessNoiseMixer.func_237211_a_((double)x, (double)i, (double)z), 0.0f);
        return this.biomeAttributes.stream().min(Comparator.comparing(attributeBiomePair -> Float.valueOf(((Biome.Attributes)attributeBiomePair.getFirst()).func_235110_a_(biome$attributes)))).map(Pair::getSecond).map(Supplier::get).orElse(BiomeRegistry.field_244201_b);
    }

    public boolean isDefaultPreset(long seed) {
        return this.seed == seed && this.netherProviderPreset.isPresent() && Objects.equals(this.netherProviderPreset.get().getSecond(), Preset.DEFAULT_NETHER_PROVIDER_PRESET);
    }

    public static class Preset {
        private static final Map<ResourceLocation, Preset> PRESETS = Maps.newHashMap();
        public static final Preset DEFAULT_NETHER_PROVIDER_PRESET = new Preset(new ResourceLocation("nether"), (Function3<Preset, Registry<Biome>, Long, TofuBiomeProvider>)((Function3)(preset, lookupRegistry, seed) -> new TofuBiomeProvider((long)seed, (List)ImmutableList.of((Object)Pair.of((Object)new Biome.Attributes(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), () -> (Biome)lookupRegistry.func_243576_d(Biomes.field_235254_j_)), (Object)Pair.of((Object)new Biome.Attributes(0.0f, -0.5f, 0.0f, 0.0f, 0.0f), () -> (Biome)lookupRegistry.func_243576_d(Biomes.field_235252_ay_)), (Object)Pair.of((Object)new Biome.Attributes(0.4f, 0.0f, 0.0f, 0.0f, 0.0f), () -> (Biome)lookupRegistry.func_243576_d(Biomes.field_235253_az_)), (Object)Pair.of((Object)new Biome.Attributes(0.0f, 0.5f, 0.0f, 0.0f, 0.375f), () -> (Biome)lookupRegistry.func_243576_d(Biomes.field_235250_aA_)), (Object)Pair.of((Object)new Biome.Attributes(-0.5f, 0.0f, 0.0f, 0.0f, 0.175f), () -> (Biome)lookupRegistry.func_243576_d(Biomes.field_235251_aB_))), Optional.of(Pair.of((Object)lookupRegistry, (Object)preset)))));
        private final ResourceLocation id;
        private final Function3<Preset, Registry<Biome>, Long, TofuBiomeProvider> netherProviderFunction;

        public Preset(ResourceLocation id, Function3<Preset, Registry<Biome>, Long, TofuBiomeProvider> netherProviderFunction) {
            this.id = id;
            this.netherProviderFunction = netherProviderFunction;
            PRESETS.put(id, this);
        }

        public TofuBiomeProvider build(Registry<Biome> lookupRegistry, long seed) {
            return (TofuBiomeProvider)((Object)this.netherProviderFunction.apply((Object)this, lookupRegistry, (Object)seed));
        }
    }

    static class Noise {
        private final int numOctaves;
        private final DoubleList amplitudes;
        public static final Codec<Noise> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("firstOctave").forGetter(Noise::getNumberOfOctaves), (App)Codec.DOUBLE.listOf().fieldOf("amplitudes").forGetter(Noise::getAmplitudes)).apply((Applicative)builder, Noise::new));

        public Noise(int numOctaves, List<Double> amplitudes) {
            this.numOctaves = numOctaves;
            this.amplitudes = new DoubleArrayList(amplitudes);
        }

        public int getNumberOfOctaves() {
            return this.numOctaves;
        }

        public DoubleList getAmplitudes() {
            return this.amplitudes;
        }
    }

    static final class DefaultBuilder {
        public static final MapCodec<DefaultBuilder> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.field_240908_a_.flatXmap(id -> Optional.ofNullable(Preset.PRESETS.get(id)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown preset: " + id))), preset -> DataResult.success((Object)((Preset)preset).id)).fieldOf("preset").stable().forGetter(DefaultBuilder::getPreset), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(DefaultBuilder::getLookupRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(DefaultBuilder::getSeed)).apply((Applicative)builder, builder.stable(DefaultBuilder::new)));
        private final Preset preset;
        private final Registry<Biome> lookupRegistry;
        private final long seed;

        private DefaultBuilder(Preset preset, Registry<Biome> lookupRegistry, long seed) {
            this.preset = preset;
            this.lookupRegistry = lookupRegistry;
            this.seed = seed;
        }

        public Preset getPreset() {
            return this.preset;
        }

        public Registry<Biome> getLookupRegistry() {
            return this.lookupRegistry;
        }

        public long getSeed() {
            return this.seed;
        }

        public TofuBiomeProvider build() {
            return this.preset.build(this.lookupRegistry, this.seed);
        }
    }
}

