/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.world.gen.feature;

import baguchan.mcmod.tofucraft.init.TofuBlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class TofuBerryFeature
extends Feature<NoFeatureConfig> {
    private static final Direction[] directionArray = Direction.values();
    private static final BlockState BERRYBASE = TofuBlocks.TOFUBERRYSTEM.func_176223_P();
    private static final BlockState BERRY = TofuBlocks.TOFUBERRY.func_176223_P();

    public TofuBerryFeature(Codec<NoFeatureConfig> p_i49919_1_) {
        super(p_i49919_1_);
    }

    public boolean generate(ISeedReader seedReader, ChunkGenerator chunkGenerator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!seedReader.func_175623_d(pos)) {
            return false;
        }
        BlockState blockstate = seedReader.func_180495_p(pos.func_177984_a());
        if (!blockstate.func_203425_a(TofuBlocks.TOFUTERRAIN) && !blockstate.func_203425_a(TofuBlocks.ZUNDATOFUTERRAIN)) {
            return false;
        }
        this.movePostion((IWorld)seedReader, rand, pos);
        this.setBerryAndStem((IWorld)seedReader, rand, pos);
        return true;
    }

    private void movePostion(IWorld world, Random rand, BlockPos pos) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        BlockPos.Mutable blockpos$mutable1 = new BlockPos.Mutable();
        block0: for (int i = 0; i < 200; ++i) {
            blockpos$mutable.func_239621_a_((Vector3i)pos, rand.nextInt(6) - rand.nextInt(6), rand.nextInt(2) - rand.nextInt(5), rand.nextInt(6) - rand.nextInt(6));
            if (!world.func_175623_d((BlockPos)blockpos$mutable)) continue;
            int j = 0;
            for (Direction direction : directionArray) {
                BlockState blockstate = world.func_180495_p((BlockPos)blockpos$mutable1.func_239622_a_((Vector3i)blockpos$mutable, direction));
                if (blockstate.func_203425_a(TofuBlocks.TOFUTERRAIN) || blockstate.func_203425_a(TofuBlocks.ZUNDATOFUTERRAIN)) {
                    ++j;
                }
                if (j > 1) continue block0;
            }
        }
    }

    private void setBerryAndStem(IWorld world, Random rand, BlockPos pos) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i < 100; ++i) {
            BlockState blockstate;
            blockpos$mutable.func_239621_a_((Vector3i)pos, rand.nextInt(8) - rand.nextInt(8), rand.nextInt(2) - rand.nextInt(7), rand.nextInt(8) - rand.nextInt(8));
            if (!world.func_175623_d((BlockPos)blockpos$mutable) || !(blockstate = world.func_180495_p(blockpos$mutable.func_177984_a())).func_203425_a(TofuBlocks.TOFUTERRAIN) && !blockstate.func_203425_a(TofuBlocks.ZUNDATOFUTERRAIN)) continue;
            int j = MathHelper.func_76136_a((Random)rand, (int)1, (int)8);
            if (rand.nextInt(6) == 0) {
                j *= 2;
            }
            if (rand.nextInt(5) == 0) {
                j = 1;
            }
            TofuBerryFeature.placeDropvine(world, rand, blockpos$mutable, j * 4, 17, 25);
        }
    }

    public static void placeDropvine(IWorld world, Random rand, BlockPos.Mutable posMutable, int x, int y, int z) {
        for (int i = 0; i <= x; ++i) {
            if (world.func_175623_d((BlockPos)posMutable)) {
                if (i == x || !world.func_175623_d(posMutable.func_177977_b())) {
                    world.func_180501_a((BlockPos)posMutable, TofuBlocks.TOFUBERRY.func_176223_P(), 2);
                    break;
                }
                world.func_180501_a((BlockPos)posMutable, TofuBlocks.TOFUBERRYSTEM.func_176223_P(), 2);
            }
            posMutable.func_189536_c(Direction.DOWN);
        }
    }
}

