/*
 * Decompiled with CFR 0.152.
 */
package baguchan.mcmod.tofucraft.world.gen.feature.structure;

import baguchan.mcmod.tofucraft.block.TofuChestBlock;
import baguchan.mcmod.tofucraft.entity.TofuGandlemEntity;
import baguchan.mcmod.tofucraft.entity.TofuMindEntity;
import baguchan.mcmod.tofucraft.entity.TofuTurretEntity;
import baguchan.mcmod.tofucraft.init.TofuBlocks;
import baguchan.mcmod.tofucraft.init.TofuEntitys;
import baguchan.mcmod.tofucraft.init.TofuLootTables;
import baguchan.mcmod.tofucraft.tileentity.TofuChestTileEntity;
import baguchan.mcmod.tofucraft.world.gen.feature.structure.TofuStructurePieceType;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class TofuCastlePieces {
    private static final ResourceLocation tofucastle_roof = new ResourceLocation("tofucraft", "tofucastle/tofucastle_roof");
    private static final ResourceLocation tofucastle_main = new ResourceLocation("tofucraft", "tofucastle/tofucastle_main");
    private static final ResourceLocation tofucastle_under = new ResourceLocation("tofucraft", "tofucastle/tofucastle_undermain");
    private static final Map<ResourceLocation, BlockPos> structurePos = ImmutableMap.of((Object)tofucastle_main, (Object)BlockPos.field_177992_a, (Object)tofucastle_under, (Object)new BlockPos(0, -19, 0), (Object)tofucastle_roof, (Object)new BlockPos(0, 19, 0));

    public static void addStructure(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> list, Random p_207617_4_, Biome biome) {
        TofuCastlePieces.addGenerate(list, new Piece(templateManager, tofucastle_main, pos, rotation, 0));
        TofuCastlePieces.addGenerate(list, new Piece(templateManager, tofucastle_roof, pos, rotation, 0));
        TofuCastlePieces.addGenerate(list, new Piece(templateManager, tofucastle_under, pos, rotation, 0));
    }

    private static Piece addGenerate(List<StructurePiece> p_189935_0_, Piece p_189935_1_) {
        p_189935_0_.add((StructurePiece)p_189935_1_);
        return p_189935_1_;
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation field_207615_d;
        private final Rotation field_207616_e;

        public Piece(TemplateManager p_i49313_1_, ResourceLocation p_i49313_2_, BlockPos p_i49313_3_, Rotation p_i49313_4_, int p_i49313_5_) {
            super(TofuStructurePieceType.TOFUCASTLE_PIECE, 0);
            this.field_207615_d = p_i49313_2_;
            BlockPos blockpos = (BlockPos)structurePos.get(p_i49313_2_);
            this.field_186178_c = p_i49313_3_.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o() - p_i49313_5_, blockpos.func_177952_p());
            this.field_207616_e = p_i49313_4_;
            this.func_207614_a(p_i49313_1_);
        }

        public Piece(TemplateManager p_i50566_1_, CompoundNBT p_i50566_2_) {
            super(TofuStructurePieceType.TOFUCASTLE_PIECE, p_i50566_2_);
            this.field_207615_d = new ResourceLocation(p_i50566_2_.func_74779_i("Template"));
            this.field_207616_e = Rotation.valueOf((String)p_i50566_2_.func_74779_i("Rot"));
            this.func_207614_a(p_i50566_1_);
        }

        private void func_207614_a(TemplateManager p_207614_1_) {
            Template template = p_207614_1_.func_200220_a(this.field_207615_d);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_207616_e).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)structurePos.get(this.field_207615_d)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.field_207615_d.toString());
            tagCompound.func_74778_a("Rot", this.field_207616_e.name());
        }

        public boolean func_230383_a_(ISeedReader worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_207616_e).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)structurePos.get(this.field_207615_d)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            BlockPos blockpos = (BlockPos)structurePos.get(this.field_207615_d);
            BlockPos blockpos1 = this.field_186178_c;
            int i = worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, blockpos1.func_177958_n(), blockpos1.func_177952_p());
            BlockPos blockpos2 = this.field_186178_c;
            this.field_186178_c = this.field_186178_c.func_177982_a(0, i - 90 - 1, 0);
            boolean flag = super.func_230383_a_(worldIn, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
            this.field_186178_c = blockpos2;
            return flag;
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox sbb) {
            if (function.equals("Chest")) {
                if (sbb.func_175898_b((Vector3i)pos)) {
                    world.func_180501_a(pos, (BlockState)TofuBlocks.TOFUCHEST.func_176223_P().func_206870_a((Property)TofuChestBlock.field_176459_a, (Comparable)Direction.WEST), 2);
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof TofuChestTileEntity) {
                        ((TofuChestTileEntity)tileEntity).func_189404_a(TofuLootTables.tofucastle_normal, rand.nextLong());
                    }
                }
            } else if (function.equals("Turret")) {
                TofuTurretEntity entityturret = (TofuTurretEntity)TofuEntitys.TOFUTURRET.func_200721_a((World)world.func_201672_e());
                entityturret.func_110163_bv();
                entityturret.func_174828_a(pos, 0.0f, 0.0f);
                world.func_217376_c((Entity)entityturret);
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("MindCore")) {
                TofuMindEntity entitymind = (TofuMindEntity)TofuEntitys.TOFUMIND.func_200721_a((World)world.func_201672_e());
                entitymind.func_110163_bv();
                entitymind.func_174828_a(pos, 0.0f, 0.0f);
                entitymind.func_213386_a(world, world.func_175649_E(new BlockPos(entitymind.func_213303_ch())), SpawnReason.STRUCTURE, null, null);
                world.func_217376_c((Entity)entitymind);
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("Boss")) {
                TofuGandlemEntity entitygandlem = (TofuGandlemEntity)TofuEntitys.TOFUGANDLEM.func_200721_a((World)world.func_201672_e());
                entitygandlem.func_110163_bv();
                entitygandlem.setSleep(true);
                entitygandlem.func_174828_a(pos, 0.0f, 0.0f);
                entitygandlem.func_213386_a(world, world.func_175649_E(new BlockPos(entitygandlem.func_213303_ch())), SpawnReason.STRUCTURE, null, null);
                world.func_217376_c((Entity)entitygandlem);
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }
    }
}

