/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block;

import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import stepsword.mahoutsukai.block.BlockBase;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.util.Utils;

public class BlackFireBlock
extends BlockBase {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)15);
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty UPPER = BooleanProperty.m_61465_((String)"up");
    public static final Random RNG = new Random();
    private static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)PipeBlock.f_55154_.entrySet().stream().filter(facingProperty -> facingProperty.getKey() != Direction.DOWN).collect(Util.m_137448_());

    protected BlackFireBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76309_).m_60910_().m_222994_().m_60977_().m_60978_(0.0f).m_60953_(state -> 15).m_60918_(SoundType.f_56745_), "black_fire");
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UPPER, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, LevelAccessor worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public int tickRate(Level worldIn) {
        return 30;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, Level worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.canSurvive(stateIn, (LevelAccessor)worldIn, currentPos) ? (BlockState)this.getStateForPlacement((LevelAccessor)worldIn, currentPos).m_61124_((Property)AGE, (Comparable)((Integer)stateIn.m_61143_((Property)AGE))) : Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getStateForPlacement((LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState getStateForPlacement(LevelAccessor blockReader, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = blockReader.m_8055_(blockpos);
        if (!this.canCatchFire(blockReader, pos, Direction.UP) && !Block.m_49936_((BlockGetter)blockReader, (BlockPos)blockpos)) {
            BlockState blockstate1 = this.m_49966_();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire(blockReader, pos.m_121945_(direction), direction.m_122424_())));
            }
            return blockstate1;
        }
        return this.m_49966_();
    }

    public boolean canSurvive(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return worldIn.m_8055_(blockpos).m_60783_((BlockGetter)worldIn, blockpos, Direction.UP) || this.areNeighborsFlammable(worldIn, pos);
    }

    public int tickRate(LevelAccessor worldIn) {
        return 5;
    }

    private boolean areNeighborsFlammable(LevelAccessor worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(worldIn, pos.m_121945_(direction), direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(LevelAccessor worldIn, BlockPos pos) {
        if (!worldIn.m_46859_(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = worldIn.m_8055_(pos.m_121945_(direction));
            i = Math.max(blockstate.getFlammability((BlockGetter)worldIn, pos.m_121945_(direction), direction.m_122424_()), i);
        }
        return i;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, NORTH, EAST, SOUTH, WEST, UPPER});
    }

    public void m_213898_(BlockState state, ServerLevel p_60552_, BlockPos p_60553_, RandomSource p_60554_) {
        int i = (Integer)state.m_61143_((Property)AGE);
        state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
        super.m_213898_(state, p_60552_, p_60553_, p_60554_);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (worldIn != null && (worldIn.m_46471_() || worldIn.m_6106_().m_6533_())) {
            worldIn.m_7471_(pos, false);
        }
        if (ServerHandler.tickCounter % (long)MTConfig.BLACK_FLAME_UPDATE_TICKS != 0L) {
            return;
        }
        if (worldIn.m_46469_().m_46207_(GameRules.f_46131_)) {
            if (!worldIn.isAreaLoaded(pos, 2)) {
                return;
            }
            if (!this.canPlaceBlockAt((Level)worldIn, pos)) {
                worldIn.m_7471_(pos, false);
            }
            Block block = worldIn.m_8055_(pos.m_7495_()).m_60734_();
            if (Utils.isBlockAir((Level)worldIn, pos.m_7495_()) || block == ModBlocks.blackFireBlock.get()) {
                worldIn.m_7471_(pos, false);
                return;
            }
            int i = (Integer)state.m_61143_((Property)AGE);
            state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            if (i >= MTConfig.BLACK_FLAME_DEATH_AGE && worldIn.m_8055_(pos.m_7495_()).m_60734_() != Blocks.f_50134_) {
                worldIn.m_7471_(pos, false);
                return;
            }
            if (this.canDie((Level)worldIn, pos)) {
                worldIn.m_7471_(pos, false);
            } else {
                if (i < 15) {
                    state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
                    worldIn.m_7731_(pos, state, 4);
                }
                if (!this.canNeighborCatchFire((Level)worldIn, pos)) {
                    if (!worldIn.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)worldIn, pos.m_7495_(), Direction.UP) || i > 3) {
                        worldIn.m_7471_(pos, false);
                    }
                    return;
                }
                if (!this.canCatchFire((LevelAccessor)worldIn, pos.m_7495_(), Direction.UP) && i == 15 && rand.m_188503_(4) == 0) {
                    worldIn.m_7471_(pos, false);
                    return;
                }
                int j = 0;
                this.tryCatchFire((Level)worldIn, pos.m_122029_(), 300 + j, rand, i, Direction.WEST);
                this.tryCatchFire((Level)worldIn, pos.m_122024_(), 300 + j, rand, i, Direction.EAST);
                this.tryCatchFire((Level)worldIn, pos.m_7494_(), 250 + j, rand, i, Direction.DOWN);
                this.tryCatchFire((Level)worldIn, pos.m_122012_(), 300 + j, rand, i, Direction.SOUTH);
                this.tryCatchFire((Level)worldIn, pos.m_122019_(), 300 + j, rand, i, Direction.NORTH);
            }
        } else {
            worldIn.m_7471_(pos, false);
        }
    }

    protected boolean canDie(Level worldIn, BlockPos pos) {
        return worldIn.m_46471_();
    }

    public boolean requiresUpdates() {
        return false;
    }

    @Deprecated
    public int getFlammability(Block blockIn) {
        return 50 + RNG.nextInt(20);
    }

    @Deprecated
    public int getEncouragement(Block blockIn) {
        return 50 + RNG.nextInt(20);
    }

    @Deprecated
    private void catchOnFire(Level worldIn, BlockPos pos, int chance, RandomSource random, int age) {
        this.tryCatchFire(worldIn, pos, chance, random, age, Direction.UP);
    }

    private void tryCatchFire(Level worldIn, BlockPos pos, int chance, RandomSource random, int age, Direction face) {
    }

    private boolean canNeighborCatchFire(Level worldIn, BlockPos pos) {
        for (Direction enumfacing : Direction.values()) {
            if (!this.canCatchFire((LevelAccessor)worldIn, pos.m_121945_(enumfacing), enumfacing.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(Level worldIn, BlockPos pos) {
        if (!worldIn.m_46859_(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction enumfacing : Direction.values()) {
            i = Math.max(this.getEncouragement(worldIn.m_8055_(pos.m_121945_(enumfacing)).m_60734_()), i);
        }
        return i;
    }

    @Deprecated
    public boolean canCatchFire(LevelAccessor worldIn, BlockPos pos) {
        return this.canCatchFire(worldIn, pos, Direction.UP);
    }

    public boolean canPlaceBlockAt(Level worldIn, BlockPos pos) {
        return this.canNeighborCatchFire(worldIn, pos);
    }

    public boolean canCatchFire(LevelAccessor world, BlockPos pos, Direction face) {
        Block b = world.m_8055_(pos).m_60734_();
        BlockEntity te = world.m_7702_(pos);
        return te == null && b != ModBlocks.invisibleBarrierBlock.get() && b != Blocks.f_50752_ && b != Blocks.f_50016_ && b != Blocks.f_50126_ && b != Blocks.f_50125_ && b != Blocks.f_49990_ && b != Blocks.f_49991_ && b != Blocks.f_50627_ && b != Blocks.f_50626_;
    }
}

