/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ChunkEvent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.fluids.MurkyWaterBlock;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.item.spells.projection.PowerConsolidation.Caliburn;
import stepsword.mahoutsukai.networking.ChunkMahouRequestPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.SweepAttackPacket;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class PowerConsolidationSpellEffect {
    public static void powerConsolidationWorldTick(final TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.level.f_46443_ && ServerHandler.tickCounter % (long)MTConfig.POWER_CONSOLIDATION_LAKE_CYCLE == 0L) {
            try {
                final int manaCost = MTConfig.POWER_CONSOLIDATION_SWORD_MANA_COST;
                Iterator iter = ((ServerLevel)event.level).m_142646_().m_142273_().iterator();
                double nerfFactor = MTConfig.POWER_CONSOLIDATION_NERF_FACTOR;
                final ArrayList<ItemEntity> toDelete = new ArrayList<ItemEntity>();
                final ArrayList<WeaponProjectileEntity> toSpawn = new ArrayList<WeaponProjectileEntity>();
                while (iter.hasNext()) {
                    Entity e = (Entity)iter.next();
                    if (!(e instanceof ItemEntity)) continue;
                    ItemEntity item = (ItemEntity)e;
                    if (item.m_32055_().m_41720_() instanceof SwordItem && PowerConsolidationSpellEffect.isItemAllowed(item.m_32055_())) {
                        boolean z = Utils.isInMurkyWater(e);
                        if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                            System.out.println("Allowed sword found. Is in murky water: " + z);
                        }
                        if (z) {
                            Player player;
                            if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                                System.out.println("Sword is enchanted:" + item.m_32055_().m_41793_());
                            }
                            if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                                System.out.println("ThrowerID:" + item.m_32057_());
                            }
                            if (item.m_32055_().m_41793_() && item.m_32057_() != null && (player = event.level.m_46003_(item.m_32057_())) != null) {
                                ConcurrentSet connected = new ConcurrentSet();
                                boolean lt = PowerConsolidationSpellEffect.lakeThreshhold(item.m_20183_(), (ConcurrentSet<BlockPos>)connected, event.level);
                                if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                                    System.out.println("Lake Threshhold:" + lt);
                                }
                                if (lt && PlayerManaManager.hasMana(player, manaCost)) {
                                    ItemStack stack;
                                    ICaliburnMahou mahou;
                                    BlockPos p = PowerConsolidationSpellEffect.findCenter((ConcurrentSet<BlockPos>)connected);
                                    if (!Utils.isBlockAir(event.level, p)) {
                                        p = p.m_7495_();
                                    }
                                    if ((mahou = Utils.getCaliburnMahou(stack = new ItemStack((ItemLike)ModItems.caliburn.get()))) != null) {
                                        double lb = PowerConsolidationSpellEffect.getLimitBreakInArea(item);
                                        if (item.m_32055_().m_41720_() instanceof Caliburn) {
                                            ICaliburnMahou orig = Utils.getCaliburnMahou(item.m_32055_());
                                            if (orig != null) {
                                                lb = Math.max(orig.getInnateCap(), lb);
                                            }
                                            if (item.m_32055_().m_41788_()) {
                                                Component name = item.m_32055_().m_41786_();
                                                stack.m_41714_(name);
                                            }
                                        }
                                        mahou.setInnateCap(lb);
                                        float damage = Caliburn.simulateHit(item.m_32055_(), event.level);
                                        ItemStack stackCopy = item.m_32055_().m_41777_();
                                        ListTag tagList = stackCopy.m_41785_();
                                        tagList.clear();
                                        float damageWithoutEnchant = Caliburn.simulateHit(stackCopy, event.level);
                                        damage = (float)((double)damage - nerfFactor * (double)(damage - damageWithoutEnchant));
                                        mahou.setAttackDamage(Math.min((float)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, damage -= 1.0f));
                                        Caliburn.setattacktonbt(stack, event.level);
                                    }
                                    if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                                        System.out.println("Advancement Time");
                                    }
                                    ModTriggers.SWORD_IN_THE_LAKE.trigger((ServerPlayer)player);
                                    WeaponProjectileEntity wpe = new WeaponProjectileEntity(event.level, p.m_123341_(), p.m_123342_(), p.m_123343_(), stack);
                                    wpe.m_20334_(0.0, -1.0, 0.0);
                                    wpe.m_5602_((Entity)player);
                                    toSpawn.add(wpe);
                                    toDelete.add(item);
                                }
                            }
                        }
                    }
                    MahouTsukaiMod.jousting.powerConsolidation(event, item, toDelete, toSpawn);
                }
                ((ServerLevel)event.level).m_7654_().execute(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < toDelete.size(); ++i) {
                            ItemEntity e = (ItemEntity)toDelete.get(i);
                            if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                                System.out.println("Item alive:" + e.m_6084_() + "... Thrower:" + e.m_32057_());
                            }
                            if (!e.m_6084_() || e.m_32057_() == null || i >= toSpawn.size() || PlayerManaManager.drainMana(event.level.m_46003_(e.m_32057_()), manaCost, false, false) != manaCost) continue;
                            if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                                System.out.println("Mana charged and item spawning.");
                            }
                            event.level.m_7967_((Entity)toSpawn.get(i));
                            e.m_146870_();
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static double getLimitBreakInArea(ItemEntity entity) {
        Vec3 vec = entity.m_20182_();
        int radius = 10;
        AABB aabb = new AABB(vec.f_82479_ - (double)radius, vec.f_82480_ - (double)radius, vec.f_82481_ - (double)radius, vec.f_82479_ + (double)radius, vec.f_82480_ + (double)radius, vec.f_82481_ + (double)radius);
        int limit_breaks = 0;
        List entities = entity.f_19853_.m_45976_(ItemEntity.class, aabb);
        for (ItemEntity e : entities) {
            if (!EffectUtil.inItemBlacklist(e.m_32055_().m_41720_(), MTConfig.POWER_CONSOLIDATION_TIER_UPGRADE_ITEM)) continue;
            limit_breaks += e.m_32055_().m_41613_();
            e.m_146870_();
        }
        double ret = MTConfig.POWER_CONSOLIDATION_ATTACK_CAP;
        if (MTConfig.POWER_CONSOLIDATION_TIERS.size() > 0) {
            ret = MTConfig.POWER_CONSOLIDATION_TIERS.get(0);
            if (limit_breaks > 0) {
                ret = MTConfig.POWER_CONSOLIDATION_TIERS.get(Math.min(MTConfig.POWER_CONSOLIDATION_TIERS.size() - 1, limit_breaks));
            }
        }
        return ret;
    }

    public static boolean isItemAllowed(ItemStack s) {
        boolean blacklist = MTConfig.POWER_CONSOLIDATION_CALIBURN_BLACKLIST_TOGGLE;
        ArrayList list = (ArrayList)MTConfig.POWER_CONSOLIDATION_BLACKLIST;
        boolean match = false;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || s == null || Utils.getRegistryKey(s.m_41720_()) == null || !((String)list.get(i)).equals(Utils.getRegistryName(s.m_41720_()))) continue;
            match = true;
            break;
        }
        if (match && blacklist) {
            return false;
        }
        if (match && !blacklist) {
            return true;
        }
        return !match && blacklist;
    }

    public static BlockPos findCenter(ConcurrentSet<BlockPos> connected) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (BlockPos p : connected) {
            if (p.m_123341_() < minX) {
                minX = p.m_123341_();
            }
            if (p.m_123341_() > maxX) {
                maxX = p.m_123341_();
            }
            if (p.m_123343_() < minZ) {
                minZ = p.m_123343_();
            }
            if (p.m_123343_() > maxZ) {
                maxZ = p.m_123343_();
            }
            if (p.m_123342_() <= maxY) continue;
            maxY = p.m_123342_();
        }
        return new BlockPos(PowerConsolidationSpellEffect.average(maxX, minX), maxY + 1, PowerConsolidationSpellEffect.average(maxZ, minZ));
    }

    public static int average(int a, int b) {
        return (a + b) / 2;
    }

    public static boolean lakeThreshhold(BlockPos p, ConcurrentSet<BlockPos> connected, Level world) {
        int threshhold = MTConfig.POWER_CONSOLIDATION_LAKE_THRESHHOLD;
        if (connected.size() > threshhold) {
            return true;
        }
        if (connected.contains((Object)p)) {
            return false;
        }
        boolean ret = false;
        if (world != null) {
            if (world.m_8055_(p).m_60734_() instanceof MurkyWaterBlock) {
                connected.add((Object)p);
            }
            if (world.m_8055_(p.m_7494_()).m_60734_() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.m_7494_(), connected, world))) {
                return true;
            }
            if (world.m_8055_(p.m_7495_()).m_60734_() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.m_7495_(), connected, world))) {
                return true;
            }
            if (world.m_8055_(p.m_122019_()).m_60734_() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.m_122019_(), connected, world))) {
                return true;
            }
            if (world.m_8055_(p.m_122024_()).m_60734_() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.m_122024_(), connected, world))) {
                return true;
            }
            if (world.m_8055_(p.m_122029_()).m_60734_() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.m_122029_(), connected, world))) {
                return true;
            }
            if (world.m_8055_(p.m_122012_()).m_60734_() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.m_122012_(), connected, world))) {
                return true;
            }
        }
        return ret;
    }

    public static void caliburnLeftClickSpace(PlayerInteractEvent.LeftClickEmpty event) {
        PowerConsolidationSpellEffect.sweepAttack((PlayerInteractEvent)event);
    }

    public static void caliburnLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        PowerConsolidationSpellEffect.sweepAttack((PlayerInteractEvent)event);
    }

    public static void sweepAttack(PlayerInteractEvent event) {
        Player player = event.getEntity();
        if (player.f_19853_.f_46443_ && (player.m_21205_().m_41720_() instanceof Caliburn || player.m_21205_().m_41720_() instanceof Morgan)) {
            int r = MTConfig.POWER_CONSOLIDATION_SWEEP_RADIUS;
            int r2 = MTConfig.POWER_CONSOLIDATION_SWEEP_LOOK_RADIUS;
            Vec3 p = player.m_20182_();
            AABB aabb = new AABB(p.m_82520_((double)(-r), (double)(-r), (double)(-r)), p.m_82520_((double)r, (double)r, (double)r));
            List lst = player.f_19853_.m_45976_(LivingEntity.class, aabb);
            for (LivingEntity e : lst) {
                if (e.m_20148_().equals(player.m_20148_()) || !EffectUtil.isLookingAtMe(e, (LivingEntity)player) || !(Math.abs(EffectUtil.pointToLineDistance(e.m_20182_(), player.m_20299_(1.0f), player.m_20154_().m_82549_(player.m_20299_(1.0f)))) < (double)r2)) continue;
                PacketHandler.sendToServer(new SweepAttackPacket((Entity)e));
            }
        }
    }

    public static void powerConsolidationChunkLoad(ChunkEvent.Load event) {
        if (event.getChunk() instanceof LevelChunk) {
            IChunkMahou mahou;
            LevelChunk c = (LevelChunk)event.getChunk();
            if (event.getLevel().m_5776_()) {
                PacketHandler.sendToServer(new ChunkMahouRequestPacket(c.m_7697_().f_45578_, c.m_7697_().f_45579_));
            } else if (MTConfig.POWER_CONSOLIDATION_RETRO_FOG_FIX && (mahou = Utils.getChunkMahou(c)) != null && mahou.needsRetroFixLake()) {
                ConcurrentSet<BlockPos> lakeBlocks = mahou.getLakeBlocks();
                for (int i = c.m_7697_().m_45604_(); i <= c.m_7697_().m_45608_(); ++i) {
                    for (int j = c.m_7697_().m_45605_(); j <= c.m_7697_().m_45609_(); ++j) {
                        for (int y = 0; y < c.m_62953_().m_151558_(); ++y) {
                            BlockPos p = new BlockPos(i, y, j);
                            if (c.m_8055_(p).m_60734_() != ModBlocks.murkyFluid.get()) continue;
                            lakeBlocks.add((Object)p);
                        }
                    }
                }
                mahou.setNeedsRetroFixLake(false);
            }
        }
    }
}

