/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.util.EffectUtil;

public class StrengtheningSpellEffect {
    public static final String STRENGTHENED_TAG = "mahoutsukai_strengthened";
    public static final String UNBREAKABLE_TAG = "mahoutsukai_old_unbreakable";
    public static final int STRENGTHENED_USES = 5;
    public static final float STRENGTHENED_DAMAGE_BUFF = 4.0f;

    public static void strengtheningLivingHurt(LivingHurtEvent event) {
        EntityDamageSource entityDamageSource;
        Entity trueSource;
        DamageSource source = event.getSource();
        ItemStack weapon = null;
        if (source.f_19326_ != "arrow" && source.f_19326_ == "player" && source instanceof EntityDamageSource && (trueSource = (entityDamageSource = (EntityDamageSource)source).m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)trueSource;
            weapon = attacker.m_21205_();
        }
        if (weapon != null && StrengtheningSpellEffect.getStrengthened(weapon) > 0) {
            event.setAmount(event.getAmount() + 4.0f);
            StrengtheningSpellEffect.reduceStrengthened(weapon, 1);
        }
    }

    public static void strengtheningUseEvent(LivingEntityUseItemEvent.Stop event) {
        if (StrengtheningSpellEffect.getStrengthened(event.getItem()) > 0) {
            StrengtheningSpellEffect.reduceStrengthened(event.getItem(), 1);
        }
    }

    public static void strengtheningHarvestCheck(PlayerEvent.HarvestCheck event) {
        ItemStack s;
        Player player = event.getEntity();
        if (player != null && StrengtheningSpellEffect.getStrengthened(s = player.m_21205_()) > 0) {
            ItemStack woodPickaxe = new ItemStack((ItemLike)Items.f_42422_);
            boolean wood = woodPickaxe.m_41735_(event.getTargetBlock());
            if (s.m_41720_() instanceof PickaxeItem) {
                Tier tier = ((PickaxeItem)s.m_41720_()).m_43314_();
                if (TierSortingRegistry.isTierSorted((Tier)tier)) {
                    Tier newTier;
                    int k = TierSortingRegistry.getSortedTiers().indexOf(tier);
                    if (tier.getTag() == Tags.Blocks.NEEDS_WOOD_TOOL) {
                        ++k;
                    }
                    if (k + 1 < TierSortingRegistry.getSortedTiers().size() && TierSortingRegistry.isCorrectTierForDrops((Tier)(newTier = (Tier)TierSortingRegistry.getSortedTiers().get(k + 1)), (BlockState)event.getTargetBlock())) {
                        event.setCanHarvest(true);
                    }
                }
            } else if (wood) {
                event.setCanHarvest(true);
            }
        }
    }

    public static void strengtheningArmorEvent(LivingAttackEvent event) {
        LivingEntity living = event.getEntity();
        Iterable armors = living.m_6168_();
        for (ItemStack s : armors) {
            if (StrengtheningSpellEffect.getStrengthened(s) <= 0) continue;
            StrengtheningSpellEffect.reduceStrengthened(s, 1);
        }
    }

    public static void strengtheningBreakEvent(BlockEvent.BreakEvent event) {
        Player player;
        if (!event.getPlayer().f_19853_.f_46443_ && (player = event.getPlayer()) != null) {
            ItemStack s = player.m_21205_();
            BlockState b = event.getState();
            if (StrengtheningSpellEffect.getStrengthened(s) > 0 && s.m_41720_() instanceof DiggerItem) {
                StrengtheningSpellEffect.reduceStrengthened(s, 1);
            } else if (StrengtheningSpellEffect.getStrengthened(s) > 0) {
                StrengtheningSpellEffect.reduceStrengthened(s, 1);
            }
        }
    }

    public static void strengtheningBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack s;
        Player player = event.getEntity();
        if (player != null && StrengtheningSpellEffect.getStrengthened(s = player.m_21205_()) > 0) {
            event.setNewSpeed(event.getNewSpeed() + 3.0f);
        }
    }

    public static void reduceStrengthened(ItemStack stack, int reduce) {
        CompoundTag nbt;
        if (stack != null && !stack.m_41619_() && stack.m_41782_() && (nbt = stack.m_41783_()) != null && nbt.m_128441_(STRENGTHENED_TAG)) {
            nbt.m_128405_(STRENGTHENED_TAG, nbt.m_128451_(STRENGTHENED_TAG) - reduce);
            if (nbt.m_128451_(STRENGTHENED_TAG) <= 0) {
                if (nbt.m_128441_(UNBREAKABLE_TAG)) {
                    nbt.m_128379_("Unbreakable", nbt.m_128471_(UNBREAKABLE_TAG));
                } else if (!nbt.m_128441_("Unbreakable")) {
                    nbt.m_128379_(UNBREAKABLE_TAG, false);
                }
            }
        }
    }

    public static void setStrengthened(ItemStack stack, Level world) {
        if (!(world.f_46443_ || stack == null || stack.m_41619_() || EffectUtil.inItemBlacklist(stack.m_41720_(), MTConfig.STRENGTHENING_ITEM_BLACKLIST))) {
            CompoundTag nbt = stack.m_41783_();
            int alreadyStrengthened = 0;
            if (nbt == null) {
                nbt = new CompoundTag();
            } else {
                alreadyStrengthened = StrengtheningSpellEffect.getStrengthened(stack);
            }
            if (alreadyStrengthened == 0 && nbt.m_128441_("Unbreakable")) {
                nbt.m_128379_(UNBREAKABLE_TAG, nbt.m_128471_("Unbreakable"));
            } else {
                nbt.m_128379_(UNBREAKABLE_TAG, false);
            }
            nbt.m_128379_("Unbreakable", true);
            nbt.m_128405_(STRENGTHENED_TAG, Math.min(MTConfig.STRENGTHENING_CAP, alreadyStrengthened + 5));
            stack.m_41751_(nbt);
        }
    }

    public static int getStrengthened(ItemStack stack) {
        CompoundTag nbt;
        if (stack != null && !stack.m_41619_() && (nbt = stack.m_41783_()) != null && nbt.m_128441_(STRENGTHENED_TAG)) {
            return nbt.m_128451_(STRENGTHENED_TAG);
        }
        return 0;
    }

    public static ItemStack findStackToStrengthen(Player p) {
        ItemStack stack = null;
        if (p != null && ((stack = p.m_21206_()) == null || stack.m_41619_())) {
            for (int i = 0; i < 10 && ((stack = p.m_150109_().m_8020_(i)) == null || stack.m_41619_() || stack.m_41720_() instanceof SpellScroll); ++i) {
            }
        }
        return stack;
    }
}

