/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class GateChainEntity
extends Entity {
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_LENGTH = "MAHOUTSUKAI_LENGTH";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static float speed = 4.2f;
    public boolean dying = false;
    public int dyingticks = 0;
    public float lastlen = 0.0f;
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.m_135353_(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> LENGTH = SynchedEntityData.m_135353_(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.m_135353_(GateChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final String entityName = "gate_chain_mahoujin_entity";
    public Vec3 target = null;

    public GateChainEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public GateChainEntity(Level world) {
        super((EntityType)ModEntities.GATE_CHAIN.get(), world);
        this.f_19811_ = true;
    }

    public GateChainEntity(Level world, float r, float g, float b, float a, Vec3 pos, Vec3 target) {
        this(world);
        this.setColor(r, g, b, a);
        this.target = target;
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_A, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        this.setCircleSize(compound.m_128457_(TAG_CIRCLE_SIZE));
        this.setLife(compound.m_128451_(TAG_LIFE));
        this.setLength(compound.m_128451_(TAG_LENGTH));
        this.setColor(compound.m_128457_(TAG_COLOR_R), compound.m_128457_(TAG_COLOR_G), compound.m_128457_(TAG_COLOR_B), compound.m_128457_(TAG_COLOR_A));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.m_128405_(TAG_LIFE, this.getLife());
        compound.m_128350_(TAG_LENGTH, this.getLength());
        float[] colors = this.getColor();
        compound.m_128350_(TAG_COLOR_R, colors[0]);
        compound.m_128350_(TAG_COLOR_G, colors[1]);
        compound.m_128350_(TAG_COLOR_B, colors[2]);
        compound.m_128350_(TAG_COLOR_A, colors[3]);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getCircleSize() {
        return ((Float)this.f_19804_.m_135370_(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.f_19804_.m_135381_(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(int l) {
        this.f_19804_.m_135381_(LIFE, (Object)l);
    }

    public float getLength() {
        return ((Float)this.f_19804_.m_135370_(LENGTH)).floatValue();
    }

    public void setLength(float l) {
        this.f_19804_.m_135381_(LENGTH, (Object)Float.valueOf(l));
    }

    public float[] getColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_A)).floatValue()};
    }

    public void setColor(float r, float g, float b, float a) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        this.f_19804_.m_135381_(COLOR_A, (Object)Float.valueOf(a));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (!this.dying) {
                if (ServerHandler.tickCounter % (long)MTConfig.TREASURY_PROJECTION_CHAINS_COOLDOWN == 0L) {
                    this.setLife(this.getLife() + 1);
                    if (this.getLife() > 20) {
                        this.startDying();
                    }
                }
                if (this.target != null) {
                    Vec3 tv = this.target;
                    if ((double)this.getLength() < tv.m_82554_(this.m_20182_())) {
                        this.setLength(this.getLength() + speed);
                    } else if (Utils.isBlockAir(this.f_19853_, new BlockPos(this.target))) {
                        this.startDying();
                    }
                    this.collideWithNearbyEntities();
                }
            } else {
                this.die();
            }
        }
        this.lastlen = this.getLength();
    }

    protected void collideWithNearbyEntities() {
        float len = this.getLength();
        AABB aabb = new AABB(this.m_20185_() - (double)len, this.m_20186_() - (double)len, this.m_20189_() - (double)len, this.m_20185_() + (double)len, this.m_20186_() + (double)len, this.m_20189_() + (double)len);
        List list = this.f_19853_.m_6249_((Entity)this, aabb, EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                if (!(entity instanceof LivingEntity) || !this.boxIntersectsLine(entity.m_20191_())) continue;
                this.m_7334_(entity);
            }
        }
    }

    public boolean boxIntersectsLine(AABB aabb) {
        return Utils.CheckLineBox(new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_), new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_), this.m_20182_(), this.m_20182_().m_82549_(this.target.m_82546_(this.m_20182_()).m_82541_().m_82490_((double)this.getLength())));
    }

    public void m_7334_(Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            EffectUtil.magicAttack((LivingEntity)entityIn, (float)MTConfig.TREASURY_PROJECTION_CHAINS_DAMAGE, null);
            Vec3 v = this.m_20182_().m_82546_(entityIn.m_20182_());
            this.boop(entityIn, 0.3f, v.f_82479_, 0.0, v.f_82481_);
        }
    }

    public AABB m_20191_() {
        return ZERO_AABB;
    }

    public void startDying() {
        this.dying = true;
    }

    public void die() {
        ++this.dyingticks;
        if (this.getLength() <= 0.5f) {
            this.m_146870_();
        } else {
            this.setLength(this.getLength() - speed / 2.0f);
        }
    }

    private void boop(Entity entity, float strength, double x, double y, double z) {
        entity.f_19812_ = true;
        float f = Mth.m_14116_((float)((float)(x * x + z * z + y * y)));
        Vec3 motion = this.m_20184_();
        double motionX = motion.m_7096_();
        double motionY = motion.m_7098_();
        double motionZ = motion.m_7094_();
        motionX /= 2.0;
        motionZ /= 2.0;
        motionY /= 2.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.f_19864_ = true;
        if (entity.m_20096_()) {
            motionY /= 2.0;
            if ((motionY += (double)strength) > (double)0.4f) {
                motionY = 0.4f;
            }
        }
        entity.m_20334_(motionX, motionY, motionZ);
    }

    public void shoot(double x, double y, double z) {
        Vec3 Vec32 = new Vec3(x, y, z).m_82541_();
        float f = Mth.m_14116_((float)((float)Vec32.m_165925_()));
        this.f_19857_ = (float)(Mth.m_14136_((double)Vec32.f_82479_, (double)Vec32.f_82481_) * 57.2957763671875);
        this.f_19858_ = (float)(Mth.m_14136_((double)Vec32.f_82480_, (double)f) * 57.2957763671875);
        this.f_19859_ = this.f_19857_;
        this.f_19860_ = this.f_19858_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (amount > 4.0f) {
            this.startDying();
            return true;
        }
        return false;
    }
}

