/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.secret.GandrSpellScroll;
import stepsword.mahoutsukai.networking.MagicCircleBoomParticlePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class GandrEntity
extends Entity {
    public static final String entityName = "gandr_entity";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_FIRED = "MAHOUTSUKAI_FIRED";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.m_135353_(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> FIRED = SynchedEntityData.m_135353_(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.m_135353_(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.m_135353_(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.m_135353_(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.m_135353_(GandrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public ArrayList<MobEffectInstance> effects = new ArrayList();
    public float damage = 0.0f;
    public int swirls = 100;
    public float[] progressstarts = new float[this.swirls];
    public float[] progressends = new float[this.swirls];
    public float[] angles = new float[this.swirls];
    public boolean inited = false;
    public float swirlLife = 9.0f;
    public int firedProgressLife = 3;
    public int ticksSinceFired = 0;
    public long timeCreated = -1L;

    public GandrEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super((EntityType)ModEntities.GANDR.get(), worldIn);
        this.f_19811_ = true;
    }

    public GandrEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public GandrEntity(Level world) {
        super((EntityType)ModEntities.GANDR.get(), world);
        this.f_19811_ = true;
    }

    public GandrEntity(Level world, LivingEntity caster, float r, float g, float b, float a, float r2, float g2, float b2) {
        this(world);
        this.setCasterUUID(caster.m_20148_());
        this.setColor(r, g, b, a, r2, g2, b2);
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        this.f_19804_.m_135381_(COLOR_R2, (Object)Float.valueOf(r2));
        this.f_19804_.m_135381_(COLOR_G2, (Object)Float.valueOf(g2));
        this.f_19804_.m_135381_(COLOR_B2, (Object)Float.valueOf(b2));
        this.f_19804_.m_135381_(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_A)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_R2)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G2)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B2)).floatValue()};
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(CASTER_UUID, Optional.empty());
        this.f_19804_.m_135372_(FIRED, (Object)false);
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_R2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_A, (Object)Float.valueOf(1.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        this.setLife(compound.m_128451_(TAG_LIFE));
        this.setFired(compound.m_128471_(TAG_FIRED));
        if (compound.m_128403_(TAG_CASTER)) {
            this.setCasterUUID(compound.m_128342_(TAG_CASTER));
        }
        this.setColor(compound.m_128457_(TAG_COLOR_R), compound.m_128457_(TAG_COLOR_G), compound.m_128457_(TAG_COLOR_B), compound.m_128457_(TAG_COLOR_A), compound.m_128457_(TAG_COLOR_R2), compound.m_128457_(TAG_COLOR_G2), compound.m_128457_(TAG_COLOR_B2));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_(TAG_LIFE, this.getLife());
        compound.m_128379_(TAG_FIRED, this.getFired());
        if (this.getCasterUUID() != null) {
            compound.m_128362_(TAG_CASTER, this.getCasterUUID());
        }
        float[] colors = this.getColor();
        compound.m_128350_(TAG_COLOR_R, colors[0]);
        compound.m_128350_(TAG_COLOR_G, colors[1]);
        compound.m_128350_(TAG_COLOR_B, colors[2]);
        compound.m_128350_(TAG_COLOR_A, colors[3]);
        compound.m_128350_(TAG_COLOR_R2, colors[4]);
        compound.m_128350_(TAG_COLOR_G2, colors[5]);
        compound.m_128350_(TAG_COLOR_B2, colors[6]);
    }

    public float getGrowingLife() {
        return 15.0f;
    }

    public void m_8119_() {
        Player player;
        if (this.timeCreated == -1L) {
            this.timeCreated = this.f_19853_.m_46467_();
        }
        this.setLife(this.getLife() + 1);
        if (this.f_19853_.f_46443_) {
            if (!this.inited) {
                for (int i = 0; i < this.swirls; ++i) {
                    this.progressstarts[i] = (float)i * 1.0f / (float)this.swirls;
                    this.progressends[i] = this.progressstarts[i] + this.swirlLife / 100.0f;
                    this.angles[i] = this.f_19796_.m_188501_() * 360.0f;
                    if (!(this.progressends[i] > 1.0f)) continue;
                    int n = i;
                    this.progressends[n] = this.progressends[n] - 1.0f;
                }
                this.inited = true;
            }
        } else {
            if (this.ticksSinceFired > 800 || this.f_19853_.m_46467_() - this.timeCreated > 6000L) {
                this.m_146870_();
            }
            Player player2 = this.f_19853_.m_46003_(this.getCasterUUID());
            if (!(this.getFired() || player2 != null && (player2.m_21211_().m_41720_() instanceof GandrSpellScroll || player2.m_21211_().m_41720_() instanceof MysticCode))) {
                this.m_146870_();
            }
        }
        if (this.getFired()) {
            ++this.ticksSinceFired;
            if (this.f_19853_.f_46443_) {
                MahouTsukaiMod.proxy.spawnGandrParticle(this);
            } else {
                this.checkHit();
            }
        }
        if (this.getCasterUUID() != null && !this.getFired() && (player = this.f_19853_.m_46003_(this.getCasterUUID())) != null) {
            this.setLookPos(player.f_19853_.f_46443_, (LivingEntity)player, this);
        }
        this.m_6021_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
    }

    public void checkHit() {
        Vec3 vec3d3;
        Vec3 vec3d = this.m_20184_();
        Vec3 vec3d2 = this.m_20182_();
        BlockHitResult raytraceresult = this.f_19853_.m_45547_(new ClipContext(vec3d2, vec3d3 = vec3d2.m_82549_(vec3d), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            vec3d3 = raytraceresult.m_82450_();
        }
        while (!this.m_213877_()) {
            EntityHitResult entityraytraceresult = this.rayTraceEntities(vec3d2, vec3d3);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY && raytraceresult instanceof EntityHitResult) {
                Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
                Entity entity1 = this.getShooter();
                if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity) && !ContractMahoujinTileEntity.isImmuneToSpell(this.f_19853_, this.getCasterUUID(), entity)) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                }
            }
            if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS) {
                this.onHit((HitResult)raytraceresult);
            }
            if (entityraytraceresult == null) break;
            raytraceresult = null;
        }
    }

    public void onHit(HitResult result) {
        Vec3 look = this.m_20252_(1.0f);
        int black_particles = MTConfig.GANDR_BLACK_PARTICLES_HIT;
        int red_particles = MTConfig.GANDR_RED_PARTICLES_HIT;
        float radius = (float)MTConfig.GANDR_HIT_RADIUS;
        int duration = MTConfig.GANDR_CLOUD_DURATION;
        AreaEffectCloud area = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        boolean spawn = false;
        if (this.getShooter() instanceof LivingEntity) {
            area.m_19714_(0xFF0000);
            area.m_19712_(radius);
            area.m_19718_((LivingEntity)this.getShooter());
            area.m_19734_(duration);
            for (MobEffectInstance e : this.effects) {
                if (!GandrEntity.validEffect(e)) continue;
                spawn = true;
                area.m_19716_(e);
            }
        }
        if (spawn) {
            this.f_19853_.m_7967_((Entity)area);
        }
        AABB aabb = new AABB(this.m_20185_() - (double)radius, this.m_20186_() - (double)radius, this.m_20189_() - (double)radius, this.m_20185_() + (double)radius, this.m_20186_() + (double)radius, this.m_20189_() + (double)radius);
        List entities = this.f_19853_.m_6249_(this.getShooter(), aabb, Entity::m_6084_);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || ContractMahoujinTileEntity.isImmuneToSpell(this.f_19853_, this.getCasterUUID(), entity)) continue;
            EffectUtil.magicAttack((LivingEntity)entity, this.damage, (LivingEntity)this.f_19853_.m_46003_(this.getCasterUUID()));
            if (entity.m_6084_() && !(((LivingEntity)entity).m_21223_() <= 0.0f) || !(this.getShooter() instanceof ServerPlayer)) continue;
            ModTriggers.GANDR.trigger((ServerPlayer)this.getShooter());
        }
        float[] rgbs = this.getColor();
        PacketHandler.sendTracking(this, new MagicCircleBoomParticlePacket(this.m_20185_(), this.m_20186_(), this.m_20189_(), look.f_82479_, look.f_82480_, look.f_82481_, 2.0, 1, 1, black_particles, true, true, rgbs[0], rgbs[1], rgbs[2], rgbs[4], rgbs[5], rgbs[6]));
        PacketHandler.sendTracking(this, new MagicCircleBoomParticlePacket(this.m_20185_(), this.m_20186_(), this.m_20189_(), look.f_82479_, look.f_82480_, look.f_82481_, 2.0, 0, 1, red_particles, true, true, rgbs[0], rgbs[1], rgbs[2], rgbs[4], rgbs[5], rgbs[6]));
        this.m_146870_();
    }

    public static boolean validEffect(MobEffectInstance e) {
        MobEffect effect = e.m_19544_();
        boolean inwhitelist = false;
        for (String string : MTConfig.GANDR_EFFECT_WHITELIST) {
            if (!string.equals(Utils.getRegistryName(e.m_19544_()))) continue;
            inwhitelist = true;
        }
        boolean inblacklist = false;
        for (String string : MTConfig.GANDR_EFFECT_BLACKLIST) {
            if (!string.equals(Utils.getRegistryName(e.m_19544_()))) continue;
            inblacklist = true;
        }
        return inwhitelist || !inblacklist && effect.m_19483_() == MobEffectCategory.HARMFUL;
    }

    @Nullable
    public Entity getShooter() {
        return this.getCasterUUID() != null && this.f_19853_ instanceof ServerLevel ? ((ServerLevel)this.f_19853_).m_8791_(this.getCasterUUID()) : null;
    }

    @Nullable
    protected EntityHitResult rayTraceEntities(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), p_213871_1_ -> !p_213871_1_.m_5833_() && p_213871_1_.m_6084_() && p_213871_1_.m_6087_() && (!p_213871_1_.m_20148_().equals(this.getCasterUUID()) || this.ticksSinceFired >= 5));
    }

    public Vec3 setLookPos(boolean client, LivingEntity caster, GandrEntity gandr) {
        Vec3 look = caster.m_20252_(1.0f);
        Vec3 oldlook = look.m_82541_();
        look = oldlook.m_82490_((double)1.1f);
        Vec3 start = look.m_82549_(caster.m_20299_(1.0f));
        gandr.f_19857_ = caster.f_19857_;
        gandr.f_19858_ = caster.f_19858_;
        if (!client) {
            gandr.m_6034_(start.f_82479_, start.f_82480_, start.f_82481_);
        }
        return start;
    }

    public int getLife() {
        return (Integer)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(int l) {
        this.f_19804_.m_135381_(LIFE, (Object)l);
    }

    public UUID getCasterUUID() {
        return ((Optional)this.f_19804_.m_135370_(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.f_19804_.m_135381_(CASTER_UUID, Optional.of(uuid));
    }

    public boolean getFired() {
        return (Boolean)this.f_19804_.m_135370_(FIRED);
    }

    public void setFired(boolean f) {
        this.f_19804_.m_135381_(FIRED, (Object)f);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

