/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.mystic.MysticStaff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffAOEMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.render.item.MysticStaffRenderer;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MysticStaff
extends ItemBase {
    private String MODE_TAG = "MAHOUTSUKAI_AOE_MODE_ON";
    private static final int beamGrowthStart = 35;
    private static final float beamGrowthRate = 1.026f;
    private static final float highestRadius = 35.0f;
    public static HashMap<UUID, MysticStaffUserStorage> staffs = new HashMap();

    public MysticStaff() {
        super("mystic_staff", ModItems.MAHOUTSUKAI_CREATIVE_TAB, 1, 20);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        staffs.remove(player.m_20148_());
        MysticStaffUserStorage storage = new MysticStaffUserStorage();
        storage.growthStopped = false;
        storage.mahoujins = null;
        storage.target = null;
        storage.aoeTargets = null;
        storage.aoeSpawnIndex = 0;
        staffs.put(player.m_20148_(), storage);
        if (player.m_20163_()) {
            if (!world.f_46443_) {
                this.setAOEMode(stack, (this.getAOEMode(stack) + 1) % 3);
                int mode = this.getAOEMode(stack);
                MutableComponent tt = mode == 0 ? Component.m_237115_((String)"mahoutsukai.mysticstaff.big") : (mode == 1 ? Component.m_237115_((String)"mahoutsukai.mysticstaff.aoe") : Component.m_237115_((String)"mahoutsukai.mysticstaff.beam"));
                player.m_5661_((Component)tt, true);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void setAOEMode(ItemStack staff, int mode) {
        CompoundTag nbt = staff.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128405_(this.MODE_TAG, mode);
        staff.m_41751_(nbt);
    }

    public int getAOEMode(ItemStack staff) {
        CompoundTag nbt = staff.m_41783_();
        if (nbt != null && nbt.m_128441_(this.MODE_TAG)) {
            return nbt.m_128451_(this.MODE_TAG);
        }
        return 0;
    }

    public static float getBeamSize(MysticStaffMahoujinEntity entity, float partialTicks) {
        float last = entity.getBeamSize() / 1.026f;
        return last + partialTicks * (entity.getBeamSize() - last);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player instanceof Player) {
            MysticStaffUserStorage storage = null;
            if (staffs.containsKey(player.m_20148_())) {
                storage = staffs.get(player.m_20148_());
            }
            if (storage == null) {
                storage = new MysticStaffUserStorage();
                staffs.put(player.m_20148_(), storage);
            }
            if (this.getAOEMode(stack) == 0) {
                player.m_20334_(0.0, player.m_20184_().f_82480_ * 0.3, 0.0);
                int charge = this.getRemainingUseDuration(stack, count);
                if (storage.mahoujins == null) {
                    storage.mahoujins = new ArrayList();
                }
                if (!player.f_19853_.f_46443_) {
                    float thunderChance;
                    if (storage.target == null) {
                        storage.target = this.getTargetBlock((Player)player);
                    }
                    if (charge == 1) {
                        this.createFloorCircle(stack, (Player)player, new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_()), 3.0f, 0.5f, storage);
                        this.createFloorCircle(stack, (Player)player, storage.target.m_82549_(new Vec3(0.0, 1.0, 0.0)), 12.0f, 0.5f, storage);
                    }
                    if (charge == 5) {
                        storage.lowest = this.createCircleAtAngle(stack, (Player)player, 10.0f, 1.5f, 10.0f, 30.0f, 15.0f, storage.target, false, 0.1f, false, storage);
                    }
                    if (charge == 8) {
                        this.createCircleAtAngle(stack, (Player)player, 15.0f, 0.5f, 10.0f, 30.0f, 22.0f, storage.target, false, 0.0f, false, storage);
                    }
                    if (charge == 13) {
                        this.createCircleAtAngle(stack, (Player)player, 20.0f, 2.0f, 10.0f, 30.0f, 30.0f, storage.target, false, 0.0f, false, storage);
                    }
                    if (charge == 15) {
                        storage.highest = this.createCircleAtAngle(stack, (Player)player, 35.0f, 1.0f, 10.0f, 30.0f, 37.0f, storage.target, true, 0.1f, false, storage);
                    }
                    if (charge > 15 && storage.highest != null && MTConfig.MYSTIC_STAFF_BIG_RAIN && (double)(thunderChance = player.m_217043_().m_188501_()) < 0.1) {
                        int angle = player.m_217043_().m_188503_(360);
                        float radius = (float)player.m_217043_().m_188503_(20) + 35.0f;
                        double addX = (double)(-radius) * Math.cos(MysticStaffMahoujinEntity.toRad(angle));
                        double addZ = (double)radius * Math.sin(MysticStaffMahoujinEntity.toRad(angle));
                        double addY = player.m_217043_().m_188503_(10) - 5;
                        LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(player.f_19853_);
                        lightning.m_20219_(new Vec3(storage.highest.m_20185_() + addX, storage.highest.m_20186_() + addY, storage.highest.m_20189_() + addZ));
                        lightning.m_20874_(true);
                        ((ServerLevel)player.f_19853_).m_7967_((Entity)lightning);
                    }
                    if (charge > 35 && storage.lowest != null && storage.highest != null) {
                        if (storage.highest.getBeamSize() < 0.6f) {
                            storage.lowest.setBeamSize(storage.lowest.getBeamSize() * 1.026f);
                            storage.highest.setBeamSize(storage.highest.getBeamSize() * 1.026f);
                        } else {
                            storage.growthStopped = true;
                        }
                    }
                    if (MTConfig.MYSTIC_STAFF_BIG_RAIN) {
                        ((ServerLevel)player.f_19853_).f_46438_ = Math.min((float)charge / 40.0f, 2.4f);
                        ((ServerLevel)player.f_19853_).f_46440_ = Math.min((float)charge / 40.0f, 2.4f);
                    }
                }
            } else if (this.getAOEMode(stack) == 1) {
                if (!player.f_19853_.f_46443_ && PlayerManaManager.drainMana((Player)player, MTConfig.MYSTIC_STAFF_AOE_MANA_COST, false, false) == MTConfig.MYSTIC_STAFF_AOE_MANA_COST) {
                    Vec3 playerpos;
                    Vec3 look = player.m_20154_();
                    Vec3 playerperp = playerpos = player.m_20182_();
                    playerperp = playerperp.m_82549_(look.m_82541_().m_82490_(2.0));
                    playerperp = player.m_217043_().m_188499_() ? playerperp.m_82549_(Vec3.m_82498_((float)0.0f, (float)(player.f_19857_ + 90.0f)).m_82541_().m_82490_(player.m_217043_().m_188500_() * 3.0 - 0.3).m_82490_(2.0)) : playerperp.m_82549_(Vec3.m_82498_((float)0.0f, (float)(player.f_19857_ - 90.0f)).m_82541_().m_82490_(player.m_217043_().m_188500_() * 3.0 - 0.3).m_82490_(2.0));
                    playerperp = playerperp.m_82549_(Vec3.m_82498_((float)(player.f_19858_ - 90.0f), (float)player.f_19857_).m_82541_().m_82490_(player.m_217043_().m_188500_() * 3.0 - 0.2).m_82490_(2.0));
                    if (count % MTConfig.MYSTIC_STAFF_AOE_DELAY == 0) {
                        float[] colors = this.getColor((Player)player, 1);
                        MysticStaffAOEMahoujinEntity circle = new MysticStaffAOEMahoujinEntity(player.f_19853_, (Player)player, colors[0], colors[1], colors[2], 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                        circle.m_6034_(playerperp.f_82479_, playerperp.f_82480_, playerperp.f_82481_);
                        circle.f_19858_ = player.f_19858_;
                        circle.f_19857_ = player.f_19857_;
                        Vec3 pos = circle.m_20182_().m_82549_(player.m_20154_());
                        Vec3 aim = circle.m_20182_().m_82546_(pos);
                        circle.setCircleSize(1.5f);
                        circle.shoot(-aim.f_82479_, -aim.f_82480_, -aim.f_82481_, 3.0f, 4.0f);
                        player.f_19853_.m_7967_((Entity)circle);
                    }
                }
            } else if (!player.f_19853_.f_46443_) {
                if (this.getRemainingUseDuration(stack, count) > MysticStaffBeamMahoujinEntity.dyingticks * 2 && storage.beamMahoujinEntity == null) {
                    float[] colors = this.getColor((Player)player, 2);
                    storage.beamMahoujinEntity = new MysticStaffBeamMahoujinEntity(player.f_19853_, (Player)player, colors[0], colors[1], colors[2]);
                    storage.beamMahoujinEntity.casterPosition(true);
                    player.f_19853_.m_7967_((Entity)storage.beamMahoujinEntity);
                }
                player.m_20334_(0.0, 0.0, 0.0);
            } else if (this.getRemainingUseDuration(stack, count) > MysticStaffBeamMahoujinEntity.dyingticks * 2 && player == Minecraft.m_91087_().f_91074_) {
                MahouTsukaiMod.proxy.slowDown();
            }
        }
    }

    public int getRemainingUseDuration(ItemStack stack, int charge) {
        return this.m_8105_(stack) - charge;
    }

    public Vec3 getTargetBlock(Player player) {
        Vec3 target;
        HitResult result = player.m_19907_((double)MTConfig.GLOBAL_LOOK_RANGE, 1.0f, false);
        if (result instanceof BlockHitResult) {
            target = new Vec3((double)((BlockHitResult)result).m_82425_().m_123341_() + 0.5, (double)((BlockHitResult)result).m_82425_().m_123342_(), (double)((BlockHitResult)result).m_82425_().m_123343_() + 0.5);
        } else {
            Vec3 v = player.m_20252_(0.0f);
            Vec3 v2 = new Vec3(v.f_82479_ * (double)MTConfig.GLOBAL_LOOK_RANGE, v.f_82480_ * (double)MTConfig.GLOBAL_LOOK_RANGE, v.f_82481_ * (double)MTConfig.GLOBAL_LOOK_RANGE);
            Vec3 v3 = player.m_20299_(1.0f).m_82549_(v2);
            while (Utils.isBlockAir(player.f_19853_, new BlockPos(v3)) && v3.f_82480_ > 0.0) {
                v3 = v3.m_82549_(new Vec3(0.0, -1.0, 0.0));
            }
            target = v3;
        }
        return target;
    }

    public void createFloorCircle(ItemStack stack, Player player, Vec3 pos, float size, float speed, MysticStaffUserStorage storage) {
        float[] colors = this.getColor(player, 0);
        MysticStaffMahoujinEntity floorMahoujin = new MysticStaffMahoujinEntity(player.f_19853_, player, false, colors[0], colors[1], colors[2], 0.95f);
        floorMahoujin.m_6034_(pos.f_82479_, pos.f_82480_ + 0.001, pos.f_82481_);
        floorMahoujin.sizer(size);
        floorMahoujin.setRotationSpeed(speed);
        floorMahoujin.setRotationYaw(0.0f);
        floorMahoujin.setRotationPitch(0.0f);
        storage.mahoujins.add(floorMahoujin);
        player.f_19853_.m_7967_((Entity)floorMahoujin);
    }

    public MysticStaffMahoujinEntity createCircleAtAngle(ItemStack stack, Player player, float size, float speed, float circle, float ground, float distance, Vec3 pos, boolean beam, float beamSize, boolean aoe, MysticStaffUserStorage storage) {
        MysticStaffMahoujinEntity m;
        float[] colors = this.getColor(player, aoe ? 1 : 0);
        if (aoe) {
            m = new MysticStaffMahoujinEntity(player.f_19853_, player, beam, colors[0], colors[1], colors[2], 0.95f);
            m.setBeamLength(0.0f);
            m.setBeamOffset(0.0f);
        } else {
            m = new MysticStaffMahoujinEntity(player.f_19853_, player, beam, colors[0], colors[1], colors[2], 0.95f);
            m.setBeamLength(240.0f);
            m.setBeamOffset(-distance);
        }
        m.setDistance(distance);
        m.sizer(size);
        m.setRotationSpeed(speed);
        m.angleCircleAroundBlock(circle, ground, distance, pos);
        storage.mahoujins.add(m);
        player.f_19853_.m_7967_((Entity)m);
        if (beam) {
            m.setBeamSize(beamSize);
        }
        return m;
    }

    public Vec3 getBlockPerpToLook(Vec3 target, float playerYaw, float distance) {
        float yaw = playerYaw;
        double plusZ = (double)distance * Math.sin(MysticStaffMahoujinEntity.toRad(yaw += 90.0f));
        double plusX = (double)(-distance) * Math.cos(MysticStaffMahoujinEntity.toRad(yaw));
        return new Vec3(plusX, 0.0, plusZ).m_82549_(target);
    }

    public Vec3 getMiddleCircle(Vec3 target, Vec3 target2, float playerYaw, float distance) {
        double xhalf = (target2.f_82479_ - target.f_82479_) / 2.0;
        double zhalf = (target2.f_82481_ - target.f_82481_) / 2.0;
        double plusZ = (double)distance * Math.sin(MysticStaffMahoujinEntity.toRad(playerYaw));
        double plusX = (double)(-distance) * Math.cos(MysticStaffMahoujinEntity.toRad(playerYaw));
        return new Vec3(plusX += xhalf + target.f_82479_, target.f_82480_, plusZ += zhalf + target.f_82481_);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void m_5551_(@Nonnull ItemStack stack, @Nonnull Level world, LivingEntity caster, int useTicks) {
        MysticStaffUserStorage storage;
        Player player = (Player)caster;
        if (staffs.containsKey(player.m_20148_())) {
            storage = staffs.get(player.m_20148_());
        } else {
            storage = new MysticStaffUserStorage();
            staffs.put(player.m_20148_(), storage);
        }
        if (storage.mahoujins != null && !world.f_46443_) {
            int radius = MTConfig.MYSTIC_STAFF_BIG_SIZE;
            if (storage.growthStopped) {
                if (this.getAOEMode(stack) == 0) {
                    double mana = MTConfig.MYSTIC_STAFF_SCALING_MANA;
                    if (Utils.getPlayerMahou(player) != null) {
                        mana *= (double)Utils.getPlayerMahou(player).getMaxMana();
                    }
                    if ((double)PlayerManaManager.drainMana(player, (int)((double)MTConfig.MYSTIC_STAFF_BIG_MANA_COST + mana), false, false) == (double)MTConfig.MYSTIC_STAFF_BIG_MANA_COST + mana) {
                        double x = storage.target.f_82479_;
                        double y = storage.target.f_82480_;
                        double z = storage.target.f_82481_;
                        Bakuretsu explosion = new Bakuretsu(radius, (float)x, (float)y + (float)(radius / 2 + 2), (float)z, MysticStaff.getExplosionDamage(false, Utils.getPlayerMahou(player)));
                        explosion.explosionA(world, player);
                        ModTriggers.BAKURETSU.trigger((ServerPlayer)player);
                        for (Player Player2 : world.m_6907_()) {
                            if (!(Player2.m_20275_(x, y, z) < 16384.0)) continue;
                            Vec3 vec = null;
                            if (explosion.knockback.containsKey(player)) {
                                vec = explosion.knockback.get(player);
                            }
                            if (vec == null) {
                                PacketHandler.sendTo((ServerPlayer)Player2, new BakuretsuPacket(x, y + (double)(radius / 2 + 2), z, radius, 0.0f, 0.0f, 0.0f));
                                continue;
                            }
                            PacketHandler.sendTo((ServerPlayer)Player2, new BakuretsuPacket(x, y + (double)(radius / 2 + 2), z, radius, (float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_));
                        }
                        for (MysticStaffMahoujinEntity e : storage.mahoujins) {
                            e.m_146870_();
                        }
                    }
                } else if (this.getAOEMode(stack) == 1) {
                    // empty if block
                }
            }
            storage.mahoujins = new ArrayList();
        }
        if (!world.f_46443_) {
            if (storage.beamMahoujinEntity != null) {
                storage.beamMahoujinEntity.setDying(1);
                storage.beamMahoujinEntity = null;
            }
            MahouTsukaiMod.proxy.speedUp();
        }
    }

    public static float getExplosionDamage(boolean aoe, IMahou mahou) {
        boolean scales;
        float factor;
        if (aoe) {
            factor = (float)MTConfig.MYSTIC_STAFF_AOE_FACTOR;
            scales = MTConfig.MYSTIC_STAFF_AOE_SCALES;
        } else {
            factor = (float)MTConfig.MYSTIC_STAFF_BIG_FACTOR;
            scales = MTConfig.MYSTIC_STAFF_BIG_SCALES;
        }
        if (scales && mahou != null) {
            return (float)mahou.getMaxMana() * factor;
        }
        return factor;
    }

    public float[] getColor(Player caster, int mode) {
        float[] ret = new float[]{0.0f, 0.0f, 0.0f};
        MahouSettings.Spell spell = MahouSettings.Spell.MYSTIC_STAFF_BIG;
        if (mode == 1) {
            spell = MahouSettings.Spell.MYSTIC_STAFF_AOE;
        }
        if (mode == 2) {
            spell = MahouSettings.Spell.MYSTIC_STAFF_BEAM;
        }
        List<Integer> settings = MahouSettings.getIntSettings(caster, spell);
        ret[0] = (float)settings.get(0).intValue() / 255.0f;
        ret[1] = (float)settings.get(1).intValue() / 255.0f;
        ret[2] = (float)settings.get(2).intValue() / 255.0f;
        return ret;
    }

    public static List<BlockPos> getAffectedBlocks(Level world, BlockPos target, int size) {
        ArrayList<BlockPos> lst = new ArrayList<BlockPos>();
        int r = size / 2;
        Stream box = BlockPos.m_121990_((BlockPos)target.m_7918_(-r, -r, -r), (BlockPos)target.m_7918_(r, r, r));
        box.forEach(tmp -> {
            if (MysticStaff.getDistance(EffectUtil.fromBlockPos(tmp), EffectUtil.fromBlockPos(target)) < r) {
                lst.add(new BlockPos(tmp.m_123341_(), tmp.m_123342_(), tmp.m_123343_()));
            }
        });
        return lst;
    }

    public static int getDistance(Vec3 pos1, Vec3 pos2) {
        double x = pos1.f_82479_ - pos2.f_82479_;
        double y = pos1.f_82480_ - pos2.f_82480_;
        double z = pos1.f_82481_ - pos2.f_82481_;
        return (int)Math.abs(Math.ceil(Math.sqrt(x * x + y * y + z * z)));
    }

    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(MysticStaffRenderer::new);
    }

    public class MysticStaffUserStorage {
        public ArrayList<MysticStaffMahoujinEntity> mahoujins;
        public boolean growthStopped = false;
        public Vec3 target = null;
        public List<Vec3> aoeTargets = null;
        public MysticStaffMahoujinEntity highest = null;
        public MysticStaffMahoujinEntity lowest = null;
        public float playerLook = 0.0f;
        public float playerPitch = 0.0f;
        public int aoeSpawnIndex = 0;
        public MysticStaffBeamMahoujinEntity beamMahoujinEntity = null;
    }
}

