/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.enchant;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RenderLivingEvent;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.enchant.MahoujinProjectorEnchant;
import stepsword.mahoutsukai.enchant.ModEnchantments;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.enchant.ProjectorValues;
import stepsword.mahoutsukai.render.tile.MahoujinProjectorRenderer;
import stepsword.mahoutsukai.util.ClientImageDownloadUtil;
import stepsword.mahoutsukai.util.EffectUtil;

public class RenderProjectorEnchant {
    public static int rindex = 0;

    public static void renderProjectorEnchantment(RenderLivingEvent.Pre event) {
        LivingEntity living = event.getEntity();
        if (living != null) {
            Iterable armor = living.m_6168_();
            int x = 0;
            if (armor != null) {
                for (ItemStack stack : armor) {
                    List<CompoundTag> nbts;
                    ++x;
                    if (!EffectUtil.hasEnchantment(stack, (Enchantment)ModEnchantments.PROJECTOR.get()) || (nbts = MahoujinProjectorEnchant.getProjectorNBT(stack)) == null) continue;
                    for (CompoundTag nbt : nbts) {
                        float pitch;
                        float offset;
                        if (nbt == null) continue;
                        ProjectorValues te = new ProjectorValues();
                        te.read(nbt);
                        PoseStack m = event.getPoseStack();
                        m.m_85836_();
                        if (stack.m_41720_() != living.m_6844_(EquipmentSlot.HEAD).m_41720_()) {
                            offset = event.getEntity().f_20884_ + (event.getEntity().f_20883_ - event.getEntity().f_20884_) * event.getPartialTick();
                            pitch = 0.0f;
                        } else {
                            offset = event.getEntity().f_19859_ + (event.getEntity().f_19857_ - event.getEntity().f_19859_) * event.getPartialTick();
                            pitch = event.getEntity().f_19860_ + (event.getEntity().f_19858_ - event.getEntity().f_19860_) * event.getPartialTick();
                        }
                        RenderUtils.rotateQ(-offset, 0.0f, 1.0f, 0.0f, m);
                        RenderProjectorEnchant.projectorRender(te, m, event.getPartialTick(), event.getEntity().f_19853_, 0.0f, 0.0f, pitch);
                        m.m_85849_();
                    }
                }
            }
        }
    }

    public static void projectorRender(ProjectorValues te, PoseStack matrix, float partialTicks, Level world, float addpitch, float addyaw, float headpitch) {
        RenderType type;
        if (rindex == 0x7FFFFFFD) {
            rindex = 0;
        }
        float time = ClientHandler.clientTickCounter;
        float offsetx = te.getCx();
        float offsety = te.getCy();
        float offsetz = te.getCz();
        float r = (float)te.getCr() / 255.0f;
        float g = (float)te.getCg() / 255.0f;
        float b = (float)te.getCb() / 255.0f;
        float a = (float)te.getCa() / 255.0f;
        float rotation = te.getRotation() + te.getCspeed() * time;
        float yaw = te.getCyaw() + te.getCyspeed() * time;
        float pitch = te.getCpitch() + te.getCpspeed() * time;
        float speed = te.getCspeed();
        float ring = te.getCringangle();
        float size = te.getCsize();
        float orbit = te.getCorbitspeed() * time;
        yaw = yaw - te.getCyspeed() + te.getCyspeed() * partialTicks + addyaw;
        pitch = pitch - te.getCpspeed() + te.getCpspeed() * partialTicks + addpitch;
        rotation = te.getRotationOffset() + (rotation - speed) + speed * partialTicks;
        matrix.m_85836_();
        Matrix4f positionMatrix = matrix.m_85850_().m_85861_();
        float preyaw = te.getCpreyaw();
        float prepitch = te.getCprepitch();
        orbit = orbit - te.getCorbitspeed() + te.getCorbitspeed() * partialTicks;
        matrix.m_85837_(0.0, 0.5, 0.0);
        float headsize = -0.9f;
        matrix.m_85837_(0.0, (double)(-headsize), 0.0);
        RenderUtils.rotateQ(headpitch, 1.0f, 0.0f, 0.0f, matrix);
        matrix.m_85837_(0.0, (double)headsize, 0.0);
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(prepitch));
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(preyaw));
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(orbit));
        matrix.m_85837_((double)offsetx, (double)offsety, (double)offsetz);
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(yaw));
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        int loadImage = te.getImage();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        if (loadImage >= 0) {
            for (int j = 0; j < MTConfig.MAGIC_CIRCLES.size(); ++j) {
                ClientImageDownloadUtil.download("circle" + j, MTConfig.MAGIC_CIRCLES.get(j), false);
            }
            if (loadImage < ClientImageDownloadUtil.lst.size()) {
                try {
                    type = MahoujinRenderType.createMahoujinRenderType(ClientImageDownloadUtil.lst.get(loadImage), 0, false);
                }
                catch (Exception e) {
                    type = MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, false);
                }
            } else {
                type = MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, false);
            }
        } else {
            type = MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, false);
        }
        int lightmapX = 240;
        int lightmapY = 240;
        if (te.getShowCircle()) {
            VertexConsumer builder = buffer.m_6299_(type);
            builder.m_85982_(positionMatrix, -0.5f * size, 0.0f, -0.5f * size).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
            builder.m_85982_(positionMatrix, -0.5f * size, 0.0f, 0.5f * size).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
            builder.m_85982_(positionMatrix, 0.5f * size, 0.0f, 0.5f * size).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
            builder.m_85982_(positionMatrix, 0.5f * size, 0.0f, -0.5f * size).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
            buffer.m_109912_(type);
        }
        matrix.m_85837_(0.0, Math.sin(EffectUtil.toRad(te.getCringangle())) / 2.0 * (double)te.getHeight(), 0.0);
        loadImage = te.getRunes();
        if (te.getShowRing()) {
            if (loadImage >= 0) {
                for (int j = 0; j < MTConfig.MAGIC_RUNES.size(); ++j) {
                    ClientImageDownloadUtil.download("runes" + j, MTConfig.MAGIC_RUNES.get(j), true);
                }
                if (loadImage < ClientImageDownloadUtil.lstRunes.size()) {
                    try {
                        type = MahoujinRenderType.createRunesRenderType(ClientImageDownloadUtil.lstRunes.get(loadImage), rindex++);
                    }
                    catch (Exception e) {
                        type = MahoujinRenderType.createRunesRenderType(RenderUtils.runes, rindex++);
                    }
                } else {
                    type = MahoujinRenderType.createRunesRenderType(RenderUtils.runes, rindex++);
                }
            } else {
                type = MahoujinRenderType.createRunesRenderType(RenderUtils.runes, rindex++);
            }
            MahoujinProjectorRenderer.renderRing(positionMatrix, 0.0, ring, size / 2.0f + 0.125f, te.getHeight(), 128, (MultiBufferSource)buffer, lightmapX, lightmapY, r, g, b, a, type);
            buffer.m_109912_(type);
        }
        matrix.m_85849_();
    }
}

