/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

public class ProximityProjectionKeysModel
implements IUnbakedGeometry<ProximityProjectionKeysModel> {
    public static ResourceLocation redkey = new ResourceLocation("mahoutsukai", "items/red_key_64");
    public static ResourceLocation redkeymodel = new ResourceLocation("mahoutsukai", "item/proximity_projection_key");

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        float tx = 8.0f;
        float tz = 8.0f;
        float distance = 2.1f;
        Transformation transform1 = new Transformation(new Vector3f(-tx / 16.0f, tz / 16.0f, 0.0f), new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -90.0f, true), new Vector3f(1.33f, 1.33f, 1.33f), null);
        Transformation transform2 = new Transformation(new Vector3f(-tx / 16.0f, tz / 16.0f, 0.0f + distance / 16.0f), new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -90.0f, true), new Vector3f(1.33f, 1.33f, 1.33f), null);
        Transformation transform3 = new Transformation(new Vector3f(-tx / 16.0f, tz / 16.0f, 0.0f - distance / 16.0f), new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -90.0f, true), new Vector3f(1.33f, 1.33f, 1.33f), null);
        transform1.blockCenterToCorner();
        transform2.blockCenterToCorner();
        transform3.blockCenterToCorner();
        BakedModel akey1 = Minecraft.m_91087_().m_91304_().getModel(redkeymodel);
        BakedModel akey2 = Minecraft.m_91087_().m_91304_().getModel(redkeymodel);
        BakedModel akey3 = Minecraft.m_91087_().m_91304_().getModel(redkeymodel);
        ImmutableList.Builder quadBuilder = ImmutableList.builder();
        if (akey1 != null && akey2 != null && akey3 != null) {
            IQuadTransformer qt1 = IQuadTransformer.applying((Transformation)transform1);
            IQuadTransformer qt2 = IQuadTransformer.applying((Transformation)transform2);
            IQuadTransformer qt3 = IQuadTransformer.applying((Transformation)transform3);
            quadBuilder.addAll((Iterable)qt1.process(akey1.getQuads(null, null, RandomSource.m_216335_((long)42L), ModelData.EMPTY, null)));
            quadBuilder.addAll((Iterable)qt2.process(akey2.getQuads(null, null, RandomSource.m_216335_((long)42L), ModelData.EMPTY, null)));
            quadBuilder.addAll((Iterable)qt3.process(akey3.getQuads(null, null, RandomSource.m_216335_((long)42L), ModelData.EMPTY, null)));
        }
        return new BakedProximityProjectionKeysModel(bakery, owner, this, (ImmutableList<BakedQuad>)quadBuilder.build(), spriteGetter.apply(owner.getMaterial(redkey.toString())), akey1.m_7442_(), modelState);
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return new HashSet<Material>();
    }

    private static final class BakedProximityProjectionKeysModel
    implements BakedModel {
        private final IGeometryBakingContext owner;
        private final ProximityProjectionKeysModel parent;
        private final ItemTransforms transforms;
        private final TextureAtlasSprite particle;
        private final ModelState originalTransform;
        private final ImmutableList<BakedQuad> quads;
        private final ItemOverrides overrides;

        BakedProximityProjectionKeysModel(ModelBakery bakery, IGeometryBakingContext owner, ProximityProjectionKeysModel parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ItemTransforms transforms, ModelState originalTransform) {
            this.overrides = new ProximityProjectionKeysOverrideHandler(bakery);
            this.owner = owner;
            this.parent = parent;
            this.originalTransform = originalTransform;
            this.transforms = transforms;
            this.particle = particle;
            this.quads = quads;
        }

        public List<BakedQuad> m_213637_(@Nullable BlockState p_235039_, @Nullable Direction p_235040_, RandomSource p_235041_) {
            return this.quads;
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return false;
        }

        public boolean m_7547_() {
            return false;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public ItemTransforms m_7442_() {
            return this.transforms;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }
    }

    private static final class ProximityProjectionKeysOverrideHandler
    extends ItemOverrides {
        private final ModelBakery bakery;

        private ProximityProjectionKeysOverrideHandler(ModelBakery bakery) {
            this.bakery = bakery;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int p_173469_) {
            BakedProximityProjectionKeysModel model = (BakedProximityProjectionKeysModel)originalModel;
            ProximityProjectionKeysModel parent = new ProximityProjectionKeysModel();
            BakedModel bakedModel = parent.bake(model.owner, this.bakery, Material::m_119204_, model.originalTransform, model.m_7343_(), new ResourceLocation("mahoutsukai:proximity_projection_keys"));
            return bakedModel;
        }
    }

    public static enum Loader implements IGeometryLoader<ProximityProjectionKeysModel>
    {
        WEAPON_PROJECTILE_BOW;


        public ProximityProjectionKeysModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new ProximityProjectionKeysModel();
        }
    }
}

