/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class ParticleLightning
extends Particle {
    private static final ResourceLocation beam = new ResourceLocation("mahoutsukai:textures/block/white.png");
    public Color color;
    public Color color2;
    public int[] branch = new int[3];
    public int[] angles;
    public int[] angles2;
    public float[] sizes;
    public float[] widths;
    public int fullrotate;
    public int yawrot;
    int life;

    protected ParticleLightning(ClientLevel worldIn, Color c, Color c2, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double motionX, double motionY, double motionZ) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        this.f_107228_ = 0.7137255f;
        this.f_107227_ = 1.0f;
        this.f_107229_ = 0.75686276f;
        float maxAge = 180.0f;
        this.f_107225_ = (int)((double)maxAge / (Math.random() * 0.3 + 0.6));
        this.f_107225_ = (int)((float)this.f_107225_ * scale);
        this.f_107204_ = this.f_107231_ = (float)worldIn.f_46441_.m_188503_(360) * 0.0174533f;
        this.color = c;
        this.color2 = c2;
        this.branch[0] = this.f_107223_.m_188503_(2) + 1;
        this.branch[1] = this.f_107223_.m_188503_(2) + 1;
        this.branch[2] = this.f_107223_.m_188503_(3) + 1;
        int r = this.branch.length;
        for (int j = 0; j < this.branch.length; ++j) {
            r *= this.branch[j];
        }
        this.angles = new int[r];
        this.angles2 = new int[r];
        this.sizes = new float[r];
        this.widths = new float[r];
        this.sizes[0] = 0.14f;
        this.widths[0] = 0.01f;
        for (int k = 0; k < r; ++k) {
            this.angles[k] = this.f_107223_.m_188503_(360);
            this.angles2[k] = this.f_107223_.m_188503_(50) + 20;
            if (k > 0) {
                this.sizes[k] = (0.7f + this.f_107223_.m_188501_() * 0.2f) * this.sizes[k - 1];
            }
            if (k <= 0) continue;
            this.widths[k] = 1.0f * this.widths[k - 1];
        }
        this.life = this.f_107223_.m_188503_(1);
        this.fullrotate = this.f_107223_.m_188503_(20) + 80;
        this.fullrotate = this.f_107223_.m_188499_() ? -this.fullrotate : this.fullrotate;
        this.yawrot = (int)motionX;
    }

    public void m_5989_() {
        ++this.f_107224_;
        if (this.f_107224_ > this.life * this.branch.length + 3) {
            this.m_107274_();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107434_;
    }

    public void m_5744_(VertexConsumer builder, Camera activeRenderInfo, float partial) {
    }

    public static void renderLightningParticle(ParticleLightning particle, double d3, double d4, double d5, PoseStack matrix, float partialTicks) {
        double d0 = particle.f_107209_ + (particle.f_107212_ - particle.f_107209_) * (double)partialTicks;
        double d1 = particle.f_107210_ + (particle.f_107213_ - particle.f_107210_) * (double)partialTicks;
        double d2 = particle.f_107211_ + (particle.f_107214_ - particle.f_107211_) * (double)partialTicks;
        matrix.m_85836_();
        matrix.m_85837_(d0 - d3, d1 - d4, d2 - d5);
        float r = (float)particle.color.getRed() / 255.0f;
        float g = (float)particle.color.getGreen() / 255.0f;
        float b = (float)particle.color.getBlue() / 255.0f;
        float r2 = (float)particle.color2.getRed() / 255.0f;
        float g2 = (float)particle.color2.getGreen() / 255.0f;
        float b2 = (float)particle.color2.getBlue() / 255.0f;
        float a = 0.3f;
        float w = particle.widths[0];
        float h = particle.sizes[0];
        RenderUtils.rotateQ(-particle.yawrot, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(particle.fullrotate, 0.0f, 0.0f, 1.0f, matrix);
        MultiBufferSource.BufferSource buf = Minecraft.m_91087_().m_91269_().m_110104_();
        CullWrappedRenderLayer ringType = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(beam, 0));
        CullWrappedRenderLayer ringType2 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(beam, 1));
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, w, h, 6, 240, 240, r, g, b, 1.0f, ringType);
        buf.m_109912_((RenderType)ringType);
        ParticleLightning.recursiveLightning(matrix, buf, particle, 0, 0);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, w * 1.8f, h, 6, 240, 240, r2, g2, b2, a, ringType2);
        buf.m_109912_((RenderType)ringType2);
        matrix.m_85849_();
    }

    public static int recursiveLightning(PoseStack matrix, MultiBufferSource.BufferSource buf, ParticleLightning particle, int branchindex, int oindex) {
        float r = (float)particle.color.getRed() / 255.0f;
        float g = (float)particle.color.getGreen() / 255.0f;
        float b = (float)particle.color.getBlue() / 255.0f;
        float r2 = (float)particle.color2.getRed() / 255.0f;
        float g2 = (float)particle.color2.getGreen() / 255.0f;
        float b2 = (float)particle.color2.getBlue() / 255.0f;
        float a = 0.3f;
        int index = oindex;
        if (particle.f_107224_ > particle.life * branchindex) {
            float agefactor = 1.0f;
            if (branchindex >= particle.branch.length || index >= particle.sizes.length || index >= particle.angles.length) {
                return index;
            }
            float h = particle.sizes[index] * agefactor;
            float w = particle.widths[oindex];
            CullWrappedRenderLayer ringType = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(beam, 2 * index + 1));
            CullWrappedRenderLayer ringType2 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(beam, 2 * index + 4));
            matrix.m_85837_(0.0, (double)(-h), 0.0);
            RenderUtils.rotateQ(particle.angles[index], 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(particle.angles2[index], 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, w, h, 6, 240, 240, r, g, b, 1.0f, ringType);
            buf.m_109912_((RenderType)ringType);
            if (branchindex < particle.branch.length) {
                for (int i = 0; i < particle.branch[branchindex]; ++i) {
                    oindex = ParticleLightning.recursiveLightning(matrix, buf, particle, branchindex + 1, oindex + 1);
                }
            }
            RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, w * 1.8f, h, 6, 240, 240, r2, g2, b2, a, ringType2);
            buf.m_109912_((RenderType)ringType2);
            RenderUtils.rotateQ(-particle.angles2[index], 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(-particle.angles[index], 0.0f, 1.0f, 0.0f, matrix);
            matrix.m_85837_(0.0, (double)h, 0.0);
            return oindex;
        }
        return index;
    }
}

