/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.boundary;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.SingleUseMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RaiseEnclosureBarrierMahoujinTileEntity
extends SingleUseMahoujinTileEntity
implements BlockEntityTicker<RaiseEnclosureBarrierMahoujinTileEntity> {
    public static final String RAISED = "MAHOUTSUKAI_NUM_TIMES_RAISED";
    private int numTimesRaised = 0;
    private int tickCounter = 0;

    public RaiseEnclosureBarrierMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.raiseEnclosureBoundary.get(), p, bs);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128405_(RAISED, this.numTimesRaised);
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.numTimesRaised = compound.m_128451_(RAISED);
        super.m_142466_(compound);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, RaiseEnclosureBarrierMahoujinTileEntity blockEntity) {
        if (!level.f_46443_) {
            if (this.tickCounter == MTConfig.ENCLOSURE_BARRIER_CYCLE) {
                if (this.numTimesRaised >= MTConfig.ENCLOSURE_BARRIER_RADIUS - 1) {
                    EffectUtil.tryChangeBlockState(false, this.f_58858_, Blocks.f_50016_.m_49966_(), level, this.getCaster());
                } else {
                    boolean nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.f_58858_, level, this.getCasterUUID(), MTConfig.ENCLOSURE_BARRIER_MANA_COST);
                    if (nearbyBatteriesGaveMana || this.getCaster() != null && PlayerManaManager.drainMana(this.getCaster(), MTConfig.ENCLOSURE_BARRIER_MANA_COST, false, true) == MTConfig.ENCLOSURE_BARRIER_MANA_COST) {
                        this.raiseEnclosure();
                        ++this.numTimesRaised;
                    }
                }
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
    }

    public void raiseEnclosure() {
        int bottom = MTConfig.ENCLOSURE_BARRIER_RADIUS - this.numTimesRaised - 1;
        Stream box = BlockPos.m_121990_((BlockPos)this.f_58858_.m_7918_(-MTConfig.ENCLOSURE_BARRIER_RADIUS, -bottom, -MTConfig.ENCLOSURE_BARRIER_RADIUS), (BlockPos)this.f_58858_.m_7918_(MTConfig.ENCLOSURE_BARRIER_RADIUS, -bottom, MTConfig.ENCLOSURE_BARRIER_RADIUS));
        box.forEach(tmp -> {
            int k;
            if (tmp.m_123342_() == this.f_58858_.m_123342_() - bottom && (tmp.m_123341_() == this.f_58858_.m_123341_() - MTConfig.ENCLOSURE_BARRIER_RADIUS || tmp.m_123341_() == this.f_58858_.m_123341_() + MTConfig.ENCLOSURE_BARRIER_RADIUS || tmp.m_123343_() == this.f_58858_.m_123343_() - MTConfig.ENCLOSURE_BARRIER_RADIUS || tmp.m_123343_() == this.f_58858_.m_123343_() + MTConfig.ENCLOSURE_BARRIER_RADIUS) && (k = this.checkValidColumn((BlockPos)tmp)) > 0) {
                for (int i = k; i > 0; --i) {
                    BlockPos p = tmp.m_7918_(0, i, 0);
                    EffectUtil.tryChangeBlockState(false, p, this.f_58857_.m_8055_(p.m_7918_(0, -1, 0)), this.f_58857_, this.getCaster());
                }
                EffectUtil.tryChangeBlockState(false, tmp, Blocks.f_50016_.m_49966_(), this.f_58857_, this.getCaster());
            }
        });
    }

    public int checkValidColumn(BlockPos p) {
        boolean numAir = false;
        for (int k = 0; k < 255 - p.m_123342_() - 1; ++k) {
            if (Utils.isBlockAir(this.f_58857_, p.m_7918_(0, k, 0)) && k >= MTConfig.ENCLOSURE_BARRIER_RADIUS - 1) {
                return k;
            }
            if (this.f_58857_.m_7702_(p.m_7918_(0, k, 0)) != null) {
                return -1;
            }
            if (this.f_58857_.m_8055_(p.m_7918_(0, k, 0)).m_60734_() != Blocks.f_50752_) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public ItemStack getItemToGive() {
        return new ItemStack((ItemLike)ModItems.boundaryRaiseEnclosureScroll.get());
    }
}

