/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.util;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahouProvider;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.capability.chunks.ChunkMahouProvider;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.capability.containers.MysticCodeInventoryProvider;
import stepsword.mahoutsukai.capability.gemmahou.GemMahouProvider;
import stepsword.mahoutsukai.capability.gemmahou.IGemMahou;
import stepsword.mahoutsukai.capability.kodoku.IKodokuMahou;
import stepsword.mahoutsukai.capability.kodoku.KodokuMahouProvider;
import stepsword.mahoutsukai.capability.lance.ILanceMahou;
import stepsword.mahoutsukai.capability.lance.LanceMahouProvider;
import stepsword.mahoutsukai.capability.livingmahou.ILivingMahou;
import stepsword.mahoutsukai.capability.livingmahou.LivingMahouProvider;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.MahouProvider;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouProvider;
import stepsword.mahoutsukai.capability.settingsmahou.ISettingsMahou;
import stepsword.mahoutsukai.capability.settingsmahou.SettingsMahouProvider;
import stepsword.mahoutsukai.capability.worldsave.IWorldMahou;
import stepsword.mahoutsukai.capability.worldsave.WorldMahouProvider;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.fluids.ModFluids;
import stepsword.mahoutsukai.util.EffectUtil;

public class Utils {
    public static IMahou getPlayerMahou(Player player) {
        try {
            LazyOptional lazy = player.getCapability(MahouProvider.MAHOU, null);
            return (IMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getRegistryName(Enchantment e) {
        return Utils.getRegistryKey(e).toString();
    }

    public static String getRegistryName(Entity e) {
        return Utils.getRegistryKey(e).toString();
    }

    public static String getRegistryName(MobEffect e) {
        return Utils.getRegistryKey(e).toString();
    }

    public static String getRegistryName(Item item) {
        return Utils.getRegistryKey(item).toString();
    }

    public static String getRegistryName(Block block) {
        return Utils.getRegistryKey(block).toString();
    }

    public static ResourceLocation getRegistryKey(Enchantment e) {
        if (ForgeRegistries.ENCHANTMENTS.containsValue((Object)e)) {
            return ForgeRegistries.ENCHANTMENTS.getKey((Object)e);
        }
        return null;
    }

    public static ResourceLocation getRegistryKey(Entity e) {
        if (ForgeRegistries.ENTITY_TYPES.containsValue((Object)e.m_6095_())) {
            return ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_());
        }
        return null;
    }

    public static ResourceLocation getRegistryKey(MobEffect e) {
        if (ForgeRegistries.MOB_EFFECTS.containsValue((Object)e)) {
            return ForgeRegistries.MOB_EFFECTS.getKey((Object)e);
        }
        return null;
    }

    public static ResourceLocation getRegistryKey(Item item) {
        if (ForgeRegistries.ITEMS.containsValue((Object)item)) {
            return ForgeRegistries.ITEMS.getKey((Object)item);
        }
        return null;
    }

    public static ResourceLocation getRegistryKey(Block block) {
        if (ForgeRegistries.BLOCKS.containsValue((Object)block)) {
            return ForgeRegistries.BLOCKS.getKey((Object)block);
        }
        return null;
    }

    public static ILivingMahou getLivingMahou(LivingEntity player) {
        try {
            LazyOptional lazy = player.getCapability(LivingMahouProvider.MAHOU, null);
            return (ILivingMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ISettingsMahou getSettingsMahou(LivingEntity player) {
        try {
            LazyOptional lazy = player.getCapability(SettingsMahouProvider.MAHOU, null);
            return (ISettingsMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IItemHandler getInventory(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return (IItemHandler)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IItemHandler getInventory(LivingEntity e) {
        try {
            LazyOptional lazy = e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return (IItemHandler)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception xe) {
            return null;
        }
    }

    public static IItemHandler getMCInventory(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(MysticCodeInventoryProvider.MYSTIC_CODE_INVENTORY, null);
            return (IItemHandler)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IItemHandler getInventory(BlockEntity stack) {
        try {
            LazyOptional lazy = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return (IItemHandler)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IGemMahou getGemMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(GemMahouProvider.MAHOU, null);
            return (IGemMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IScrollMahou getScrollMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(ScrollMahouProvider.MAHOU, null);
            return (IScrollMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ICaliburnMahou getCaliburnMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(CaliburnMahouProvider.MAHOU, null);
            return (ICaliburnMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ILanceMahou getLanceMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(LanceMahouProvider.MAHOU, null);
            return (ILanceMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IKodokuMahou getKodokuMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(KodokuMahouProvider.MAHOU, null);
            return (IKodokuMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IWorldMahou getWorldMahou(Level world) {
        try {
            LazyOptional lazy = world.getCapability(WorldMahouProvider.MAHOU, null);
            return (IWorldMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IChunkMahou getChunkMahou(LevelChunk chunk) {
        try {
            LazyOptional lazy = chunk.getCapability(ChunkMahouProvider.MAHOU, null);
            return (IChunkMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isBlockAir(Level world, BlockPos pos) {
        Block b = world.m_8055_(pos).m_60734_();
        return world.m_8055_(pos).m_60795_() || b == Blocks.f_50016_ || b == Blocks.f_50627_ || b == Blocks.f_50626_;
    }

    public static HitResult rayTraceEyes(LivingEntity entity, double length) {
        Vec3 startPos = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
        Vec3 endPos = startPos.m_82549_(new Vec3(entity.m_20154_().f_82479_ * length, entity.m_20154_().f_82480_ * length, entity.m_20154_().f_82481_ * length));
        return entity.f_19853_.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)entity));
    }

    public static boolean isInMurkyWater(Entity entity) {
        double eyes = entity.m_20186_() + (double)entity.m_20192_();
        BlockState state = entity.f_19853_.m_8055_(new BlockPos(entity.m_20299_(1.0f)));
        Block block = state.m_60734_();
        double filled = 0.0;
        if (block instanceof LiquidBlock && (((LiquidBlock)block).getFluid() == ModFluids.MURKY_FLOW.get() || ((LiquidBlock)block).getFluid() == ModFluids.MURKY_STILL.get())) {
            double h;
            filled = h = (double)((LiquidBlock)block).m_5888_(state).m_76182_() + 0.1111111111111111;
        }
        return eyes - Math.floor(eyes) < filled;
    }

    public static Level getWorldFromDimension(ResourceKey<Level> dim, ServerLevel world) {
        return world.m_7654_().m_129880_(dim);
    }

    public static boolean GetIntersection(double fDst1, double fDst2, Vec3 P1, Vec3 P2, Vec3H Hit) {
        if (fDst1 * fDst2 >= 0.0) {
            return false;
        }
        if (fDst1 == fDst2) {
            return false;
        }
        Hit.v = P1.m_82549_(P2.m_82546_(P1).m_82490_(-fDst1 / (fDst2 - fDst1)));
        return true;
    }

    public static boolean InBox(Vec3 Hit, Vec3 B1, Vec3 B2, int Axis) {
        if (Axis == 1 && Hit.f_82481_ > B1.f_82481_ && Hit.f_82481_ < B2.f_82481_ && Hit.f_82480_ > B1.f_82480_ && Hit.f_82480_ < B2.f_82480_) {
            return true;
        }
        if (Axis == 2 && Hit.f_82481_ > B1.f_82481_ && Hit.f_82481_ < B2.f_82481_ && Hit.f_82479_ > B1.f_82479_ && Hit.f_82479_ < B2.f_82479_) {
            return true;
        }
        return Axis == 3 && Hit.f_82479_ > B1.f_82479_ && Hit.f_82479_ < B2.f_82479_ && Hit.f_82480_ > B1.f_82480_ && Hit.f_82480_ < B2.f_82480_;
    }

    public static boolean CheckLineBox(Vec3 B1, Vec3 B2, Vec3 L1, Vec3 L2, Vec3H Hit) {
        if (L2.f_82479_ < B1.f_82479_ && L1.f_82479_ < B1.f_82479_) {
            return false;
        }
        if (L2.f_82479_ > B2.f_82479_ && L1.f_82479_ > B2.f_82479_) {
            return false;
        }
        if (L2.f_82480_ < B1.f_82480_ && L1.f_82480_ < B1.f_82480_) {
            return false;
        }
        if (L2.f_82480_ > B2.f_82480_ && L1.f_82480_ > B2.f_82480_) {
            return false;
        }
        if (L2.f_82481_ < B1.f_82481_ && L1.f_82481_ < B1.f_82481_) {
            return false;
        }
        if (L2.f_82481_ > B2.f_82481_ && L1.f_82481_ > B2.f_82481_) {
            return false;
        }
        if (L1.f_82479_ > B1.f_82479_ && L1.f_82479_ < B2.f_82479_ && L1.f_82480_ > B1.f_82480_ && L1.f_82480_ < B2.f_82480_ && L1.f_82481_ > B1.f_82481_ && L1.f_82481_ < B2.f_82481_) {
            Hit.v = L1;
            return true;
        }
        return Utils.GetIntersection(L1.f_82479_ - B1.f_82479_, L2.f_82479_ - B1.f_82479_, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 1) || Utils.GetIntersection(L1.f_82480_ - B1.f_82480_, L2.f_82480_ - B1.f_82480_, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 2) || Utils.GetIntersection(L1.f_82481_ - B1.f_82481_, L2.f_82481_ - B1.f_82481_, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 3) || Utils.GetIntersection(L1.f_82479_ - B2.f_82479_, L2.f_82479_ - B2.f_82479_, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 1) || Utils.GetIntersection(L1.f_82480_ - B2.f_82480_, L2.f_82480_ - B2.f_82480_, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 2) || Utils.GetIntersection(L1.f_82481_ - B2.f_82481_, L2.f_82481_ - B2.f_82481_, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 3);
    }

    public static boolean CheckLineBox(Vec3 B1, Vec3 B2, Vec3 L1, Vec3 L2) {
        return Utils.CheckLineBox(B1, B2, L1, L2, new Vec3H(L1));
    }

    public static CompoundTag blockposToNBT(BlockPos p, String name) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(name + "_x", p.m_123341_());
        nbt.m_128405_(name + "_y", p.m_123342_());
        nbt.m_128405_(name + "_z", p.m_123343_());
        return nbt;
    }

    public static BlockPos NBTtoBlockPos(CompoundTag nbt, String name) {
        BlockPos ret = null;
        if (nbt.m_128441_(name + "_x") && nbt.m_128441_(name + "_y") && nbt.m_128441_(name + "_z")) {
            ret = new BlockPos(nbt.m_128451_(name + "_x"), nbt.m_128451_(name + "_y"), nbt.m_128451_(name + "_z"));
        }
        return ret;
    }

    public static void writeIntListToBuffer(ByteBuf buf, List<Integer> lst) {
        buf.writeInt(lst.size());
        for (Integer i : lst) {
            buf.writeInt(i.intValue());
        }
    }

    public static List<Integer> readIntListFromBuffer(ByteBuf buf) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        int sz = buf.readInt();
        for (int i = 0; i < sz; ++i) {
            lst.add(buf.readInt());
        }
        return lst;
    }

    public static void color(ItemStack stack, float r, float g, float b, float r2, float g2, float b2) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128350_("mahou_r", r);
        nbt.m_128350_("mahou_g", g);
        nbt.m_128350_("mahou_b", b);
        nbt.m_128350_("mahou_r2", r2);
        nbt.m_128350_("mahou_g2", g2);
        nbt.m_128350_("mahou_b2", b2);
        stack.m_41751_(nbt);
    }

    public static float[] getColor(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return null;
        }
        if (nbt.m_128441_("mahou_r") && nbt.m_128441_("mahou_g") && nbt.m_128441_("mahou_b") && nbt.m_128441_("mahou_r2") && nbt.m_128441_("mahou_g2") && nbt.m_128441_("mahou_b2")) {
            return new float[]{nbt.m_128457_("mahou_r"), nbt.m_128457_("mahou_g"), nbt.m_128457_("mahou_b"), nbt.m_128457_("mahou_r2"), nbt.m_128457_("mahou_g2"), nbt.m_128457_("mahou_b2")};
        }
        return null;
    }

    public static float avgStep(float a, float b, float steps, float step) {
        float diff = Math.abs(b - a);
        float onestep = diff / steps;
        if (a < b) {
            return a + onestep * step;
        }
        return a - onestep * step;
    }

    public static float[][] permute(float[][] in, int offset) {
        float[][] ret = new float[in.length][in[0].length];
        for (int i = 0; i < in.length; ++i) {
            for (int j = 0; j < in[0].length; ++j) {
                ret[Math.floorMod((int)(i + offset), (int)in.length)][j] = in[i][j];
            }
        }
        return ret;
    }

    public static ArrayList<BlockPos> findTilesInRange(LivingEntity player, int range, Predicate<BlockEntity> pred) {
        int bx = (int)(player.m_20182_().f_82479_ - (double)range);
        int bz = (int)(player.m_20182_().f_82481_ - (double)range);
        int tx = (int)(player.m_20182_().f_82479_ + (double)range);
        int tz = (int)(player.m_20182_().f_82481_ + (double)range);
        ChunkPos bp = new ChunkPos(new BlockPos(bx, 0, bz));
        ChunkPos tp = new ChunkPos(new BlockPos(tx, 0, tz));
        ArrayList<BlockPos> lst = new ArrayList<BlockPos>();
        for (int x = bp.f_45578_; x <= tp.f_45578_; ++x) {
            for (int z = bp.f_45579_; z <= tp.f_45579_; ++z) {
                LevelChunk c = player.f_19853_.m_6325_(x, z);
                Map m = c.m_62954_();
                for (BlockPos pos : m.keySet()) {
                    if (!pred.test((BlockEntity)m.get(pos))) continue;
                    lst.add(pos);
                }
            }
        }
        return lst;
    }

    public static double distanceToLine(Vec3 v, Vec3 w, Vec3 p) {
        Vec3 VW = v.m_82546_(w);
        if (VW.m_82556_() == 0.0) {
            return p.m_82554_(v);
        }
        Vec3 z = v.m_82546_(VW.m_82490_(v.m_82546_(p).m_82526_(VW) / VW.m_82526_(VW)));
        double dv = z.m_82557_(v);
        double dw = z.m_82557_(w);
        double dvw = v.m_82557_(w);
        if (dv > dvw) {
            return p.m_82554_(w);
        }
        if (dw > dvw) {
            return p.m_82554_(v);
        }
        return p.m_82554_(z);
    }

    public static Entity selectEntityNearCursor(Player player, double distance, Level world, Predicate<Entity> pred, boolean nearAllowed) {
        Entity ret = null;
        if (player != null) {
            List lst = world.m_6249_((Entity)player, player.m_20191_().m_82400_(distance), pred);
            Vec3 eyes = player.m_20299_(1.0f);
            Vec3 look = player.m_20154_();
            Vec3 sightEnd = eyes.m_82549_(look.m_82490_(distance));
            double minDToLine = Double.MAX_VALUE;
            double minD = Double.MAX_VALUE;
            boolean intersects = false;
            for (Entity e : lst) {
                Vec3 center;
                double dToLine;
                AABB aabb = e.m_20191_();
                double d = e.m_20182_().m_82554_(eyes);
                if (Utils.CheckLineBox(new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_), new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_), eyes, sightEnd)) {
                    intersects = true;
                    if (d < minD && !Utils.blockBetween(eyes, e.m_20191_().m_82399_(), e.f_19853_)) {
                        ret = e;
                        minD = d;
                    }
                }
                if (!nearAllowed || intersects || !((dToLine = Utils.distanceToLine(eyes, sightEnd, center = aabb.m_82399_())) < minDToLine) || Utils.blockBetween(eyes, e.m_20191_().m_82399_(), e.f_19853_) || !EffectUtil.isLookingAtMe(e, (LivingEntity)player, 45)) continue;
                minDToLine = dToLine;
                ret = e;
            }
        }
        return ret;
    }

    public static boolean blockBetween(Vec3 e1, Vec3 e2, Level world) {
        Vec3 subtracted = e2.m_82546_(e1);
        Vec3 unit = subtracted.m_82541_();
        if (subtracted.m_82553_() > 1.0) {
            int i = 0;
            while ((double)i < subtracted.m_82553_()) {
                BlockPos pos = new BlockPos(e1.m_82549_(unit.m_82490_((double)i)));
                BlockState bs = world.m_8055_(pos);
                if (!bs.m_60795_() && !bs.m_60734_().m_7420_(bs, (BlockGetter)world, pos)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public static boolean getPredicate(MAHOU_SELECTION s, Entity e, Player player) {
        return Utils.getPredicate(new HashSet<MAHOU_SELECTION>(Collections.singleton(s)), e, player);
    }

    public static boolean getPredicate(HashSet<MAHOU_SELECTION> set, Entity e, Player player) {
        if (set.contains((Object)MAHOU_SELECTION.SELECTIVE_DISPLACEMENT)) {
            return e != player;
        }
        if (set.contains((Object)MAHOU_SELECTION.SCROLL_PROJECTION)) {
            return e != player && (e instanceof LivingEntity || e instanceof ItemEntity || e instanceof ThrownTrident || e instanceof ItemFrame || e instanceof WeaponProjectileEntity);
        }
        if (set.contains((Object)MAHOU_SELECTION.SCROLL_GEAS)) {
            return e != player && (e instanceof LivingEntity || e instanceof ItemEntity);
        }
        if (set.size() > 0) {
            return e != player && e instanceof LivingEntity;
        }
        return false;
    }

    public static boolean nearAllowed(MAHOU_SELECTION s) {
        return Utils.nearAllowed(new HashSet<MAHOU_SELECTION>(Collections.singleton(s)));
    }

    public static boolean nearAllowed(HashSet<MAHOU_SELECTION> set) {
        return set.contains((Object)MAHOU_SELECTION.SELECTIVE_DISPLACEMENT) || set.contains((Object)MAHOU_SELECTION.SCROLL_RETRIBUTION) || set.contains((Object)MAHOU_SELECTION.SCROLL_POSSESS_ENTITY) || set.contains((Object)MAHOU_SELECTION.SCROLL_DAMAGE_REPLICATION) || set.contains((Object)MAHOU_SELECTION.INSIGHT) || set.contains((Object)MAHOU_SELECTION.WEAPON);
    }

    public static class Vec3H {
        public Vec3 v;

        public Vec3H(Vec3 vec) {
            this.v = vec;
        }
    }

    public static enum MAHOU_SELECTION {
        SELECTIVE_DISPLACEMENT,
        SCROLL_PROJECTION,
        SCROLL_RETRIBUTION,
        SCROLL_POSSESS_ENTITY,
        SCROLL_DAMAGE_REPLICATION,
        SCROLL_IMMUNITY_EXCHANGE,
        SCROLL_GEAS,
        SCROLL_REALITY_MARBLE,
        WEAPON,
        WEAPON_NO_NEAR,
        INSIGHT,
        RIPPER_FOG;

    }
}

