/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.turtleboi.ancientcurses.client.PlayerClientData;

public class TrialEventBar {
    private static final ResourceLocation TRIAL_BOSS_BAR = new ResourceLocation("ancientcurses", "textures/gui/quest_bar.png");

    public static void render(GuiGraphics guiGraphics, int x, int y, Minecraft minecraft) {
        if (minecraft.f_91074_ == null) {
            return;
        }
        String trialType = PlayerClientData.getTrialType();
        if (trialType == null || trialType.equalsIgnoreCase("None")) {
            System.out.println(Component.m_237113_((String)"Removing bar because trial is null"));
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TRIAL_BOSS_BAR);
        int barWidth = 192;
        int barHeight = 9;
        int barBuffer = 5;
        if (minecraft.f_91074_ == null) {
            return;
        }
        int progressWidth = TrialEventBar.getProgress(barWidth, barBuffer);
        guiGraphics.m_280163_(TRIAL_BOSS_BAR, x, y, 0.0f, 0.0f, barWidth, barHeight, barWidth, barHeight * 3);
        if (progressWidth > 0) {
            guiGraphics.m_280163_(TRIAL_BOSS_BAR, x + barBuffer, y, (float)barBuffer, 9.0f, progressWidth, barHeight, barWidth, barHeight * 3);
        }
        if (PlayerClientData.getTrialProgress() >= 1.0f) {
            guiGraphics.m_280163_(TRIAL_BOSS_BAR, x + barBuffer, y, (float)barBuffer, 18.0f, barWidth - barBuffer * 2, barHeight, barWidth, barHeight * 3);
        }
        String displayText = TrialEventBar.getTrialDisplayText();
        int titleWidth = minecraft.f_91062_.m_92895_(displayText);
        int color = 0xFFFFFF;
        if (PlayerClientData.getTrialProgress() >= 1.0f) {
            color = 0xFFAA00;
        }
        guiGraphics.m_280488_(minecraft.f_91062_, displayText, x + barWidth / 2 - titleWidth / 2, y - 9, color);
    }

    private static int getProgress(int barWidth, int barBuffer) {
        float trialProgress = PlayerClientData.getTrialProgress();
        return Mth.m_14167_((float)(trialProgress * (float)(barWidth - barBuffer * 2)));
    }

    private static String getTrialDisplayText() {
        float trialProgress = PlayerClientData.getTrialProgress();
        if (trialProgress < 1.0f) {
            String trialType = PlayerClientData.getTrialType();
            if (trialType.equalsIgnoreCase("SurvivalTrial")) {
                int percentComplete = (int)(PlayerClientData.getTrialProgress() * 100.0f);
                return "Survive: " + percentComplete + "%";
            }
            if (trialType.equalsIgnoreCase("EliminationTrial")) {
                String targetName = PlayerClientData.getEliminationTarget();
                int eliminationCount = PlayerClientData.getEliminationKills();
                int requiredEliminations = PlayerClientData.getEliminationKillsRequired();
                return "Eliminate " + targetName + "s: " + eliminationCount + "/" + requiredEliminations;
            }
            if (trialType.equalsIgnoreCase("FetchTrial")) {
                String fetchItem = PlayerClientData.getFetchItem();
                int fetchItemCount = PlayerClientData.getFetchItems();
                int requiredFetchitems = PlayerClientData.getFetchItemsRequired();
                return "Feed the altar: " + fetchItemCount + "/" + requiredFetchitems + " " + fetchItem;
            }
        } else {
            return "The altar beckons your return...";
        }
        return "";
    }
}

