/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.effect.effects;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.turtleboi.ancientcurses.particle.ModParticleTypes;
import net.turtleboi.ancientcurses.util.AttributeModifierUtil;
import net.turtleboi.ancientcurses.util.ItemValueMap;

public class CurseOfAvariceEffect
extends MobEffect {
    private static final ResourceLocation COGrhealthUpdateTag = new ResourceLocation("ancientcurses", "cogr_healthupdated");
    private static final ResourceLocation COGrlastInventoryValueTag = new ResourceLocation("ancientcurses", "cogr_last_inventory_value");

    public CurseOfAvariceEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        if (pLivingEntity.m_9236_().f_46443_ && pLivingEntity.f_19797_ % 20 == 0) {
            int effectColor = this.m_19484_();
            float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(effectColor & 0xFF) / 255.0f;
            for (int i = 0; i < 5; ++i) {
                pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
            }
        }
        Level level = pLivingEntity.m_9236_();
        if (!level.f_46443_ && pLivingEntity instanceof Player) {
            int lastInventoryValue;
            int currentInventoryValue;
            Player player = (Player)pLivingEntity;
            if (pLivingEntity.f_19797_ % 20 == 0) {
                int effectColor = this.m_19484_();
                float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(effectColor & 0xFF) / 255.0f;
                for (int i = 0; i < 5; ++i) {
                    pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
                }
            }
            if (pAmplifier >= 2 && (currentInventoryValue = CurseOfAvariceEffect.calculatePlayerInventoryValue(player, level)) != (lastInventoryValue = this.getLastInventoryValue(player))) {
                CurseOfAvariceEffect.resetInventoryValue(player);
                this.updatePlayerPenalties(player, currentInventoryValue);
                this.setLastInventoryValue(player, currentInventoryValue);
            }
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            CurseOfAvariceEffect.resetInventoryValue(player);
        }
    }

    public boolean m_6584_(int duration, int pAmplifier) {
        return true;
    }

    public static double getItemDestroyChance(int pAmplifier) {
        double[] itemDestroyChanceValues = new double[]{0.0, 0.075, 0.15};
        int index = Math.min(pAmplifier, itemDestroyChanceValues.length - 1);
        return itemDestroyChanceValues[index];
    }

    private void updatePlayerPenalties(Player player, int inventoryValue) {
        int penaltyMultiplier = inventoryValue / 1000;
        if (penaltyMultiplier > 0) {
            double healthReduction = 2.0 * (double)penaltyMultiplier;
            AttributeModifierUtil.applyTransientModifier(player, Attributes.f_22276_, "COGrMaxHealth", -healthReduction, AttributeModifier.Operation.ADDITION);
            double attackReduction = 1.0 * (double)penaltyMultiplier;
            AttributeModifierUtil.applyTransientModifier(player, Attributes.f_22281_, "COGrAttackDamage", -attackReduction, AttributeModifier.Operation.ADDITION);
            if (!this.isHealthUpdated(player)) {
                this.updatePlayerHealth(player);
            }
        }
    }

    private void updatePlayerHealth(Player player) {
        Level level = player.m_9236_();
        player.m_6469_(level.m_269111_().m_269264_(), 1.0f);
        player.m_5634_(1.0f);
        CurseOfAvariceEffect.setHealthUpdated(player, true);
    }

    private boolean isHealthUpdated(Player player) {
        CompoundTag data = player.getPersistentData();
        return data.m_128471_(COGrhealthUpdateTag.toString());
    }

    private static void setHealthUpdated(Player player, boolean updated) {
        CompoundTag data = player.getPersistentData();
        data.m_128379_(COGrhealthUpdateTag.toString(), updated);
    }

    public static void resetInventoryValue(Player player) {
        AttributeModifierUtil.removeModifier(player, Attributes.f_22276_, "COGrMaxHealth");
        AttributeModifierUtil.removeModifier(player, Attributes.f_22281_, "COGrAttackDamage");
        CurseOfAvariceEffect.setHealthUpdated(player, false);
    }

    private void setLastInventoryValue(Player player, int value) {
        CompoundTag data = player.getPersistentData();
        data.m_128405_(COGrlastInventoryValueTag.toString(), value);
    }

    private int getLastInventoryValue(Player player) {
        CompoundTag data = player.getPersistentData();
        return data.m_128451_(COGrlastInventoryValueTag.toString());
    }

    private static int calculatePlayerInventoryValue(Player player, Level level) {
        int totalValue = 0;
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            if (itemStack.m_41619_()) continue;
            int stackValue = ItemValueMap.getItemValue(itemStack, level);
            totalValue += stackValue * itemStack.m_41613_();
        }
        for (ItemStack armorStack : player.m_6168_()) {
            if (armorStack.m_41619_()) continue;
            int armorValue = ItemValueMap.getItemValue(armorStack, level);
            totalValue += armorValue * armorStack.m_41613_();
        }
        ItemStack offhandStack = player.m_21206_();
        if (!offhandStack.m_41619_()) {
            int offhandValue = ItemValueMap.getItemValue(offhandStack, level);
            totalValue += offhandValue * offhandStack.m_41613_();
        }
        return totalValue;
    }
}

