/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.effect.effects;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.turtleboi.ancientcurses.init.ModAttributes;
import net.turtleboi.ancientcurses.particle.ModParticleTypes;
import net.turtleboi.ancientcurses.util.AttributeModifierUtil;

public class CurseOfFrailtyEffect
extends MobEffect {
    private static final Random random = new Random();
    private int tickCounter = 0;
    private static final ResourceLocation COFhealthUpdateTag = new ResourceLocation("ancientcurses", "cof_healthupdated");

    public CurseOfFrailtyEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        if (pLivingEntity.m_9236_().f_46443_ && pLivingEntity.f_19797_ % 20 == 0) {
            int effectColor = this.m_19484_();
            float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(effectColor & 0xFF) / 255.0f;
            for (int i = 0; i < 5; ++i) {
                pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
            }
        }
        if (!pLivingEntity.m_9236_().f_46443_ && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (pLivingEntity.f_19797_ % 20 == 0) {
                int effectColor = this.m_19484_();
                float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(effectColor & 0xFF) / 255.0f;
                for (int i = 0; i < 5; ++i) {
                    pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
                }
            }
            double healthReduction = this.getHealthReduction(pAmplifier);
            AttributeModifierUtil.applyTransientModifier(player, Attributes.f_22276_, "COFMaxHealth", healthReduction, AttributeModifier.Operation.ADDITION);
            if (!this.isHealthUpdated(player)) {
                this.updatePlayerHealth(player);
            }
            double damageReduction = this.getAttackDamageReduction(pAmplifier);
            AttributeModifierUtil.applyTransientModifier(player, Attributes.f_22281_, "COFAttackDamage", damageReduction, AttributeModifier.Operation.MULTIPLY_BASE);
            if (pAmplifier >= 1) {
                double hitChanceReduction = this.getHitChanceReduction(pAmplifier);
                AttributeModifierUtil.applyTransientModifier(player, (Attribute)ModAttributes.HIT_CHANCE.get(), "COFHitChance", hitChanceReduction, AttributeModifier.Operation.ADDITION);
            }
            if (pAmplifier >= 2) {
                ++this.tickCounter;
                int randomTicks = 5 + random.nextInt(16);
                if (this.tickCounter >= randomTicks) {
                    this.reduceDurability(player);
                    this.tickCounter = 0;
                }
            }
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            AttributeModifierUtil.removeModifier(player, Attributes.f_22276_, "COFMaxHealth");
            AttributeModifierUtil.removeModifier(player, Attributes.f_22281_, "COFAttackDamage");
            AttributeModifierUtil.removeModifier(player, (Attribute)ModAttributes.HIT_CHANCE.get(), "COFHitChance");
            this.setHealthUpdated(player, false);
        }
    }

    public boolean m_6584_(int duration, int pAmplifier) {
        return true;
    }

    public double getHealthReduction(int pAmplifier) {
        double[] healthReductionValues = new double[]{-4.0, -8.0, -16.0};
        int index = Math.min(pAmplifier, healthReductionValues.length - 1);
        return healthReductionValues[index];
    }

    private void updatePlayerHealth(Player player) {
        Level level = player.m_9236_();
        player.m_6469_(level.m_269111_().m_269264_(), 1.0f);
        player.m_5634_(1.0f);
        this.setHealthUpdated(player, true);
    }

    private boolean isHealthUpdated(Player player) {
        CompoundTag data = player.getPersistentData();
        return data.m_128471_(COFhealthUpdateTag.toString());
    }

    private void setHealthUpdated(Player player, boolean updated) {
        CompoundTag data = player.getPersistentData();
        data.m_128379_(COFhealthUpdateTag.toString(), updated);
    }

    public double getAttackDamageReduction(int pAmplifier) {
        double[] attackDamageReuctionValues = new double[]{-0.25, -0.33, -0.5};
        int index = Math.min(pAmplifier, attackDamageReuctionValues.length - 1);
        return attackDamageReuctionValues[index];
    }

    public double getHitChanceReduction(int pAmplifier) {
        double[] hitChanceReductionValues = new double[]{0.0, -0.33, -0.66};
        int index = Math.min(pAmplifier, hitChanceReductionValues.length - 1);
        return hitChanceReductionValues[index];
    }

    private void reduceDurability(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !stack.m_41763_()) continue;
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        }
        for (ItemStack armor : player.m_150109_().f_35975_) {
            if (armor.m_41619_() || !armor.m_41763_()) continue;
            armor.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        }
        ItemStack offhandItem = player.m_21206_();
        if (!offhandItem.m_41619_() && offhandItem.m_41763_()) {
            offhandItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.OFF_HAND));
        }
    }
}

