/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.effect.effects;

import java.util.List;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.turtleboi.ancientcurses.effect.ModEffects;
import net.turtleboi.ancientcurses.network.ModNetworking;
import net.turtleboi.ancientcurses.network.packets.LustedPacketS2C;
import net.turtleboi.ancientcurses.particle.ModParticleTypes;
import net.turtleboi.ancientcurses.util.AttributeModifierUtil;

public class CurseOfObessionEffect
extends MobEffect {
    public CurseOfObessionEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        int i;
        float blue;
        float green;
        float red;
        int effectColor;
        if (pLivingEntity.m_9236_().f_46443_ && pLivingEntity.f_19797_ % 20 == 0) {
            effectColor = this.m_19484_();
            red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
            green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
            blue = (float)(effectColor & 0xFF) / 255.0f;
            for (i = 0; i < 5; ++i) {
                pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
            }
        }
        if (!pLivingEntity.m_9236_().f_46443_) {
            if (pLivingEntity.f_19797_ % 20 == 0) {
                effectColor = this.m_19484_();
                red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
                green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
                blue = (float)(effectColor & 0xFF) / 255.0f;
                for (i = 0; i < 5; ++i) {
                    pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
                }
            }
            if (pLivingEntity instanceof Player) {
                Player player = (Player)pLivingEntity;
                if (pAmplifier >= 1 && this.getLustCooldown(player) <= 0) {
                    if (this.getLustTimer(player) > 0) {
                        this.getNearbyMob(player, pAmplifier);
                        this.forcePOVControl(player);
                        AttributeModifierUtil.applyTransientModifier(player, Attributes.f_22279_, "COLStun", -10.0, AttributeModifier.Operation.ADDITION);
                        if (pAmplifier >= 2) {
                            this.applyBerserkEffect(player);
                        }
                        CurseOfObessionEffect.setLustTimer(player, this.getLustTimer(player) - 1);
                    } else if (this.getLustTimer(player) == 0) {
                        CurseOfObessionEffect.resetLustCooldown(player, pAmplifier);
                    } else {
                        this.triggerLustEffect(player);
                    }
                } else {
                    CurseOfObessionEffect.setLustCooldown(player, this.getLustCooldown(player) - 1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModNetworking.sendToPlayer(new LustedPacketS2C(CurseOfObessionEffect.hasLustTarget(player)), serverPlayer);
                }
            }
            if (pLivingEntity instanceof Monster) {
                Monster monster = (Monster)pLivingEntity;
                CurseOfObessionEffect.applyBerserkAttributes((Mob)monster);
                CurseOfObessionEffect.targetCurseGiver((Mob)monster);
            }
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            AttributeModifierUtil.removeModifier(player, Attributes.f_22279_, "COLStun");
        }
        if (pLivingEntity instanceof Monster) {
            Monster monster = (Monster)pLivingEntity;
            String movementName = "COLMovementSpeed";
            UUID movementUUID = AttributeModifierUtil.generateUUIDFromName(movementName);
            AttributeInstance movementInstance = monster.m_21051_(Attributes.f_22279_);
            if (movementInstance != null) {
                movementInstance.m_22120_(movementUUID);
            }
            String damageName = "COLAttackDamage";
            UUID damageUUID = AttributeModifierUtil.generateUUIDFromName(damageName);
            AttributeInstance damageInstance = monster.m_21051_(Attributes.f_22281_);
            if (damageInstance != null) {
                damageInstance.m_22120_(damageUUID);
            }
        }
    }

    public boolean m_6584_(int duration, int pAmplifier) {
        return true;
    }

    private static int getMinLustTime(int pAmplifier) {
        int[] minLustTimeValues = new int[]{1800, 1200, 600};
        int index = Math.min(pAmplifier, minLustTimeValues.length - 1);
        return minLustTimeValues[index];
    }

    private static int getMaxLustTime(int pAmplifier) {
        int[] maxLustTimeValues = new int[]{2400, 1800, 1200};
        int index = Math.min(pAmplifier, maxLustTimeValues.length - 1);
        return maxLustTimeValues[index];
    }

    private static int getLustTime(int pAmplifier) {
        int[] lustTimeValues = new int[]{20, 100, 200};
        int index = Math.min(pAmplifier, lustTimeValues.length - 1);
        return lustTimeValues[index];
    }

    private static void setLustCooldown(Player player, int cooldown) {
        player.getPersistentData().m_128405_("lustCooldown", cooldown);
    }

    private int getLustCooldown(Player player) {
        return player.getPersistentData().m_128451_("lustCooldown");
    }

    public static void setLustTimer(Player player, int timer) {
        player.getPersistentData().m_128405_("lustTimer", timer);
    }

    private int getLustTimer(Player player) {
        return player.getPersistentData().m_128451_("lustTimer");
    }

    public static boolean hasLustTarget(Player player) {
        return player.getPersistentData().m_128471_("hasLustTarget");
    }

    private void triggerLustEffect(Player player) {
        Mob targetMob = this.getLustTarget(player);
        if (targetMob != null) {
            this.forcePOVControl(player);
            player.getPersistentData().m_128379_("isLusted", true);
        }
    }

    public static void resetLustCooldown(Player player, int pAmplifier) {
        int minLustTime = CurseOfObessionEffect.getMinLustTime(pAmplifier);
        int maxLustTime = CurseOfObessionEffect.getMaxLustTime(pAmplifier);
        CurseOfObessionEffect.setLustTimer(player, 0);
        CurseOfObessionEffect.setLustTimer(player, CurseOfObessionEffect.getLustTime(pAmplifier));
        CurseOfObessionEffect.clearLustTarget(player);
        AttributeModifierUtil.removeModifier(player, Attributes.f_22279_, "COLStun");
        CurseOfObessionEffect.setLustCooldown(player, minLustTime + player.m_217043_().m_188503_(maxLustTime - minLustTime + 1));
    }

    private Mob getNearbyMob(Player player, int pAmplifier) {
        if (CurseOfObessionEffect.hasLustTarget(player)) {
            return this.getLustTarget(player);
        }
        List nearbyMobs = player.m_9236_().m_45976_(Mob.class, player.m_20191_().m_82400_(25.0));
        if (!nearbyMobs.isEmpty()) {
            Mob nearestMob = null;
            double nearestDistance = Double.MAX_VALUE;
            if (pAmplifier >= 2) {
                List nearbyMonsters = player.m_9236_().m_45976_(Monster.class, player.m_20191_().m_82400_(25.0));
                for (Monster monster : nearbyMonsters) {
                    double distanceToMonster = player.m_20280_((Entity)monster);
                    if (!(distanceToMonster < nearestDistance)) continue;
                    nearestDistance = distanceToMonster;
                    nearestMob = monster;
                }
            }
            if (nearestMob == null) {
                for (Mob mob : nearbyMobs) {
                    double distanceToMob = player.m_20280_((Entity)mob);
                    if (!(distanceToMob < nearestDistance)) continue;
                    nearestDistance = distanceToMob;
                    nearestMob = mob;
                }
            }
            if (nearestMob != null) {
                player.getPersistentData().m_128379_("hasLustTarget", true);
                player.getPersistentData().m_128362_("lustTarget", nearestMob.m_20148_());
                return nearestMob;
            }
        }
        return null;
    }

    private Mob getLustTarget(Player player) {
        if (player.getPersistentData().m_128403_("lustTarget")) {
            UUID targetUUID = player.getPersistentData().m_128342_("lustTarget");
            Level level = player.m_9236_();
            Entity entity = ((ServerLevel)level).m_8791_(targetUUID);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                return mob;
            }
            CurseOfObessionEffect.clearLustTarget(player);
        }
        return null;
    }

    public static void clearLustTarget(Player player) {
        player.getPersistentData().m_128473_("lustTarget");
        player.getPersistentData().m_128379_("isLusted", false);
        player.getPersistentData().m_128379_("hasLustTarget", false);
    }

    private void forcePOVControl(Player player) {
        Mob randomMob = this.getLustTarget(player);
        if (randomMob != null) {
            player.m_7618_(EntityAnchorArgument.Anchor.EYES, randomMob.m_146892_());
        }
    }

    private void applyBerserkEffect(Player player) {
        Mob mob = this.getLustTarget(player);
        if (mob instanceof Monster) {
            Monster berserkMob = (Monster)mob;
            berserkMob.m_7292_(new MobEffectInstance((MobEffect)ModEffects.CURSE_OF_OBESSSION.get(), 600, 0));
            CompoundTag data = berserkMob.getPersistentData();
            data.m_128362_("curseoflustgiveruuid", player.m_20148_());
        }
    }

    private static void applyBerserkAttributes(Mob monster) {
        String movementName = "COLMovementSpeed";
        UUID movementUUID = AttributeModifierUtil.generateUUIDFromName(movementName);
        AttributeInstance movementInstance = monster.m_21051_(Attributes.f_22279_);
        if (movementInstance != null) {
            if (movementInstance.m_22111_(movementUUID) != null) {
                movementInstance.m_22120_(movementUUID);
            }
            movementInstance.m_22118_(new AttributeModifier(movementUUID, movementName, 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        String damageName = "COLAttackDamage";
        UUID damageUUID = AttributeModifierUtil.generateUUIDFromName(damageName);
        AttributeInstance damageInstance = monster.m_21051_(Attributes.f_22281_);
        if (damageInstance != null) {
            if (damageInstance.m_22111_(damageUUID) != null) {
                damageInstance.m_22120_(damageUUID);
            }
            damageInstance.m_22118_(new AttributeModifier(damageUUID, damageName, 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    private static void targetCurseGiver(Mob monster) {
        if (monster.getPersistentData().m_128441_("curseoflustgiveruuid")) {
            UUID curseGiverUUID = monster.getPersistentData().m_128342_("curseoflustgiveruuid");
            Player targetPlayer = monster.m_9236_().m_46003_(curseGiverUUID);
            if (targetPlayer != null) {
                monster.m_6710_((LivingEntity)targetPlayer);
            }
        }
    }

    public static void removeTarget(Mob monster) {
        monster.getPersistentData().m_128473_("curseoflustgiveruuid");
        monster.m_6710_(null);
    }
}

