/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.effect.effects;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.ancientcurses.client.PlayerClientData;
import net.turtleboi.ancientcurses.network.ModNetworking;
import net.turtleboi.ancientcurses.network.packets.SleepPacketS2C;
import net.turtleboi.ancientcurses.particle.ModParticleTypes;
import net.turtleboi.ancientcurses.util.AttributeModifierUtil;

public class CurseOfSlothEffect
extends MobEffect {
    private static final Random random = new Random();
    private static final ResourceLocation sleepTicksTag = new ResourceLocation("ancientcurses", "sleep_ticks");
    private static final int sleepDuration = 60;

    public CurseOfSlothEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        if (pLivingEntity.m_9236_().f_46443_) {
            if (PlayerClientData.isAsleep() && (pLivingEntity.f_19797_ % 20 == 0 || pLivingEntity.f_19797_ % 20 == 3 || pLivingEntity.f_19797_ % 20 == 6)) {
                Vec3 lookVector = pLivingEntity.m_20154_();
                double velocityX = lookVector.f_82479_ * 0.05 + 0.1;
                double velocityY = 0.1;
                double velocityZ = lookVector.f_82481_ * 0.05;
                double particleX = pLivingEntity.m_20185_();
                double particleY = pLivingEntity.m_20186_() + (double)pLivingEntity.m_20206_();
                double particleZ = pLivingEntity.m_20189_();
                if (pLivingEntity.f_19797_ % 20 == 0) {
                    pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.SLEEP_PARTICLE.get(), particleX, particleY, particleZ, velocityX * 1.5, velocityY * 1.5, velocityZ * 1.5);
                } else if (pLivingEntity.f_19797_ % 20 == 3) {
                    pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.SLEEP_PARTICLE.get(), particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
                } else if (pLivingEntity.f_19797_ % 20 == 6) {
                    pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.SLEEP_PARTICLE.get(), particleX, particleY, particleZ, velocityX * 0.66, velocityY * 0.66, velocityZ * 0.66);
                }
            }
            if (pLivingEntity.f_19797_ % 20 == 0) {
                int effectColor = this.m_19484_();
                float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(effectColor & 0xFF) / 255.0f;
                for (int i = 0; i < 5; ++i) {
                    pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
                }
            }
        }
        if (!pLivingEntity.m_9236_().f_46443_ && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (pLivingEntity.f_19797_ % 20 == 0) {
                int effectColor = this.m_19484_();
                float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(effectColor & 0xFF) / 255.0f;
                for (int i = 0; i < 5; ++i) {
                    pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
                }
            }
            double movementMultiplier = CurseOfSlothEffect.getMovementMultiplier(pAmplifier);
            AttributeModifierUtil.applyTransientModifier(player, Attributes.f_22279_, "COSMovementSpeed", movementMultiplier, AttributeModifier.Operation.MULTIPLY_BASE);
            double swingSpeedMultiplier = CurseOfSlothEffect.getSwingSpeedMultiplier(pAmplifier);
            AttributeModifierUtil.applyTransientModifier(player, Attributes.f_22283_, "COSSwingSpeed", swingSpeedMultiplier, AttributeModifier.Operation.MULTIPLY_BASE);
            if (pAmplifier >= 1) {
                if (this.isSleeping(player)) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ModNetworking.sendToPlayer(new SleepPacketS2C(true), serverPlayer);
                    }
                    this.makePlayerFallAsleep(player);
                    this.decrementSleepTimer(player);
                } else if (this.shouldFallAsleep(pAmplifier)) {
                    this.setSleepTimer(player, 60);
                }
            }
            if (pAmplifier >= 2) {
                this.limitInventoryToToolbar(player);
            }
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            AttributeModifierUtil.removeModifier(player, Attributes.f_22279_, "COSMovementSpeed");
            AttributeModifierUtil.removeModifier(player, Attributes.f_22283_, "COSSwingSpeed");
            this.wakePlayerUp(player);
        }
    }

    public boolean m_6584_(int duration, int pAmplifier) {
        return true;
    }

    private static double getMovementMultiplier(int pAmplifier) {
        double[] movementSpeedValues = new double[]{-0.5, -0.7, -0.9};
        int index = Math.min(pAmplifier, movementSpeedValues.length - 1);
        return movementSpeedValues[index];
    }

    private static double getSwingSpeedMultiplier(int pAmplifier) {
        double[] swingSpeedValues = new double[]{-0.25, -0.4, -0.66};
        int index = Math.min(pAmplifier, swingSpeedValues.length - 1);
        return swingSpeedValues[index];
    }

    private boolean shouldFallAsleep(int pAmplifier) {
        int chance = pAmplifier == 1 ? 100 : 66;
        return random.nextInt(chance) == 0;
    }

    private void makePlayerFallAsleep(Player player) {
        player.m_6858_(false);
        AttributeModifierUtil.applyTransientModifier(player, Attributes.f_22279_, "COSSleepSpeed", -10.0, AttributeModifier.Operation.ADDITION);
    }

    private boolean isSleeping(Player player) {
        return this.getSleepTimer(player) > 0;
    }

    private void decrementSleepTimer(Player player) {
        int sleepTicks = this.getSleepTimer(player);
        if (sleepTicks > 0) {
            this.setSleepTimer(player, sleepTicks - 1);
            if (sleepTicks == 1) {
                this.wakePlayerUp(player);
            }
        }
    }

    private void wakePlayerUp(Player player) {
        AttributeModifierUtil.removeModifier(player, Attributes.f_22279_, "COSSleepSpeed");
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModNetworking.sendToPlayer(new SleepPacketS2C(false), serverPlayer);
        }
    }

    private int getSleepTimer(Player player) {
        CompoundTag data = player.getPersistentData();
        return data.m_128451_(sleepTicksTag.toString());
    }

    private void setSleepTimer(Player player, int ticks) {
        CompoundTag data = player.getPersistentData();
        data.m_128405_(sleepTicksTag.toString(), ticks);
    }

    private void limitInventoryToToolbar(Player player) {
        for (int i = player.m_150109_().f_35974_.size() - 1; i >= 9; --i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (stack.m_41619_()) continue;
            player.m_36176_(stack, true);
            player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
        }
    }
}

