/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.effect.effects;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ElementalConvergenceEffect
extends MobEffect {
    private static final Random random = new Random();
    private static final Set<MobCategory> ALLOWED_CATEGORIES = EnumSet.of(MobCategory.AMBIENT, MobCategory.CREATURE, MobCategory.AXOLOTLS, MobCategory.UNDERGROUND_WATER_CREATURE, MobCategory.WATER_CREATURE);

    public ElementalConvergenceEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        if (!pLivingEntity.m_9236_().f_46443_ && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            List nearbyEntities = player.m_9236_().m_45976_(Entity.class, player.m_20191_().m_82400_(4.0));
            for (Entity entity : nearbyEntities) {
                MobCategory category;
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity == player || this.isAllowedCategory(category = livingEntity.m_6095_().m_20674_())) continue;
                this.triggerPulse(player, livingEntity);
                livingEntity.m_6469_(player.m_269291_().m_269425_(), 5.0f);
                Vec3 direction = livingEntity.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82542_(1.0, 0.0, 1.0);
                livingEntity.m_20334_(direction.f_82479_, 0.5, direction.f_82481_);
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 40, 0, false, false));
            }
        }
    }

    public boolean m_6584_(int duration, int pAmplifier) {
        return true;
    }

    private void triggerPulse(Player player, LivingEntity livingEntity) {
        MobEffect selectedBuff = null;
        int buffAmplifier = 1;
        int buffDuration = 100;
        int buffChoice = random.nextInt(3);
        switch (buffChoice) {
            case 0: {
                selectedBuff = MobEffects.f_19605_;
                break;
            }
            case 1: {
                selectedBuff = MobEffects.f_19600_;
                break;
            }
            case 2: {
                selectedBuff = MobEffects.f_19596_;
            }
        }
        if (selectedBuff != null) {
            player.m_7292_(new MobEffectInstance(selectedBuff, buffDuration, buffAmplifier, false, false));
        }
        int auraChoice = random.nextInt(3);
        switch (auraChoice) {
            case 0: {
                this.applyFireAura(player, livingEntity);
                break;
            }
            case 1: {
                this.applyLightningAura(player, livingEntity);
                break;
            }
            case 2: {
                this.applyIceAura(player, livingEntity);
            }
        }
    }

    private void applyFireAura(Player player, LivingEntity livingEntity) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ElementalConvergenceEffect.spawnCircularParticles(player, 4.0, (ParticleOptions)ParticleTypes.f_123744_);
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), SoundEvents.f_11923_, SoundSource.HOSTILE, 1.0f, 0.5f);
        }
        livingEntity.m_20254_(3);
    }

    private void applyLightningAura(Player player, LivingEntity livingEntity) {
        ElementalConvergenceEffect.spawnCircularParticles(player, 4.0, (ParticleOptions)ParticleTypes.f_175830_);
        Level level = livingEntity.m_9236_();
        LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, level);
        lightningBolt.m_6034_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        level.m_7967_((Entity)lightningBolt);
    }

    private void applyIceAura(Player player, LivingEntity livingEntity) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ElementalConvergenceEffect.spawnCircularParticles(player, 4.0, (ParticleOptions)ParticleTypes.f_175821_);
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), SoundEvents.f_144205_, SoundSource.HOSTILE, 1.0f, 0.5f);
        }
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1, false, false));
        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 1, false, false));
    }

    public static void spawnCircularParticles(Player player, double radius, ParticleOptions particleType) {
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        double centerX = player.m_20185_();
        double centerY = player.m_20186_() + 1.0;
        double centerZ = player.m_20189_();
        int numParticles = 108;
        double angleStep = 360.0 / (double)numParticles;
        for (int i = 0; i < numParticles; ++i) {
            double angle = Math.toRadians((double)i * angleStep);
            double xOffset = radius * Math.cos(angle);
            double zOffset = radius * Math.sin(angle);
            double x = centerX + xOffset;
            double z = centerZ + zOffset;
            double y = centerY;
            serverLevel.m_8767_(particleType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private boolean isAllowedCategory(MobCategory category) {
        return ALLOWED_CATEGORIES.contains(category);
    }
}

