/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.turtleboi.ancientcurses.entity.ModEntities;
import net.turtleboi.ancientcurses.network.ModNetworking;
import net.turtleboi.ancientcurses.network.packets.PortalOverlayPacketS2C;
import org.joml.Vector3f;

public class CursedPortalEntity
extends Entity {
    private static final EntityDataAccessor<Integer> TEXTURE_INDEX = SynchedEntityData.m_135353_(CursedPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TELEPORT_ENABLED = SynchedEntityData.m_135353_(CursedPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<BlockPos> ALTAR_POS = SynchedEntityData.m_135353_(CursedPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Optional<UUID>> LINKED_PORTAL_UUID = SynchedEntityData.m_135353_(CursedPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final int teleportCooldown = 100;
    private Map<UUID, Integer> playerCooldowns = new HashMap<UUID, Integer>();
    private BlockPos altarPos;
    private CursedPortalEntity linkedPortal;
    private Object owner;
    private int textureTickCounter = 0;
    protected int age;

    public CursedPortalEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TEXTURE_INDEX, (Object)0);
        this.f_19804_.m_135372_(TELEPORT_ENABLED, (Object)false);
        this.f_19804_.m_135372_(ALTAR_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(LINKED_PORTAL_UUID, Optional.empty());
    }

    public void m_8119_() {
        super.m_8119_();
        this.age = this.f_19797_;
        if (this.m_9236_().f_46443_ && this.age % 20 == 0) {
            this.spawnPortalParticles();
        }
        if (!this.m_9236_().f_46443_) {
            this.detectAndApplyScreenEffect();
            this.decrementCooldowns();
            ++this.textureTickCounter;
            int ticksPerFrame = 2;
            if (this.textureTickCounter >= ticksPerFrame) {
                int newIndex = (this.getTextureIndex() + 1) % this.getMaxTextureIndex();
                this.setTextureIndex(newIndex);
                this.textureTickCounter = 0;
            }
            if (this.age == 1) {
                this.playPortalSpawnSound();
            }
            if (this.age % 20 == 0) {
                this.spawnPortalParticles();
            }
            if (this.age % 100 == 0) {
                this.playPortalAmbientSound();
            }
            if (this.isTeleportEnabled()) {
                this.teleportNearbyPlayers();
            }
            if (this.age >= 620) {
                this.m_146870_();
            }
            if (this.getOwner() == null) {
                this.m_146870_();
            }
        }
    }

    public void setOwner(Object pOwner) {
        if (pOwner instanceof Entity || pOwner instanceof BlockEntity) {
            this.owner = pOwner;
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    private void spawnPortalParticles() {
        RandomSource random = this.m_9236_().m_213780_();
        double portalX = this.m_20185_();
        double portalZ = this.m_20189_();
        double portalHeightStart = this.m_20186_();
        int numParticles = 8;
        for (int i = 0; i < numParticles; ++i) {
            double randomY = portalHeightStart + random.m_188500_() * 2.5;
            double randomX = portalX + (random.m_188500_() - 0.5) * 1.25;
            double randomZ = portalZ + (random.m_188500_() - 0.5) * 1.25;
            double velocityX = (random.m_188500_() - 0.5) * 0.05;
            double velocityY = (random.m_188500_() - 0.5) * 0.05;
            double velocityZ = (random.m_188500_() - 0.5) * 0.05;
            this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f), randomX, randomY, randomZ, velocityX, velocityY, velocityZ);
        }
    }

    private void playPortalSpawnSound() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11862_, SoundSource.BLOCKS, 1.0f, this.m_9236_().f_46441_.m_188501_() * 0.2f + 0.5f);
    }

    private void playPortalAmbientSound() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, this.m_9236_().f_46441_.m_188501_() * 0.4f + 0.8f);
    }

    private void playPortalTravelSound(Player player) {
        this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11757_, SoundSource.BLOCKS, 0.75f, this.m_9236_().f_46441_.m_188501_() * 0.2f + 0.5f);
    }

    private void decrementCooldowns() {
        this.playerCooldowns.entrySet().removeIf(entry -> (Integer)entry.getValue() <= 0);
        this.playerCooldowns.replaceAll((uuid, cooldown) -> cooldown - 1);
    }

    private void teleportNearbyPlayers() {
        AABB detectionBox = this.m_20191_();
        List players = this.m_9236_().m_45976_(Player.class, detectionBox);
        for (Player player : players) {
            ServerPlayer serverPlayer;
            UUID playerUUID;
            if (!(player instanceof ServerPlayer) || this.playerCooldowns.getOrDefault(playerUUID = (serverPlayer = (ServerPlayer)player).m_20148_(), 0) > 0) continue;
            if (this.linkedPortal != null && this.linkedPortal.isTeleportEnabled()) {
                this.getLinkedPortal().playerCooldowns.put(playerUUID, 100);
                this.teleportPlayerToPortal(serverPlayer, this.getLinkedPortal().m_20183_(), this.m_9236_());
            } else if (this.altarPos != null) {
                this.teleportPlayerToAltar(serverPlayer, this.altarPos, this.m_9236_());
            }
            this.playerCooldowns.put(playerUUID, 100);
        }
    }

    private void teleportPlayerToPortal(ServerPlayer player, BlockPos portalPos, Level level) {
        player.m_6021_((double)portalPos.m_123341_(), (double)portalPos.m_123342_(), (double)portalPos.m_123343_());
        this.playPortalTravelSound((Player)player);
    }

    public void setLinkedPortal(CursedPortalEntity linkedPortal) {
        this.linkedPortal = linkedPortal;
        if (linkedPortal != null) {
            this.f_19804_.m_135381_(LINKED_PORTAL_UUID, Optional.of(linkedPortal.m_20148_()));
        } else {
            this.f_19804_.m_135381_(LINKED_PORTAL_UUID, Optional.empty());
        }
    }

    public CursedPortalEntity getLinkedPortal() {
        ServerLevel serverLevel;
        Entity entity;
        Level level;
        Optional optionalUUID;
        if (this.linkedPortal == null && (optionalUUID = (Optional)this.f_19804_.m_135370_(LINKED_PORTAL_UUID)).isPresent() && (level = this.m_9236_()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_((UUID)optionalUUID.get())) instanceof CursedPortalEntity) {
            this.linkedPortal = (CursedPortalEntity)entity;
        }
        return this.linkedPortal;
    }

    public static CursedPortalEntity spawnPortal(Level level, BlockPos altarPos, Object owner) {
        CursedPortalEntity portal = new CursedPortalEntity((EntityType)ModEntities.CURSED_PORTAL.get(), level);
        portal.setOwner(owner);
        portal.m_6034_((double)altarPos.m_123341_() + 0.5, altarPos.m_123342_(), (double)altarPos.m_123343_() + 0.5);
        portal.setTeleportEnabled(true);
        level.m_7967_((Entity)portal);
        return portal;
    }

    private void teleportPlayerToAltar(ServerPlayer player, BlockPos altarPos, Level level) {
        BlockPos playerPos = player.m_20183_();
        ServerLevel serverLevel = (ServerLevel)level;
        float yaw = CursedPortalEntity.calculateYawTowardAltar(playerPos, altarPos);
        float pitch = CursedPortalEntity.calculatePitchTowardAltar((Player)player, playerPos, altarPos);
        player.m_264318_(serverLevel, (double)altarPos.m_123341_() + 2.5, (double)altarPos.m_123342_(), (double)altarPos.m_123343_() + 2.5, Set.of(), yaw, pitch);
        this.playPortalTravelSound((Player)player);
    }

    private static float calculateYawTowardAltar(BlockPos playerPos, BlockPos altarPos) {
        double deltaX = (double)altarPos.m_123341_() + 0.5 - (double)playerPos.m_123341_();
        double deltaZ = (double)altarPos.m_123343_() + 0.5 - (double)playerPos.m_123343_();
        return (float)(Math.atan2(deltaZ, deltaX) * 57.29577951308232) - 193.0f;
    }

    private static float calculatePitchTowardAltar(Player player, BlockPos playerPos, BlockPos altarPos) {
        double deltaX = (double)altarPos.m_123341_() + 0.5 - (double)playerPos.m_123341_();
        double deltaZ = (double)altarPos.m_123343_() + 0.5 - (double)playerPos.m_123343_();
        double deltaY = (float)altarPos.m_123342_() - ((float)playerPos.m_123342_() + player.m_20192_());
        double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        return (float)(-(Math.atan2(deltaY, horizontalDistance) * 57.29577951308232));
    }

    public void setTeleportEnabled(boolean enabled) {
        this.f_19804_.m_135381_(TELEPORT_ENABLED, (Object)enabled);
    }

    public boolean isTeleportEnabled() {
        return (Boolean)this.f_19804_.m_135370_(TELEPORT_ENABLED);
    }

    public int getTextureIndex() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_INDEX);
    }

    public void setTextureIndex(int index) {
        this.f_19804_.m_135381_(TEXTURE_INDEX, (Object)index);
    }

    public int getMaxTextureIndex() {
        return 13;
    }

    public void setAltarPos(BlockPos pos) {
        this.altarPos = pos;
    }

    public static CursedPortalEntity spawnPortalNearPlayer(Player player, BlockPos altarPos, Level level, Object owner) {
        BlockPos portalPos = CursedPortalEntity.findRandomValidLocationNearPlayer(player, level);
        if (portalPos != null) {
            CursedPortalEntity portal = new CursedPortalEntity((EntityType)ModEntities.CURSED_PORTAL.get(), level);
            portal.setOwner(owner);
            portal.m_6034_((double)portalPos.m_123341_() + 0.5, (double)portalPos.m_123342_() + 0.5, (double)portalPos.m_123343_() + 0.5);
            portal.setAltarPos(altarPos);
            portal.setTeleportEnabled(true);
            level.m_7967_((Entity)portal);
            return portal;
        }
        player.m_5661_((Component)Component.m_237113_((String)"Portal cannot manifest!").m_130940_(ChatFormatting.RED), true);
        return null;
    }

    private static BlockPos findRandomValidLocationNearPlayer(Player player, Level level) {
        RandomSource random = level.m_213780_();
        BlockPos playerPos = player.m_20183_();
        for (int attempts = 0; attempts < 10; ++attempts) {
            int offsetX = random.m_188503_(7) - 3;
            int offsetZ = random.m_188503_(7) - 3;
            int offsetY = random.m_188503_(3) - 1;
            BlockPos potentialPos = playerPos.m_7918_(offsetX, offsetY, offsetZ);
            if (!CursedPortalEntity.isValidPortalPosition(level, potentialPos) || !CursedPortalEntity.isFarEnoughFromPlayer(playerPos, potentialPos)) continue;
            return potentialPos;
        }
        return null;
    }

    private static boolean isValidPortalPosition(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7494_()).m_60795_();
    }

    private static boolean isFarEnoughFromPlayer(BlockPos playerPos, BlockPos portalPos) {
        double distanceSquared = playerPos.m_123331_((Vec3i)portalPos);
        return distanceSquared >= 4.0;
    }

    private void detectAndApplyScreenEffect() {
        double distanceThreshold = 2.5;
        List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(distanceThreshold));
        for (Player player : players) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            double distance = player.m_20270_((Entity)this);
            float alpha = distance <= 1.0 ? 0.1f : (distance <= distanceThreshold ? 0.1f * (float)(1.0 - (distance - 1.0) / (distanceThreshold - 1.0)) : 0.0f);
            this.sendPortalScreenEffectPacket(serverPlayer, alpha);
        }
    }

    private void sendPortalScreenEffectPacket(ServerPlayer player, float alpha) {
        ModNetworking.sendToPlayer(new PortalOverlayPacketS2C(alpha), player);
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.setTeleportEnabled(pCompound.m_128471_("TeleportEnabled"));
        if (pCompound.m_128441_("AltarPos")) {
            BlockPos pos = BlockPos.m_122022_((long)pCompound.m_128454_("AltarPos"));
            this.setAltarPos(pos);
        }
        if (pCompound.m_128403_("LinkedPortalUUID")) {
            UUID uuid = pCompound.m_128342_("LinkedPortalUUID");
            this.f_19804_.m_135381_(LINKED_PORTAL_UUID, Optional.of(uuid));
        } else {
            this.f_19804_.m_135381_(LINKED_PORTAL_UUID, Optional.empty());
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128379_("TeleportEnabled", this.isTeleportEnabled());
        if (this.altarPos != null) {
            pCompound.m_128356_("AltarPos", this.altarPos.m_121878_());
        }
        Optional linkedPortalUUID = (Optional)this.f_19804_.m_135370_(LINKED_PORTAL_UUID);
        linkedPortalUUID.ifPresent(uuid -> pCompound.m_128362_("LinkedPortalUUID", uuid));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

